/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.lookup;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ShortLookupTable;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.gui.RangeWithColorsParam;
import pixelitor.filters.levels.RGBLookup;
import pixelitor.filters.lookup.FastLookupOp;
import pixelitor.utils.ImageUtils;

public class ColorBalance
extends FilterWithParametrizedGUI {
    private static final int EVERYTHING = 0;
    private static final int SHADOWS = 1;
    private static final int MIDTONES = 2;
    private static final int HIGHLIGHTS = 4;
    private static final int LUT_TABLE_SIZE = 256;
    private IntChoiceParam affectParam = new IntChoiceParam("Affect", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Everything", 0), new IntChoiceParam.Value("Shadows", 1), new IntChoiceParam.Value("Midtones", 2), new IntChoiceParam.Value("Highlights", 4)});
    private RangeParam cyanRedParam = new RangeWithColorsParam(Color.CYAN, Color.RED, "Cyan-Red", -100, 100, 0);
    private RangeParam magentaGreenParam = new RangeWithColorsParam(Color.MAGENTA, Color.GREEN, "Magenta-Green", -100, 100, 0);
    private RangeParam yellowBlueParam = new RangeWithColorsParam(Color.YELLOW, Color.BLUE, "Yellow-Blue", -100, 100, 0);

    public ColorBalance() {
        super("Color Balance");
        this.paramSet = new ParamSet(this.affectParam, this.cyanRedParam, this.magentaGreenParam, this.yellowBlueParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        short s;
        int n;
        short s2 = (short)this.cyanRedParam.getValue();
        short s3 = (short)this.magentaGreenParam.getValue();
        short s4 = (short)this.yellowBlueParam.getValue();
        if (s2 == 0 && s3 == 0 && s4 == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        int n2 = this.affectParam.getValue();
        float[] fArray = new float[256];
        block6: for (int i = 0; i < 256; ++i) {
            switch (n2) {
                case 0: {
                    fArray[i] = 1.0f;
                    continue block6;
                }
                case 1: {
                    fArray[i] = 1.0f - 1.0f * (float)i / 256.0f;
                    continue block6;
                }
                case 4: {
                    fArray[i] = 1.0f * (float)i / 256.0f;
                    continue block6;
                }
                case 2: {
                    int n3 = 128;
                    fArray[i] = i <= n3 ? 2.0f * (float)i / 256.0f : 2.0f * (1.0f - 1.0f * (float)i / 256.0f);
                }
            }
        }
        short[] sArray = new short[256];
        short[] sArray2 = new short[256];
        short[] sArray3 = new short[256];
        if (n2 == 0) {
            for (n = 0; n < 256; n = (int)((short)(n + 1))) {
                s = (short)(n + s2 - s3 / 2 - s4 / 2);
                sArray[n] = s = ImageUtils.limitTo8Bits(s);
                short s5 = (short)(n + s3 - s2 / 2 - s4 / 2);
                sArray2[n] = s5 = ImageUtils.limitTo8Bits(s5);
                short s6 = (short)(n + s4 - s3 / 2 - s2 / 2);
                sArray3[n] = s6 = ImageUtils.limitTo8Bits(s6);
            }
        } else {
            for (n = 0; n < 256; n = (int)((short)(n + 1))) {
                s = (short)((float)n + fArray[n] * (float)(s2 - s3 / 2 - s4 / 2));
                sArray[n] = s = ImageUtils.limitTo8Bits(s);
                short s7 = (short)((float)n + fArray[n] * (float)(s3 - s2 / 2 - s4 / 2));
                sArray2[n] = s7 = ImageUtils.limitTo8Bits(s7);
                short s8 = (short)((float)n + fArray[n] * (float)(s4 - s3 / 2 - s2 / 2));
                sArray3[n] = s8 = ImageUtils.limitTo8Bits(s8);
            }
        }
        RGBLookup rGBLookup = new RGBLookup(sArray, sArray2, sArray3);
        FastLookupOp fastLookupOp = new FastLookupOp((ShortLookupTable)rGBLookup.getLookupOp());
        fastLookupOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

