/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.levels;

import pixelitor.utils.ImageUtils;

public class GrayScaleLookup {
    private static GrayScaleLookup defaultAdjustment = new GrayScaleLookup(0, 255, 0, 255);
    private final short[] mapping = new short[256];

    public GrayScaleLookup(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mapping.length; ++i) {
            double d = (double)(n4 - n3) / (double)(n2 - n);
            double d2 = (double)n3 - d * (double)n;
            this.mapping[i] = (short)ImageUtils.limitTo8Bits((int)(d * (double)i + d2));
        }
    }

    public short mapValue(short s) {
        return this.mapping[s];
    }

    public static GrayScaleLookup getDefaultAdjustment() {
        return defaultAdjustment;
    }
}

