/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.RippleFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.CoupledRangeParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.ReseedNoiseAction;

public class JHWaves
extends FilterWithParametrizedGUI {
    CoupledRangeParam wavelengthParam = new CoupledRangeParam("Wavelength", 1, 200, 20);
    CoupledRangeParam amplitudeParam = new CoupledRangeParam("Amplitude", 0, 200, 10);
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private static IntChoiceParam.Value[] waveTypeChoices = new IntChoiceParam.Value[]{new IntChoiceParam.Value("Sine", 0), new IntChoiceParam.Value("Sawtooth", 1), new IntChoiceParam.Value("Triangle", 2), new IntChoiceParam.Value("Noise", 3)};
    private IntChoiceParam waveType = new IntChoiceParam("Wave Type", waveTypeChoices);
    private RippleFilter filter;

    public JHWaves() {
        super("Waves");
        this.paramSet = new ParamSet(this.wavelengthParam, this.amplitudeParam, this.waveType, this.edgeAction, this.interpolation, new ReseedNoiseAction("Reseed Noise"));
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.amplitudeParam.getFirstValue();
        int n2 = this.amplitudeParam.getSecondValue();
        if (n == 0 && n2 == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new RippleFilter();
        }
        int n3 = this.wavelengthParam.getFirstValue();
        int n4 = this.wavelengthParam.getSecondValue();
        this.filter.setXAmplitude(n);
        this.filter.setXWavelength(n3);
        this.filter.setYAmplitude(n2);
        this.filter.setYWavelength(n4);
        this.filter.setWaveType(this.waveType.getValue());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

