/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.FeedbackFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHVideoFeedback
extends FilterWithParametrizedGUI {
    private RangeParam iterations = new RangeParam("Iterations", 2, 30, 3);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private RangeParam rotationParam = new RangeParam("Rotation (degrees/iteration)", -30, 30, 0);
    private RangeParam zoom = new RangeParam("Zoom (percent/iteration)", -100, -5, -10);
    private RangeParam startOpacity = new RangeParam("Start Opacity (%)", 0, 100, 100);
    private RangeParam endOpacity = new RangeParam("End Opacity (%)", 0, 100, 100);
    private FeedbackFilter filter;

    public JHVideoFeedback() {
        super("Video Feedback");
        this.paramSet = new ParamSet(this.iterations, this.center, this.zoom, this.rotationParam, this.startOpacity, this.endOpacity);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.rotationParam.getValue() == 0 && this.zoom.getValue() == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new FeedbackFilter();
        }
        float f = this.rotationParam.getValueInRadians();
        this.filter.setRotation(f);
        this.filter.setZoom(this.zoom.getValueAsPercentage());
        this.filter.setCentreX(this.center.getRelativeX());
        this.filter.setCentreY(this.center.getRelativeY());
        this.filter.setIterations(this.iterations.getValue());
        this.filter.setStartAlpha(this.startOpacity.getValueAsPercentage());
        this.filter.setEndAlpha(this.endOpacity.getValueAsPercentage());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

