/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.StampFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHStamp
extends FilterWithParametrizedGUI {
    private RangeParam lightDarkBalance = new RangeParam("Light/Dark Balance (%)", 0, 100, 50);
    private RangeParam smoothness = new RangeParam("Smoothness", 0, 50, 25);
    private RangeParam soften = new RangeParam("Soften", 0, 100, 3);
    private ColorParam darkColor = new ColorParam("Dark Color", Color.BLACK, true, false);
    private ColorParam brightColor = new ColorParam("Bright Color", Color.WHITE, true, false);
    private StampFilter filter;

    public JHStamp() {
        super("Stamp");
        this.paramSet = new ParamSet(this.lightDarkBalance, this.smoothness, this.soften, this.brightColor, this.darkColor);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new StampFilter();
        }
        this.filter.setBlack(this.darkColor.getColor().getRGB());
        this.filter.setWhite(this.brightColor.getColor().getRGB());
        this.filter.setRadius(this.smoothness.getValue());
        this.filter.setSoftness(this.soften.getValueAsPercentage());
        this.filter.setThreshold(this.lightDarkBalance.getValueAsPercentage());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

