/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.SparkleFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHSparkle
extends FilterWithParametrizedGUI {
    private BooleanParam lightOnly = new BooleanParam("Light Only", false);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private RangeParam nrOfRays = new RangeParam("Number of Rays", 1, 500, 200);
    private RangeParam radius = new RangeParam("Radius", 1, 500, 50);
    private RangeParam shine = new RangeParam("Shine", 0, 100, 50);
    private RangeParam randomness = new RangeParam("Randomness", 0, 50, 25);
    private ColorParam color = new ColorParam("Color", Color.WHITE, true, false);
    private SparkleFilter filter;

    public JHSparkle() {
        super("Sparkle");
        this.paramSet = new ParamSet(this.center, this.lightOnly, this.color, this.nrOfRays, this.radius, this.shine, this.randomness);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new SparkleFilter();
        }
        this.filter.setLightOnly(this.lightOnly.getValue());
        this.filter.setRelativeCentreX(this.center.getRelativeX());
        this.filter.setRelativeCentreY(this.center.getRelativeY());
        this.filter.setRadius(this.radius.getValue());
        this.filter.setRays(this.nrOfRays.getValue());
        this.filter.setAmount(this.shine.getValue());
        this.filter.setRandomness(this.randomness.getValue());
        this.filter.setColor(this.color.getColor().getRGB());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

