/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.SmartBlurFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class JHSmartBlur
extends FilterWithSOParametrizedGUI {
    private RangeParam radiusParam = new RangeParam("Radius", 0, 100, 0);
    private RangeParam threshold = new RangeParam("Threshold", 0, 255, 50);
    private BooleanParam hpSharpening = BooleanParam.createParamForHPSharpening();
    private SmartBlurFilter filter;

    public JHSmartBlur() {
        super("Smart Blur");
        this.paramSet = new ParamSet(this.radiusParam, this.threshold, this.hpSharpening, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.radiusParam.getValue();
        if (n == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new SmartBlurFilter();
        }
        this.filter.setRadius(n);
        this.filter.setThreshold(this.threshold.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        if (this.hpSharpening.getValue()) {
            bufferedImage2 = ImageUtils.getHighPassSharpenedImage(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }
}

