/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.PlasmaFilter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.GradientParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHPlasma
extends FilterWithParametrizedGUI {
    private RangeParam turbulenceParam = new RangeParam("Turbulence", 0, 600, 100);
    private static final int LESS_COLORS = 0;
    private static final int MORE_COLORS = 1;
    private static final int GRADIENT_COLORS = 2;
    private IntChoiceParam typeParam = new IntChoiceParam("Colors", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Less", 0), new IntChoiceParam.Value("More", 1), new IntChoiceParam.Value("Use Gradient", 2)}, true);
    private ActionParam reseedAction = new ActionParam("Reseed", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JHPlasma.this.filter != null) {
                JHPlasma.this.filter.randomize();
            }
        }
    });
    private PlasmaFilter filter;
    private float[] defaultThumbPositions = new float[]{0.0f, 0.3f, 0.7f, 1.0f};
    private Color[] defaultValues = new Color[]{Color.BLACK, Color.RED, Color.ORANGE, Color.YELLOW};
    private GradientParam gradientParam = new GradientParam("Gradient", this.defaultThumbPositions, this.defaultValues);

    public JHPlasma() {
        super("Plasma");
        this.paramSet = new ParamSet(this.turbulenceParam, this.typeParam, this.gradientParam, this.reseedAction);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        float f = this.turbulenceParam.getValueAsPercentage();
        if (this.filter == null) {
            this.filter = new PlasmaFilter();
        }
        this.filter.setLessColors(this.typeParam.getValue() != 1);
        this.filter.setTurbulence(f);
        this.filter.setUseColormap(this.typeParam.getValue() == 2);
        this.filter.setColormap(this.gradientParam.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

