/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.BlockFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.impl.BrickBlockFilter;
import pixelitor.utils.ImageUtils;

public class JHPixelate
extends FilterWithParametrizedGUI {
    private static final int STYLE_FLAT = 0;
    private static final int STYLE_3D = 1;
    private static final int STYLE_EMBEDDED = 2;
    private static final int STYLE_GRID_ONLY = 3;
    private static final int TYPE_SQUARE = 0;
    private static final int TYPE_BRICK = 1;
    private IntChoiceParam typeParam = new IntChoiceParam("Type", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Squares", 0), new IntChoiceParam.Value("Brick Wall", 1)});
    private IntChoiceParam styleParam = new IntChoiceParam("Style", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Flat", 0), new IntChoiceParam.Value("3D", 1), new IntChoiceParam.Value("Embedded", 2), new IntChoiceParam.Value("Grid", 3)});
    private RangeParam cellSizeParam = new RangeParam("Cell Size", 3, 200, 20);
    private BlockFilter blockFilter;
    private BrickBlockFilter brickBlockFilter;

    public JHPixelate() {
        super("Pixelate");
        this.paramSet = new ParamSet(this.cellSizeParam, this.styleParam, this.typeParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.styleParam.getValue();
        int n2 = this.typeParam.getValue();
        int n3 = this.cellSizeParam.getValue();
        if (n == 0 || n == 1 || n == 2) {
            if (n2 == 0) {
                if (this.blockFilter == null) {
                    this.blockFilter = new BlockFilter();
                }
                this.blockFilter.setBlockSize(n3);
                bufferedImage2 = this.blockFilter.filter(bufferedImage, bufferedImage2);
            } else if (n2 == 1) {
                if (this.brickBlockFilter == null) {
                    this.brickBlockFilter = new BrickBlockFilter();
                }
                this.brickBlockFilter.setHorizontalBlockSize(n3 * 2);
                this.brickBlockFilter.setVerticalBlockSize(n3);
                bufferedImage2 = this.brickBlockFilter.filter(bufferedImage, bufferedImage2);
            }
        }
        if (n == 1 || n == 3 || n == 2) {
            int n4 = bufferedImage2.getWidth();
            int n5 = bufferedImage2.getHeight();
            int n6 = bufferedImage.getType();
            BufferedImage bufferedImage3 = n == 2 ? bufferedImage2 : JHPixelate.createBumpSource(n2, n3, n4, n5, n6);
            if (n == 1 || n == 2) {
                bufferedImage2 = ImageUtils.bumpMap(bufferedImage2, bufferedImage3);
            } else if (n == 3) {
                bufferedImage2 = ImageUtils.bumpMap(bufferedImage, bufferedImage3);
            } else {
                throw new IllegalStateException();
            }
        }
        return bufferedImage2;
    }

    private static BufferedImage createBumpSource(int n, int n2, int n3, int n4, int n5) {
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n5);
        int n6 = n2 < 15 ? 1 : 2;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n3, n4);
        graphics2D.setColor(Color.GRAY);
        if (n == 0) {
            ImageUtils.drawGrid(graphics2D, n3, n4, n6, n2, n6, n2);
        } else if (n == 1) {
            ImageUtils.drawBrickGrid(graphics2D, n2, n3, n4);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

