/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.EmbossFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ElevationAngleParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHEmboss
extends FilterWithParametrizedGUI {
    private static final double INTUITIVE_RADIANS_30 = -0.54;
    private AngleParam lightDirection = new AngleParam("Light Direction (Azimuth) - Degrees", 0.0);
    private ElevationAngleParam lightElevation = new ElevationAngleParam("Light Elevation Angle - Degrees", -0.54);
    private RangeParam bumpHeight = new RangeParam("Depth", 2, 500, 100);
    private BooleanParam texture = new BooleanParam("Texture (Multiply with the Source Image)", false);
    private EmbossFilter filter;

    public JHEmboss() {
        super("Emboss");
        this.paramSet = new ParamSet(this.lightDirection, this.lightElevation, this.bumpHeight, this.texture);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new EmbossFilter();
        }
        this.filter.setAzimuth((float)this.lightDirection.getValueInIntuitiveRadians());
        this.filter.setBumpHeight(this.bumpHeight.getValueAsPercentage());
        this.filter.setElevation((float)this.lightElevation.getValueInIntuitiveRadians());
        this.filter.setEmboss(this.texture.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

