/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.OilFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHDryBrush
extends FilterWithParametrizedGUI {
    private RangeParam brushSize = new RangeParam("Brush Size", 0, 5, 0);
    private RangeParam numberOfLevels = new RangeParam("Coarseness", 1, 255, 128);
    private OilFilter filter;

    public JHDryBrush() {
        super("Dry Brush");
        this.paramSet = new ParamSet(this.brushSize, this.numberOfLevels);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.brushSize.getValue();
        if (n == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new OilFilter();
        }
        this.filter.setRange(n);
        this.filter.setLevels(this.numberOfLevels.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

