/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.ShadowFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHDropShadow
extends FilterWithParametrizedGUI {
    private AngleParam angle = new AngleParam("Angle", 0.7853981634);
    private RangeParam distance = new RangeParam("Distance", 0, 100, 10);
    private RangeParam opacity = new RangeParam("Opacity (%)", 0, 100, 90);
    private RangeParam softness = new RangeParam("Softness", 0, 25, 10);
    private BooleanParam shadowOnly = new BooleanParam("Shadow Only", false);
    private ColorParam color = new ColorParam("Color", Color.BLACK, false, false);
    private ShadowFilter filter;

    public JHDropShadow() {
        super("Drop Shadow");
        this.paramSet = new ParamSet(this.angle, this.distance, this.opacity, this.softness, this.color, this.shadowOnly);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new ShadowFilter();
        }
        this.filter.setAddMargins(false);
        this.filter.setAngle((float)this.angle.getValueInIntuitiveRadians());
        this.filter.setDistance(this.distance.getValue());
        this.filter.setRadius(this.softness.getValue());
        this.filter.setOpacity(this.opacity.getValueAsPercentage());
        this.filter.setShadowColor(this.color.getColor().getRGB());
        this.filter.setShadowOnly(this.shadowOnly.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public void setSoftness(int n) {
        this.softness.setValue(n);
    }

    public void setDistance(int n) {
        this.distance.setValue(n);
    }

    public void setOpacity(float f) {
        this.opacity.setValue((int)(100.0f * f));
    }
}

