/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.utils.IconUtils;

public class ParamSet
implements Iterable<GUIParam> {
    private List<GUIParam> paramList = new ArrayList<GUIParam>();
    private ParamAdjustmentListener adjustmentListener;

    public ParamSet(GUIParam ... gUIParamArray) {
        this.paramList.addAll(Arrays.asList(gUIParamArray));
        this.init();
    }

    public ParamSet(GUIParam gUIParam) {
        this.paramList.add(gUIParam);
        this.init();
    }

    private void init() {
        if (this.paramList.size() > 1) {
            this.addRandomizeAction();
            this.addResetAllAction();
        }
    }

    private void addRandomizeAction() {
        ActionParam actionParam = new ActionParam("Randomize Settings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParamSet.this.randomize();
            }
        });
        this.paramList.add(actionParam);
    }

    private void addResetAllAction() {
        ActionParam actionParam = new ActionParam("Reset All", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParamSet.this.reset();
            }
        }, IconUtils.getWestArrowIcon());
        this.paramList.add(actionParam);
    }

    @Override
    public Iterator<GUIParam> iterator() {
        return this.paramList.iterator();
    }

    public void reset() {
        for (GUIParam gUIParam : this.paramList) {
            gUIParam.reset(false);
        }
    }

    public void randomize() {
        for (GUIParam gUIParam : this.paramList) {
            gUIParam.randomize();
        }
    }

    public void startPresetAdjusting() {
        for (GUIParam gUIParam : this.paramList) {
            gUIParam.setDontTrigger(true);
        }
    }

    public void endPresetAdjusting(boolean bl) {
        for (GUIParam gUIParam : this.paramList) {
            gUIParam.setDontTrigger(false);
        }
        if (bl && this.adjustmentListener != null) {
            this.adjustmentListener.paramAdjusted();
        }
    }

    public void adjustmentListener(ParamAdjustmentListener paramAdjustmentListener) {
        this.adjustmentListener = paramAdjustmentListener;
        for (GUIParam gUIParam : this.paramList) {
            gUIParam.setAdjustmentListener(paramAdjustmentListener);
        }
    }
}

