/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import com.bric.swing.ColorPicker;
import com.bric.swing.ColorSwatch;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import pixelitor.PixelitorWindow;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamGUI;

public class ColorSelector
extends JPanel
implements ParamGUI {
    private ColorParam model;
    private ColorSwatch colorSwatch;
    private static final int BUTTON_SIZE = 30;

    public ColorSelector(ColorParam colorParam) {
        this.model = colorParam;
        this.setLayout(new FlowLayout(0));
        this.colorSwatch = new ColorSwatch(colorParam.getColor(), 30);
        this.add(this.colorSwatch);
        this.colorSwatch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ColorSelector.this.showColorDialog();
            }
        });
    }

    public void showColorDialog() {
        Color color = ColorPicker.showDialog(PixelitorWindow.getInstance(), "Select " + this.model.getName(), this.model.getColor(), this.model.allowOpacity());
        if (color != null) {
            this.colorSwatch.setForeground(color);
            this.colorSwatch.paintImmediately(0, 0, 30, 30);
            this.model.setColor(color);
        }
    }

    @Override
    public void updateGUI() {
        this.colorSwatch.setForeground(this.model.getColor());
    }
}

