/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.convolve;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pixelitor.ExceptionHandler;
import pixelitor.filters.convolve.Convolve;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.utils.NotANumberException;
import pixelitor.utils.Utils;

public class CustomConvolveAdjustments
extends AdjustPanel
implements ActionListener {
    private static final int TEXTFIELD_PREFERRED_WIDTH = 70;
    private JTextField[] textFields;
    private JPanel textFieldsPanel;
    private JButton normalizeButton;
    private Box presetsBox;
    private int size;

    public CustomConvolveAdjustments(Convolve convolve) {
        super(convolve);
        this.setLayout(new BoxLayout(this, 0));
        this.size = convolve.getSize();
        this.initLeftVerticalBox(convolve);
        this.initPresetBox();
        this.reset(this.size);
    }

    /*
     * WARNING - void declaration
     */
    private void initLeftVerticalBox(Convolve convolve) {
        Serializable serializable2;
        void object;
        Box box = Box.createVerticalBox();
        this.textFieldsPanel = new JPanel();
        this.textFields = new JTextField[this.size * this.size];
        boolean i = false;
        while (object < this.textFields.length) {
            this.textFields[object] = new JTextField();
            ++object;
        }
        this.textFieldsPanel.setLayout(new GridLayout(this.size, this.size));
        for (Serializable serializable2 : this.textFields) {
            this.setupTextField((JTextField)serializable2);
        }
        this.textFieldsPanel.setBorder(BorderFactory.createTitledBorder("Kernel"));
        this.textFieldsPanel.setAlignmentX(0.0f);
        box.add(this.textFieldsPanel);
        Dimension dimension = this.textFieldsPanel.getMinimumSize();
        this.textFieldsPanel.setPreferredSize(new Dimension(this.size * 70, dimension.height));
        this.normalizeButton = new JButton("Normalize (preserve brightness)");
        this.normalizeButton.addActionListener(this);
        this.normalizeButton.setAlignmentX(0.0f);
        box.add(this.normalizeButton);
        JButton jButton = new JButton("Try");
        jButton.addActionListener(this);
        box.add(jButton);
        box.add(Box.createVerticalStrut(20));
        JLabel jLabel = new JLabel("Convolution method:", 2);
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        serializable2 = convolve.getConvolveMethodModel();
        JComboBox jComboBox = new JComboBox(serializable2);
        jComboBox.setAlignmentX(0.0f);
        box.add(jComboBox);
        jComboBox.addActionListener(this);
        box.setMaximumSize(box.getPreferredSize());
        box.setAlignmentY(0.0f);
        this.add(box);
    }

    private void initPresetBox() {
        this.presetsBox = Box.createVerticalBox();
        this.presetsBox.setBorder(BorderFactory.createTitledBorder("Presets"));
        if (this.size == 3) {
            this.init3x3Presets();
        } else if (this.size == 5) {
            this.init5x5Presets();
        } else {
            throw new IllegalStateException("size = " + this.size);
        }
        this.presetsBox.add(Box.createVerticalStrut(20));
        JButton jButton = new JButton("Randomize");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomConvolveAdjustments.this.setValues(Convolve.getRandomKernelMatrix(CustomConvolveAdjustments.this.size));
                CustomConvolveAdjustments.this.actionPerformed(actionEvent);
            }
        });
        this.presetsBox.add(jButton);
        JButton jButton2 = new JButton("Do Nothing");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomConvolveAdjustments.this.reset(CustomConvolveAdjustments.this.size);
                CustomConvolveAdjustments.this.actionPerformed(actionEvent);
            }
        });
        this.presetsBox.add(jButton2);
        this.presetsBox.setMaximumSize(this.presetsBox.getPreferredSize());
        this.presetsBox.setAlignmentY(0.0f);
        this.add(this.presetsBox);
    }

    private void initPreset(String string, final float[] fArray) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomConvolveAdjustments.this.setValues(fArray);
                CustomConvolveAdjustments.this.actionPerformed(actionEvent);
            }
        });
        this.presetsBox.add(jButton);
    }

    private void init5x5Presets() {
        this.initPreset("Diamond Blur", new float[]{0.0f, 0.0f, 0.077f, 0.0f, 0.0f, 0.0f, 0.077f, 0.077f, 0.077f, 0.0f, 0.077f, 0.077f, 0.077f, 0.077f, 0.077f, 0.0f, 0.077f, 0.077f, 0.077f, 0.0f, 0.0f, 0.0f, 0.077f, 0.0f, 0.0f});
        this.initPreset("Motion Blur", new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.2f, 0.0f, 0.0f, 0.0f, 0.2f, 0.0f, 0.0f, 0.0f, 0.2f, 0.0f, 0.0f, 0.0f, 0.2f, 0.0f, 0.0f, 0.0f, 0.2f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.initPreset("Find Diagonal Edges", new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.0f, 0.0f, 0.0f, 6.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.initPreset("Sharpen", new float[]{-0.125f, -0.125f, -0.125f, -0.125f, -0.125f, -0.125f, 0.25f, 0.25f, 0.25f, -0.125f, -0.125f, 0.25f, 1.0f, 0.25f, -0.125f, -0.125f, 0.25f, 0.25f, 0.25f, -0.125f, -0.125f, -0.125f, -0.125f, -0.125f, -0.125f});
    }

    private void init3x3Presets() {
        this.initPreset("\"Corner\" Blur", new float[]{0.25f, 0.0f, 0.25f, 0.0f, 0.0f, 0.0f, 0.25f, 0.0f, 0.25f});
        this.initPreset("\"Gaussian\" Blur", new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f});
        this.initPreset("Mean Filter", new float[]{0.1115f, 0.1115f, 0.1115f, 0.1115f, 0.1115f, 0.1115f, 0.1115f, 0.1115f, 0.1115f});
        this.initPreset("Sharpen", new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f});
        this.initPreset("Edge Detection", new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f});
        this.initPreset("Emboss", new float[]{-2.0f, -2.0f, 0.0f, -2.0f, 6.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.initPreset("Emboss 2", new float[]{-2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f});
        this.initPreset("Color Emboss", new float[]{-1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f});
    }

    private void reset(int n) {
        float[] fArray = new float[n * n];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = 0.0f;
        }
        fArray[fArray.length / 2] = 1.0f;
        this.setValues(fArray);
    }

    private void setupTextField(JTextField jTextField) {
        this.textFieldsPanel.add(jTextField);
        jTextField.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        float f = 0.0f;
        float[] fArray = new float[this.size * this.size];
        for (n = 0; n < fArray.length; ++n) {
            String string = this.textFields[n].getText();
            try {
                fArray[n] = Utils.string2float(string);
            }
            catch (NotANumberException notANumberException) {
                ExceptionHandler.showErrorDialog(notANumberException.getTitleMessage(), notANumberException.getMessage());
            }
            f += fArray[n];
        }
        this.enableNormalizeButton(f);
        if (actionEvent.getSource() == this.normalizeButton && f != 0.0f) {
            n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] / f;
            }
            this.setValues(fArray);
        }
        Convolve convolve = (Convolve)this.op;
        convolve.setKernelMatrix(fArray);
        super.executeFilterPreview();
    }

    private void setValues(float[] fArray) {
        assert (fArray.length == this.size * this.size);
        float f = 0.0f;
        for (int i = 0; i < this.textFields.length; ++i) {
            JTextField jTextField = this.textFields[i];
            jTextField.setText(Utils.float2String(fArray[i]));
            f += fArray[i];
        }
        this.enableNormalizeButton(f);
    }

    private void enableNormalizeButton(float f) {
        boolean bl = f < -0.003f || f > 0.003f;
        boolean bl2 = f < 0.997f || f > 1.003f;
        this.normalizeButton.setEnabled(bl && bl2);
    }
}

