/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.comp;

import pixelitor.Composition;
import pixelitor.filters.comp.CompOperation;
import pixelitor.history.OneLayerUndoableEdit;
import pixelitor.layers.ContentLayer;
import pixelitor.layers.Layer;

public class Flip
extends CompOperation {
    private Direction direction;
    private static Flip horizontalFlip = new Flip(Direction.HORIZONTAL);
    private static Flip verticalFlip = new Flip(Direction.VERTICAL);

    public static Flip createFlipOp(Direction direction) {
        if (direction == Direction.HORIZONTAL) {
            return horizontalFlip;
        }
        if (direction == Direction.VERTICAL) {
            return verticalFlip;
        }
        throw new IllegalStateException("should not get here");
    }

    private Flip(Direction direction) {
        super(direction.getName());
        this.direction = direction;
    }

    @Override
    public void transform(Composition composition) {
        OneLayerUndoableEdit.createAndAddToHistory(composition, "Flip", true, false);
        int n = composition.getNrLayers();
        for (int i = 0; i < n; ++i) {
            Layer layer = composition.getLayer(i);
            if (!(layer instanceof ContentLayer)) continue;
            ContentLayer contentLayer = (ContentLayer)layer;
            contentLayer.flip(this.direction);
        }
        composition.setDirty(true);
        composition.imageChanged(true, false);
    }

    public static enum Direction {
        HORIZONTAL{

            @Override
            public String getName() {
                return "Flip Horizontal";
            }
        }
        ,
        VERTICAL{

            @Override
            public String getName() {
                return "Flip Vertical";
            }
        };


        public abstract String getName();
    }
}

