/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.impl.MagnifyFilter;

public class Magnify
extends FilterWithParametrizedGUI {
    private RangeParam magnification = new RangeParam("Magnification (%)", 1, 500, 100);
    private RangeParam radius = new RangeParam("Radius", 50, 200, 100);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private MagnifyFilter filter;

    public Magnify() {
        super("Magnify");
        this.paramSet = new ParamSet(this.magnification, this.radius, this.center, this.edgeAction, this.interpolation);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new MagnifyFilter();
        }
        this.filter.setCenterX(this.center.getRelativeX());
        this.filter.setCenterY(this.center.getRelativeY());
        this.filter.setRadius(this.radius.getValue());
        this.filter.setMagnification(this.magnification.getValueAsPercentage());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

