/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import pixelitor.AppLogic;
import pixelitor.ChangeReason;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.RepeatLastOp;
import pixelitor.layers.Layers;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.Utils;

public abstract class Filter
extends AbstractAction
implements Comparable<Filter> {
    protected boolean copySrcToDstBeforeRunning = false;

    protected Filter(String string) {
        this(string, null);
    }

    protected Filter(String string, Icon icon) {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.putValue("SmallIcon", icon);
        this.putValue("Name", string);
        FilterUtils.addFilter(this);
    }

    public String getMenuName() {
        return (String)this.getValue("Name");
    }

    void setMenuName(String string) {
        this.putValue("Name", string);
    }

    public String getName() {
        return this.getMenuName();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!Layers.activeIsImageLayer()) {
            ExceptionHandler.showNotImageLayerDialog();
            return;
        }
        this.execute(ChangeReason.OP_WITHOUT_DIALOG);
    }

    public String toString() {
        return this.getMenuName();
    }

    protected boolean copyContents() {
        return this.copySrcToDstBeforeRunning;
    }

    protected boolean createDefaultDestBuffer() {
        return true;
    }

    public void executeWithBusyCursor(final ChangeReason changeReason, Component component) {
        try {
            String string;
            final Composition composition = AppLogic.getActiveComp();
            if (composition == null) {
                ExceptionHandler.showErrorDialog("Error", "No active composition found while executing " + this.getName());
                return;
            }
            if (changeReason == ChangeReason.OP_PREVIEW) {
                composition.getActiveImageLayer().startNewPreviewFromDialog();
            } else {
                FilterUtils.setLastExecutedFilter(this);
            }
            long l = System.nanoTime();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BufferedImage bufferedImage = composition.getImageOrSubImageIfSelectedForActiveLayer(false, true);
                    BufferedImage bufferedImage2 = Filter.this.executeForOneLayer(bufferedImage);
                    assert (bufferedImage2 != null);
                    if (changeReason == ChangeReason.OP_PREVIEW) {
                        composition.changePreviewImage(bufferedImage2);
                    } else if (changeReason == ChangeReason.OP_WITHOUT_DIALOG) {
                        composition.changeImageSimpleFilterFinished(bufferedImage2, changeReason, Filter.this.getName());
                    } else if (changeReason == ChangeReason.PERFORMANCE_TEST) {
                        composition.changeImageSimpleFilterFinished(bufferedImage2, changeReason, Filter.this.getName());
                    } else {
                        throw new IllegalStateException(changeReason.toString());
                    }
                }
            };
            Utils.executeWithBusyCursor(component, runnable, false);
            long l2 = (System.nanoTime() - l) / 1000000L;
            if (l2 < 1000L) {
                string = this.getMenuName() + " took " + l2 + " ms";
            } else {
                float f = (float)l2 / 1000.0f;
                string = String.format("%s took %.1f s", this.getMenuName(), Float.valueOf(f));
            }
            AppLogic.setStatusMessage(string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(PixelitorWindow.getInstance(), "Not enough memory. Try increasing the maximal memory available to this application with -Xmx", "Out of memory error", 0);
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
        RepeatLastOp.INSTANCE.setMenuName("Repeat " + this.getMenuName());
    }

    public void execute(ChangeReason changeReason) {
        this.executeWithBusyCursor(changeReason, PixelitorWindow.getInstance());
    }

    public BufferedImage executeForOneLayer(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        if (this.createDefaultDestBuffer()) {
            bufferedImage2 = this.copyContents() ? ImageUtils.copyImage(bufferedImage) : new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        }
        bufferedImage2 = this.transform(bufferedImage, bufferedImage2);
        assert (bufferedImage2 != null);
        return bufferedImage2;
    }

    protected abstract BufferedImage transform(BufferedImage var1, BufferedImage var2);

    @Override
    public int compareTo(Filter filter) {
        String string = this.getMenuName();
        String string2 = filter.getMenuName();
        return string.compareTo(string2);
    }

    public abstract void randomizeSettings();
}

