/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pixelitor.FillType;
import pixelitor.PixelitorWindow;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.IntTextField;
import pixelitor.utils.OKCancelDialog;

public final class NewImage {
    private static int untitledCount = 1;
    private static Dimension lastNew = AppPreferences.loadNewImageSize();

    private NewImage() {
    }

    public static void addNewImage(FillType fillType, int n, int n2, String string) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        NewImage.fillImage(bufferedImage, fillType);
        PixelitorWindow.getInstance().addNewImage(bufferedImage, null, string);
    }

    private static void fillImage(BufferedImage bufferedImage, FillType fillType) {
        if (fillType == FillType.TRANSPARENT) {
            return;
        }
        Color color = fillType.getColor();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
    }

    private static void showInDialog() {
        final NewImagePanel newImagePanel = new NewImagePanel(NewImage.lastNew.width, NewImage.lastNew.height);
        OKCancelDialog oKCancelDialog = new OKCancelDialog((JComponent)newImagePanel, "New Image"){

            @Override
            public void dialogAccepted() {
                super.dialogAccepted();
                int n = newImagePanel.getSelectedWidth();
                int n2 = newImagePanel.getSelectedHeight();
                FillType fillType = newImagePanel.getSelectedBackground();
                String string = "Untitled" + untitledCount;
                NewImage.addNewImage(fillType, n, n2, string);
                untitledCount++;
                lastNew.width = n;
                lastNew.height = n2;
                this.dispose();
            }

            @Override
            public void dialogCancelled() {
                super.dialogCancelled();
                this.dispose();
            }
        };
        oKCancelDialog.setVisible(true);
    }

    public static Action getAction() {
        return new AbstractAction("New Image..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewImage.showInDialog();
            }
        };
    }

    public static Dimension getLastNew() {
        return lastNew;
    }

    private static class NewImagePanel
    extends JPanel {
        private final JTextField widthTextField;
        private final JTextField heightTextField;
        private static final int WIDGET_DISTANCE = 5;
        private JComboBox backgroundSelector;

        private NewImagePanel(int n, int n2) {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagHelper.addLabel((Container)this, "Width:", 0, 0);
            this.widthTextField = new IntTextField(String.valueOf(n));
            GridBagHelper.addControl(this, this.widthTextField);
            GridBagHelper.addLabel((Container)this, "Height:", 0, 1);
            this.heightTextField = new IntTextField(String.valueOf(n2));
            GridBagHelper.addControl(this, this.heightTextField);
            GridBagHelper.addLabel((Container)this, "Fill:", 0, 2);
            this.backgroundSelector = new JComboBox<FillType>(FillType.values());
            GridBagHelper.addControl(this, this.backgroundSelector);
        }

        private int getSelectedWidth() {
            return Integer.parseInt(this.widthTextField.getText());
        }

        private int getSelectedHeight() {
            return Integer.parseInt(this.heightTextField.getText());
        }

        private FillType getSelectedBackground() {
            return (FillType)((Object)this.backgroundSelector.getSelectedItem());
        }
    }
}

