/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pixelitor.AppLogic;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.OKCancelDialog;
import pixelitor.utils.SliderSpinner;

public class EnlargeCanvas {
    private EnlargeCanvas() {
    }

    private static void showInDialog() {
        final EnlargeCanvasPanel enlargeCanvasPanel = new EnlargeCanvasPanel();
        OKCancelDialog oKCancelDialog = new OKCancelDialog((JComponent)enlargeCanvasPanel, "Enlarge Canvas"){

            @Override
            protected void dialogAccepted() {
                super.dialogAccepted();
                AppLogic.getActiveComp().enlargeCanvas(enlargeCanvasPanel.getNorth(), enlargeCanvasPanel.getEast(), enlargeCanvasPanel.getSouth(), enlargeCanvasPanel.getWest());
                this.dispose();
            }

            @Override
            protected void dialogCancelled() {
                super.dialogCancelled();
                this.dispose();
            }
        };
        oKCancelDialog.setVisible(true);
    }

    public static Action getAction() {
        return new AbstractAction("Enlarge Canvas..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnlargeCanvas.showInDialog();
            }
        };
    }

    static class EnlargeCanvasPanel
    extends JPanel {
        RangeParam northRange = new RangeParam("North", 0, 500, 0);
        RangeParam eastRange = new RangeParam("East", 0, 500, 0);
        RangeParam southRange = new RangeParam("South", 0, 500, 0);
        RangeParam westRange = new RangeParam("West", 0, 500, 0);

        private EnlargeCanvasPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new SliderSpinner(this.northRange, false, SliderSpinner.TextPosition.BORDER));
            this.add(new SliderSpinner(this.eastRange, false, SliderSpinner.TextPosition.BORDER));
            this.add(new SliderSpinner(this.southRange, false, SliderSpinner.TextPosition.BORDER));
            this.add(new SliderSpinner(this.westRange, false, SliderSpinner.TextPosition.BORDER));
        }

        public int getNorth() {
            return this.northRange.getValue();
        }

        public int getSouth() {
            return this.southRange.getValue();
        }

        public int getWest() {
            return this.westRange.getValue();
        }

        public int getEast() {
            return this.eastRange.getValue();
        }
    }
}

