/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pixelitor.AppLogic;
import pixelitor.ChangeReason;
import pixelitor.ConsistencyChecks;
import pixelitor.ImageComponent;
import pixelitor.history.DeleteLayerEdit;
import pixelitor.history.DeselectEdit;
import pixelitor.history.History;
import pixelitor.history.LayerOrderChangeEdit;
import pixelitor.history.LayerSelectionChangeEdit;
import pixelitor.history.NewLayerEdit;
import pixelitor.history.NotUndoableEdit;
import pixelitor.history.PixelitorEdit;
import pixelitor.history.SelectionChangeEdit;
import pixelitor.layers.ContentLayer;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerButton;
import pixelitor.menus.SelectionActions;
import pixelitor.selection.Selection;
import pixelitor.selection.SelectionInteraction;
import pixelitor.selection.SelectionType;
import pixelitor.utils.HistogramsPanel;

public class Composition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int newLayerCount = 1;
    private List<Layer> layerList = new ArrayList<Layer>();
    private Layer activeLayer;
    private int canvasWidth;
    private int canvasHeight;
    private String name;
    private transient File file;
    private transient boolean dirty = false;
    private transient boolean compositeImageUpToDate = false;
    private transient BufferedImage cachedCompositeImage = null;
    private transient ImageComponent ic;
    private transient Selection selection;

    public Composition(ImageComponent imageComponent, File file, String string) {
        this.ic = imageComponent;
        if (file != null) {
            this.setFile(file);
        } else {
            this.name = string;
        }
    }

    public void addNewEmptyLayer(String string, boolean bl) {
        ImageLayer imageLayer = new ImageLayer(this, string, this.canvasWidth, this.canvasHeight);
        this.addLayer((Layer)imageLayer, true, false, bl);
    }

    public void setActiveLayer(Layer layer, boolean bl) {
        if (this.activeLayer != layer) {
            Layer layer2 = this.activeLayer;
            this.activeLayer = layer;
            layer.getLayerButton().setSelected(true);
            AppLogic.activeLayerChanged(layer);
            if (bl) {
                LayerSelectionChangeEdit layerSelectionChangeEdit = new LayerSelectionChangeEdit(this, layer2, layer);
                History.addEdit(layerSelectionChangeEdit);
            }
        }
    }

    public int getNrLayers() {
        return this.layerList.size();
    }

    public void addLayer(Layer layer, boolean bl, boolean bl2, boolean bl3) {
        int n = this.layerList.indexOf(this.activeLayer);
        int n2 = bl3 ? n : n + 1;
        this.addLayer(layer, bl, bl2, n2);
    }

    public void addLayer(Layer layer, boolean bl, boolean bl2, int n) {
        this.layerList.add(n, layer);
        this.addLayerToGUI(layer, n);
        if (bl) {
            NewLayerEdit newLayerEdit = new NewLayerEdit(this, layer);
            History.addEdit(newLayerEdit);
        }
        this.imageChanged(bl2, bl2);
    }

    private void addLayerToGUI(Layer layer, int n) {
        LayerButton layerButton = layer.getLayerButton();
        this.ic.addLayerButton(layerButton, n);
        this.setActiveLayer(layer, false);
        if (this.isActiveComp()) {
            AppLogic.activeCompLayerCountChanged(this, this.layerList.size());
        }
    }

    public void duplicateLayer() {
        Layer layer = this.activeLayer.duplicate();
        this.addLayer(layer, true, true, false);
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public int getActiveLayerIndex() {
        return this.layerList.indexOf(this.activeLayer);
    }

    public void finishFilterWithPreview(String string) {
        ((ImageLayer)this.activeLayer).finishFilterWithPreview(string);
    }

    public void changeImageSimpleFilterFinished(BufferedImage bufferedImage, ChangeReason changeReason, String string) {
        this.setDirty(true);
        ((ImageLayer)this.activeLayer).changeImageSimpleFilterFinished(bufferedImage, string);
        if (changeReason.repaintAndUpdateHistogram()) {
            this.imageChanged(true, true);
        } else {
            this.imageChanged(false, false);
        }
    }

    public void changePreviewImage(BufferedImage bufferedImage) {
        ImageLayer imageLayer = (ImageLayer)this.activeLayer;
        if (imageLayer.changePreviewImage(bufferedImage)) {
            this.imageChanged(true, true);
        }
    }

    public ImageLayer getActiveImageLayer() {
        if (this.activeLayer instanceof ImageLayer) {
            ImageLayer imageLayer = (ImageLayer)this.activeLayer;
            return imageLayer;
        }
        return null;
    }

    public BufferedImage getImageOrSubImageIfSelectedForActiveLayer(boolean bl, boolean bl2) {
        ImageLayer imageLayer = this.getActiveImageLayer();
        if (imageLayer != null) {
            return imageLayer.getImageOrSubImageIfSelected(bl, bl2);
        }
        return null;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public boolean isEmpty() {
        return this.layerList.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void startTranslation(boolean bl) {
        if (!(this.activeLayer instanceof ContentLayer)) {
            return;
        }
        if (bl) {
            this.duplicateLayer();
        }
        ((ContentLayer)this.activeLayer).startTranslation();
    }

    public void endTranslation() {
        if (!(this.activeLayer instanceof ContentLayer)) {
            return;
        }
        ((ContentLayer)this.activeLayer).endTranslation();
        this.imageChanged(true, true);
    }

    public Layer getLayer(int n) {
        return this.layerList.get(n);
    }

    public void flattenImage() {
        assert (this.isActiveComp());
        if (this.layerList.size() < 2) {
            return;
        }
        int n = this.getNrLayers();
        BufferedImage bufferedImage = this.getCompositeImage();
        ImageLayer imageLayer = new ImageLayer(this, bufferedImage, "flattened");
        this.addLayer((Layer)imageLayer, false, false, n);
        for (int i = n - 1; i >= 0; --i) {
            this.removeLayer(i);
        }
        AppLogic.activeCompLayerCountChanged(this, 1);
        History.addEdit(new NotUndoableEdit(this, "Flatten Image"));
    }

    public void mergeDown() {
        ImageLayer imageLayer;
        Layer layer;
        int n = this.layerList.indexOf(this.activeLayer);
        if (n > 0 && this.activeLayer.isVisible() && (layer = this.layerList.get(n - 1)) instanceof ImageLayer && (imageLayer = (ImageLayer)layer).isVisible()) {
            this.activeLayer.mergeDownOn(imageLayer);
            this.removeActiveLayer();
            History.addEdit(new NotUndoableEdit(this, "Merge Down"));
        }
    }

    public void moveActiveLayerUp() {
        int n = this.layerList.indexOf(this.activeLayer);
        this.swapLayers(n, n + 1, false);
    }

    public void moveActiveLayerDown() {
        int n = this.layerList.indexOf(this.activeLayer);
        this.swapLayers(n, n - 1, false);
    }

    public void moveActiveLayerToTop() {
        int n = this.layerList.indexOf(this.activeLayer);
        this.swapLayers(n, this.layerList.size() - 1, false);
    }

    public void moveActiveLayerToBottom() {
        int n = this.layerList.indexOf(this.activeLayer);
        this.swapLayers(n, 0, false);
    }

    public void swapLayers(int n, int n2, boolean bl) {
        if (n2 < 0) {
            return;
        }
        if (n2 >= this.layerList.size()) {
            return;
        }
        if (n == n2) {
            return;
        }
        Layer layer = this.layerList.get(n);
        this.layerList.remove(layer);
        this.layerList.add(n2, layer);
        this.ic.changeLayerOrderInTheGUI(n, n2);
        this.imageChanged(true, true);
        AppLogic.layerOrderChanged(this);
        if (!bl) {
            LayerOrderChangeEdit layerOrderChangeEdit = new LayerOrderChangeEdit(this, n, n2);
            History.addEdit(layerOrderChangeEdit);
        }
    }

    public void moveLayerSelectionUp() {
        int n = this.layerList.indexOf(this.activeLayer);
        int n2 = n + 1;
        if (n2 >= this.layerList.size()) {
            return;
        }
        this.setActiveLayer(this.layerList.get(n2), true);
        assert (ConsistencyChecks.fadeCheck(this));
    }

    public void moveLayerSelectionDown() {
        int n = this.layerList.indexOf(this.activeLayer);
        int n2 = n - 1;
        if (n2 < 0) {
            return;
        }
        this.setActiveLayer(this.layerList.get(n2), true);
        assert (ConsistencyChecks.fadeCheck(this));
    }

    private BufferedImage calculateCompositeImage() {
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        boolean bl = true;
        for (Layer layer : this.layerList) {
            if (!layer.isVisible()) continue;
            BufferedImage bufferedImage2 = layer.paintLayer(graphics2D, bl, bufferedImage);
            if (bufferedImage2 != null) {
                bufferedImage = bufferedImage2;
                if (graphics2D != null) {
                    graphics2D.dispose();
                }
                graphics2D = bufferedImage.createGraphics();
            }
            bl = false;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    void setCanvasWidth(int n) {
        this.canvasWidth = n;
    }

    void setCanvasHeight(int n) {
        this.canvasHeight = n;
    }

    public String generateNewLayerName() {
        String string = "layer " + this.newLayerCount;
        ++this.newLayerCount;
        return string;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void updateCanvasSize(int n, int n2) {
        this.ic.updateCanvasSize(n, n2);
    }

    public void updateRegion(int n, int n2, int n3, int n4, int n5) {
        this.compositeImageUpToDate = false;
        this.ic.updateRegion(n, n2, n3, n4, n5);
    }

    public void setImageComponent(ImageComponent imageComponent) {
        this.ic = imageComponent;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void restoreAfterDeserialization() {
        Layer layer = this.activeLayer;
        for (Layer layer2 : this.layerList) {
            this.restoreLayerAfterDeserialization(layer2);
        }
        this.setActiveLayer(layer, false);
    }

    private void restoreLayerAfterDeserialization(Layer layer) {
        if (this.layerList == null) {
            throw new IllegalStateException("layerList is null");
        }
        int n = this.layerList.indexOf(layer);
        this.addLayerToGUI(layer, n);
    }

    public Rectangle getCanvasBounds() {
        return new Rectangle(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.setName(file.getName());
    }

    private void setName(String string) {
        this.name = string;
        if (this.ic != null) {
            this.ic.setInternalFrameTitle();
        }
    }

    private void removeLayer(int n) {
        Layer layer = this.layerList.get(n);
        this.removeLayer(layer, false);
    }

    public void removeActiveLayer() {
        this.removeLayer(this.activeLayer, false);
    }

    public void removeLayer(Layer layer, boolean bl) {
        Serializable serializable;
        if (this.layerList.size() < 2) {
            throw new IllegalStateException("there are " + this.layerList.size() + " layers");
        }
        int n = this.layerList.indexOf(layer);
        if (!bl) {
            serializable = new DeleteLayerEdit(this, layer, n);
            History.addEdit((PixelitorEdit)serializable);
        }
        serializable = layer.getLayerButton();
        this.layerList.remove(layer);
        if (layer == this.activeLayer) {
            if (n > 0) {
                this.setActiveLayer(this.layerList.get(n - 1), false);
            } else {
                this.setActiveLayer(this.layerList.get(0), false);
            }
        }
        this.ic.deleteLayerButton((LayerButton)serializable);
        if (this.isActiveComp()) {
            AppLogic.activeCompLayerCountChanged(this, this.layerList.size());
        }
        this.imageChanged(true, true);
    }

    public void dispose() {
        if (this.selection != null) {
            this.selection.deselectAndDispose();
        }
    }

    public void addNewLayerFromComposite(String string) {
        ImageLayer imageLayer = new ImageLayer(this, this.getCompositeImage(), string);
        this.addLayer((Layer)imageLayer, true, false, false);
    }

    public ImageComponent getIC() {
        return this.ic;
    }

    public void paintSelection(Graphics2D graphics2D) {
        if (this.selection != null) {
            this.selection.paintMarchingAnts(graphics2D);
        }
    }

    public void deselect(boolean bl) {
        if (this.selection != null) {
            Shape shape;
            if (bl && (shape = this.selection.getShape()) != null) {
                DeselectEdit deselectEdit = new DeselectEdit(this, shape, "Composition.deselect");
                History.addEdit(deselectEdit);
            }
            this.selection.deselectAndDispose();
            this.selection = null;
            SelectionActions.setEnabled(false);
        }
    }

    public Selection getSelection() {
        return this.selection;
    }

    public boolean hasSelection() {
        return this.selection != null;
    }

    public BufferedImage getCompositeImage() {
        if (this.compositeImageUpToDate) {
            return this.cachedCompositeImage;
        }
        this.cachedCompositeImage = this.calculateCompositeImage();
        this.compositeImageUpToDate = true;
        return this.cachedCompositeImage;
    }

    public void imageChanged(boolean bl, boolean bl2) {
        this.compositeImageUpToDate = false;
        if (bl && this.ic != null) {
            this.ic.repaint();
        }
        if (bl2) {
            HistogramsPanel.INSTANCE.updateFromCompIfShown(this);
        }
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void moveActiveContentRelative(int n, int n2, boolean bl) {
        if (this.activeLayer instanceof ContentLayer) {
            ContentLayer contentLayer = (ContentLayer)this.activeLayer;
            contentLayer.moveLayerRelative(n, n2);
            this.imageChanged(bl, false);
        }
    }

    public boolean isActiveLayer(Layer layer) {
        return layer == this.activeLayer;
    }

    public void setSelectionClipping(Graphics2D graphics2D, AffineTransform affineTransform) {
        if (this.selection != null) {
            Shape shape = affineTransform != null ? this.selection.getTransformedShape(affineTransform) : this.selection.getShape();
            graphics2D.setClip(shape);
        }
    }

    public void invertSelection() {
        if (this.selection != null) {
            Shape shape = this.selection.getShape();
            this.selection.invert(this.getCanvasBounds());
            SelectionChangeEdit selectionChangeEdit = new SelectionChangeEdit(this, shape, "Invert Selection");
            History.addEdit(selectionChangeEdit);
        }
    }

    public void startSelection(SelectionType selectionType, SelectionInteraction selectionInteraction) {
        this.selection = new Selection(this.ic, selectionType, selectionInteraction);
        SelectionActions.setEnabled(true);
    }

    public void createSelectionFromShape(Shape shape) {
        if (this.selection != null) {
            throw new IllegalStateException("createSelectionFromShape called while there was a selection: " + this.selection.toString());
        }
        this.selection = new Selection(shape, this.ic);
        if (this.isActiveComp()) {
            SelectionActions.setEnabled(true);
        }
    }

    public boolean isActiveComp() {
        return AppLogic.getActiveComp() == this;
    }

    public void layerToCanvasSize() {
        ImageLayer imageLayer = this.getActiveImageLayer();
        if (imageLayer != null) {
            imageLayer.cropToCanvasSize();
            History.addEdit(new NotUndoableEdit(this, "Layer to Canvas Size"));
        }
    }

    public void enlargeCanvas(int n, int n2, int n3, int n4) {
        for (Layer layer : this.layerList) {
            if (!(layer instanceof ContentLayer)) continue;
            ContentLayer contentLayer = (ContentLayer)layer;
            contentLayer.enlargeCanvas(n, n2, n3, n4);
        }
        this.ic.updateCanvasSize(this.canvasWidth + n2 + n4, this.canvasHeight + n + n3);
        this.imageChanged(true, false);
        this.setDirty(true);
    }
}

