/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.painter.Painter;

public class JXPanel
extends JPanel
implements Scrollable {
    private boolean scrollableTracksViewportHeight = true;
    private boolean scrollableTracksViewportWidth = true;
    private float alpha = 1.0f;
    private boolean oldOpaque;
    private boolean inheritAlpha = true;
    private Painter backgroundPainter;
    private boolean paintBorderInsets = true;

    public JXPanel() {
    }

    public JXPanel(boolean bl) {
        super(bl);
    }

    public JXPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public JXPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public void setAlpha(float f) {
        if (this.alpha != f) {
            assert (f >= 0.0f && (double)f <= 1.0);
            float f2 = this.alpha;
            this.alpha = f;
            if (f > 0.0f && f < 1.0f) {
                if (f2 == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
                RepaintManager repaintManager = RepaintManager.currentManager(this);
                RepaintManager repaintManager2 = SwingXUtilities.getTranslucentRepaintManager(repaintManager);
                RepaintManager.setCurrentManager(repaintManager2);
            } else if (f == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", f2, f);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getEffectiveAlpha() {
        if (this.inheritAlpha) {
            float f = this.alpha;
            Container container = this;
            while ((container = container.getParent()) != null) {
                if (!(container instanceof JXPanel)) continue;
                f = Math.min(((JXPanel)container).getAlpha(), f);
            }
            return f;
        }
        return this.alpha;
    }

    public boolean isInheritAlpha() {
        return this.inheritAlpha;
    }

    public void setInheritAlpha(boolean bl) {
        if (this.inheritAlpha != bl) {
            this.inheritAlpha = bl;
            this.firePropertyChange("inheritAlpha", !this.inheritAlpha, this.inheritAlpha);
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableTracksViewportHeight;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableTracksViewportWidth;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public void setScrollableTracksViewportHeight(boolean bl) {
        this.scrollableTracksViewportHeight = bl;
    }

    public void setScrollableTracksViewportWidth(boolean bl) {
        this.scrollableTracksViewportWidth = bl;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
    }

    private boolean canInstallBackgroundUIResourceAsPainter(Color color) {
        Painter painter = this.getBackgroundPainter();
        return color instanceof UIResource && (painter == null || painter instanceof UIResource);
    }

    public void setBackgroundPainter(Painter painter) {
        Painter painter2 = this.getBackgroundPainter();
        this.backgroundPainter = painter;
        this.firePropertyChange("backgroundPainter", painter2, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public void setPaintBorderInsets(boolean bl) {
        boolean bl2 = this.isPaintBorderInsets();
        this.paintBorderInsets = bl;
        this.firePropertyChange("paintBorderInsets", bl2, this.isPaintBorderInsets());
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = this.getEffectiveAlpha();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        graphics2D.setComposite(alphaComposite);
        super.paint(graphics2D);
        graphics2D.setComposite(composite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.backgroundPainter != null) {
            if (this.isOpaque()) {
                super.paintComponent(graphics);
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                if (this.isPaintBorderInsets()) {
                    this.backgroundPainter.paint(graphics2D, this, this.getWidth(), this.getHeight());
                }
                Insets insets = this.getInsets();
                graphics2D.translate(insets.left, insets.top);
                this.backgroundPainter.paint(graphics2D, this, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            super.paintComponent(graphics);
        }
    }
}

