/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.plaf.PlafPaintUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ColorSwatch
extends JPanel {
    private static final long serialVersionUID = 1L;
    JPopupMenu menu;
    JMenuItem copyItem;
    int w;
    private static TexturePaint checkerPaint = null;

    public ColorSwatch(int n) {
        this.w = n;
        this.setPreferredSize(new Dimension(n, n));
        this.setMinimumSize(new Dimension(n, n));
    }

    public ColorSwatch(Color color, int n) {
        this(n);
        this.setForeground(color);
    }

    private static TexturePaint getCheckerPaint() {
        if (checkerPaint == null) {
            int n = 8;
            BufferedImage bufferedImage = new BufferedImage(n * 2, n * 2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, 2 * n, 2 * n);
            graphics2D.setColor(Color.lightGray);
            graphics2D.fillRect(0, 0, n, n);
            graphics2D.fillRect(n, n, n, n);
            checkerPaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return checkerPaint;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.getForeground();
        int n = Math.min(this.getWidth(), this.w);
        int n2 = Math.min(this.getHeight(), this.w);
        Rectangle rectangle = new Rectangle(this.getWidth() / 2 - n / 2, this.getHeight() / 2 - n2 / 2, n, n2);
        if (color.getAlpha() < 255) {
            TexturePaint texturePaint = ColorSwatch.getCheckerPaint();
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2D.setColor(color);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        PlafPaintUtils.drawBevel(graphics2D, rectangle);
    }
}

