/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.swing.ColorPicker;
import com.bric.util.JVM;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

class ColorPickerDialog
extends JDialog {
    private static final long serialVersionUID = 2L;
    ColorPicker cp;
    int alpha;
    JButton ok = new JButton(ColorPicker.strings.getObject("OK").toString());
    JButton cancel = new JButton(ColorPicker.strings.getObject("Cancel").toString());
    Color returnValue = null;
    ActionListener buttonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ColorPickerDialog.this.ok) {
                ColorPickerDialog.this.returnValue = ColorPickerDialog.this.cp.getColor();
            }
            ColorPickerDialog.this.setVisible(false);
            ColorPickerDialog.this.dispose();
        }
    };

    public ColorPickerDialog(Frame frame, Color color, boolean bl) {
        super(frame);
        this.initialize(frame, color, bl);
    }

    public ColorPickerDialog(Dialog dialog, Color color, boolean bl) {
        super(dialog);
        this.initialize(dialog, color, bl);
    }

    private void initialize(Component component, Color color, boolean bl) {
        this.cp = new ColorPicker(true, bl);
        this.cp.setMode(0);
        this.setModal(true);
        this.setResizable(false);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        container.add((Component)this.cp, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        if (JVM.isMac) {
            container.add((Component)new JPanel(), gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.0;
            container.add((Component)this.cancel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.0;
            container.add((Component)this.ok, gridBagConstraints);
        } else {
            JPanel jPanel = new JPanel(new FlowLayout(1));
            jPanel.add(this.ok);
            jPanel.add(this.cancel);
            container.add((Component)jPanel, gridBagConstraints);
        }
        this.cp.setRGB(color.getRed(), color.getGreen(), color.getBlue());
        this.cp.setOpacity(color.getAlpha());
        this.alpha = color.getAlpha();
        this.pack();
        this.setLocationRelativeTo(component);
        this.ok.addActionListener(this.buttonListener);
        this.cancel.addActionListener(this.buttonListener);
        this.getRootPane().setDefaultButton(this.ok);
        this.setDefaultCloseOperation(2);
    }

    public Color getColor() {
        return this.returnValue;
    }
}

