/*
 * Decompiled with CFR 0.152.
 */
package com.bric.plaf;

import com.bric.swing.MultiThumbSlider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public abstract class MultiThumbSliderUI
extends ComponentUI
implements MouseListener,
MouseMotionListener {
    protected MultiThumbSlider slider;
    int MAX_LENGTH = 300;
    int MIN_LENGTH = 50;
    int PREF_LENGTH = 140;
    int DEPTH = 15;
    int[] thumbPositions = new int[0];
    protected float[] thumbIndications = new float[0];
    private float indicationGoal = 0.0f;
    float indication = 0.0f;
    protected Rectangle trackRect = new Rectangle(0, 0, 0, 0);
    Thread animatingThread = null;
    Runnable animatingRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                MultiThumbSliderUI multiThumbSliderUI = MultiThumbSliderUI.this;
                synchronized (multiThumbSliderUI) {
                    bl = true;
                    for (int i = 0; i < MultiThumbSliderUI.this.thumbIndications.length; ++i) {
                        if (i != MultiThumbSliderUI.this.slider.getSelectedThumb()) {
                            if (i == MultiThumbSliderUI.this.currentIndicatedThumb) {
                                if (!(MultiThumbSliderUI.this.thumbIndications[i] < 1.0f)) continue;
                                MultiThumbSliderUI.this.thumbIndications[i] = Math.min(1.0f, MultiThumbSliderUI.this.thumbIndications[i] + 0.025f);
                                bl = false;
                                continue;
                            }
                            if (!(MultiThumbSliderUI.this.thumbIndications[i] > 0.0f)) continue;
                            MultiThumbSliderUI.this.thumbIndications[i] = Math.max(0.0f, MultiThumbSliderUI.this.thumbIndications[i] - 0.025f);
                            bl = false;
                            continue;
                        }
                        MultiThumbSliderUI.this.thumbIndications[i] = i == MultiThumbSliderUI.this.currentIndicatedThumb ? 1.0f : 0.0f;
                    }
                    if (MultiThumbSliderUI.this.indicationGoal > MultiThumbSliderUI.this.indication + 0.01f) {
                        if (MultiThumbSliderUI.this.indication < 0.99f) {
                            MultiThumbSliderUI.this.indication = Math.min(1.0f, MultiThumbSliderUI.this.indication + 0.1f);
                            bl = false;
                        }
                    } else if (MultiThumbSliderUI.this.indicationGoal < MultiThumbSliderUI.this.indication - 0.01f && MultiThumbSliderUI.this.indication > 0.01f) {
                        MultiThumbSliderUI.this.indication = Math.max(0.0f, MultiThumbSliderUI.this.indication - 0.1f);
                        bl = false;
                    }
                }
                if (!bl) {
                    MultiThumbSliderUI.this.slider.repaint();
                }
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() - l < 20L) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        Thread.yield();
                    }
                }
            }
        }
    };
    private int currentIndicatedThumb = -1;
    private boolean mouseInside = false;
    private boolean mouseIsDown = false;
    private State pressedState;
    private int dx;
    private int dy;
    FocusListener focusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Component component = (Component)focusEvent.getSource();
            if (MultiThumbSliderUI.getProperty(MultiThumbSliderUI.this.slider, "MultiThumbSlider.indicateComponent", "true").toString().equals("true")) {
                MultiThumbSliderUI.this.slider.setSelectedThumb(-1);
            }
            MultiThumbSliderUI.this.updateIndication();
            component.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = (Component)focusEvent.getSource();
            int n = MultiThumbSliderUI.this.slider.getSelectedThumb(false);
            if (n == -1) {
                int n2 = 1;
                if (MultiThumbSliderUI.this.slider.getOrientation() == 1) {
                    n2 *= -1;
                }
                if (MultiThumbSliderUI.this.slider.isInverted()) {
                    n2 *= -1;
                }
                MultiThumbSliderUI.this.slider.setSelectedThumb(n2 == 1 ? 0 : MultiThumbSliderUI.this.slider.getThumbCount() - 1);
            }
            MultiThumbSliderUI.this.updateIndication();
            component.repaint();
        }
    };
    KeyListener keyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2;
            if (!MultiThumbSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (keyEvent.getSource() != MultiThumbSliderUI.this.slider) {
                throw new RuntimeException("only install this UI on the GradientSlider it was constructed with");
            }
            int n3 = MultiThumbSliderUI.this.slider.getSelectedThumb();
            int n4 = keyEvent.getKeyCode();
            int n5 = MultiThumbSliderUI.this.slider.getOrientation();
            if (n3 != -1 && (n4 == 39 || n4 == 37) && n5 == 0 && keyEvent.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                int n6 = n4 == 39 && !MultiThumbSliderUI.this.slider.isInverted() || n4 == 37 && MultiThumbSliderUI.this.slider.isInverted() ? n3 + 1 : n3 - 1;
                MultiThumbSliderUI.this.addThumb(n3, n6);
                keyEvent.consume();
                return;
            }
            if (n3 != -1 && (n4 == 38 || n4 == 40) && n5 == 1 && keyEvent.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                int n7 = n4 == 38 && !MultiThumbSliderUI.this.slider.isInverted() || n4 == 40 && MultiThumbSliderUI.this.slider.isInverted() ? n3 + 1 : n3 - 1;
                MultiThumbSliderUI.this.addThumb(n3, n7);
                keyEvent.consume();
                return;
            }
            if (n4 == 40 && n5 == 0 && n3 != -1) {
                int n8;
                int n9 = MultiThumbSliderUI.this.slider.isInverted() ? (int)((float)MultiThumbSliderUI.this.trackRect.x + (float)MultiThumbSliderUI.this.trackRect.width * (1.0f - MultiThumbSliderUI.this.slider.getThumbPositions()[n3])) : (int)((float)MultiThumbSliderUI.this.trackRect.x + (float)MultiThumbSliderUI.this.trackRect.width * MultiThumbSliderUI.this.slider.getThumbPositions()[n3]);
                if (MultiThumbSliderUI.this.slider.doPopup(n9, n8 = MultiThumbSliderUI.this.trackRect.y + MultiThumbSliderUI.this.trackRect.height)) {
                    keyEvent.consume();
                    return;
                }
            } else if (n4 == 39 && n5 == 1 && n3 != -1 && MultiThumbSliderUI.this.slider.doPopup(n2 = MultiThumbSliderUI.this.trackRect.x + MultiThumbSliderUI.this.trackRect.width, n = MultiThumbSliderUI.this.slider.isInverted() ? (int)((float)MultiThumbSliderUI.this.trackRect.y + (float)MultiThumbSliderUI.this.trackRect.height * MultiThumbSliderUI.this.slider.getThumbPositions()[n3]) : (int)((float)MultiThumbSliderUI.this.trackRect.y + (float)MultiThumbSliderUI.this.trackRect.height * (1.0f - MultiThumbSliderUI.this.slider.getThumbPositions()[n3])))) {
                keyEvent.consume();
                return;
            }
            if (n3 != -1) {
                if (n4 == 39 || n4 == 40) {
                    MultiThumbSliderUI.this.nudge(n3, 1);
                    keyEvent.consume();
                } else if (n4 == 37 || n4 == 38) {
                    MultiThumbSliderUI.this.nudge(n3, -1);
                    keyEvent.consume();
                } else if (n4 == 127 || n4 == 8) {
                    if (MultiThumbSliderUI.this.slider.getThumbCount() > 2) {
                        MultiThumbSliderUI.this.slider.removeThumb(n3);
                        keyEvent.consume();
                    }
                } else if (n4 == 32 || n4 == 10) {
                    MultiThumbSliderUI.this.slider.doDoubleClick(-1, -1);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    };
    PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("values") || string.equals("orientation") || string.equals("inverted")) {
                MultiThumbSliderUI.this.calculateGeometry();
                MultiThumbSliderUI.this.slider.repaint();
            } else if (string.equals("selected thumb") || string.equals("paint ticks")) {
                MultiThumbSliderUI.this.slider.repaint();
            } else if (string.equals("MultiThumbSlider.indicateComponent")) {
                MultiThumbSliderUI.this.setMouseInside(MultiThumbSliderUI.this.mouseInside);
                MultiThumbSliderUI.this.slider.repaint();
            }
        }
    };
    ComponentListener compListener = new ComponentListener(){

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MultiThumbSliderUI.this.calculateGeometry();
            Component component = (Component)componentEvent.getSource();
            component.repaint();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }
    };

    public MultiThumbSliderUI(MultiThumbSlider multiThumbSlider) {
        this.slider = multiThumbSlider;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        MultiThumbSlider multiThumbSlider = (MultiThumbSlider)jComponent;
        if (multiThumbSlider.getOrientation() == 0) {
            return new Dimension(this.MAX_LENGTH, this.DEPTH);
        }
        return new Dimension(this.DEPTH, this.MAX_LENGTH);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        MultiThumbSlider multiThumbSlider = (MultiThumbSlider)jComponent;
        if (multiThumbSlider.getOrientation() == 0) {
            return new Dimension(this.MIN_LENGTH, this.DEPTH);
        }
        return new Dimension(this.DEPTH, this.MIN_LENGTH);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        MultiThumbSlider multiThumbSlider = (MultiThumbSlider)jComponent;
        if (multiThumbSlider.getOrientation() == 0) {
            return new Dimension(this.PREF_LENGTH, this.DEPTH);
        }
        return new Dimension(this.DEPTH, this.PREF_LENGTH);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.dx = 0;
        this.dy = 0;
        if (!this.slider.isEnabled()) {
            return;
        }
        if (mouseEvent.getClickCount() >= 2) {
            if (this.slider.doDoubleClick(mouseEvent.getX(), mouseEvent.getY())) {
                mouseEvent.consume();
                return;
            }
        } else if (mouseEvent.isPopupTrigger()) {
            n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.slider.getOrientation() == 0) {
                if (n < this.trackRect.x || n > this.trackRect.x + this.trackRect.width) {
                    return;
                }
                n2 = this.trackRect.y + this.trackRect.height;
            } else {
                if (n2 < this.trackRect.y || n2 > this.trackRect.y + this.trackRect.height) {
                    return;
                }
                n = this.trackRect.x + this.trackRect.width;
            }
            if (this.slider.doPopup(n, n2)) {
                mouseEvent.consume();
                return;
            }
        }
        this.mouseIsDown = true;
        this.mouseMoved(mouseEvent);
        if (mouseEvent.getSource() != this.slider) {
            throw new RuntimeException("only install this UI on the GradientSlider it was constructed with");
        }
        this.slider.requestFocus();
        n = this.getIndex(mouseEvent);
        if (n != -1) {
            if (this.slider.getOrientation() == 0) {
                this.dx = -mouseEvent.getX() + this.thumbPositions[n];
            } else {
                this.dy = -mouseEvent.getY() + this.thumbPositions[n];
            }
        }
        if (n != -1) {
            this.slider.setSelectedThumb(n);
            mouseEvent.consume();
        } else if (this.slider.isAutoAdding()) {
            float f;
            int n3 = this.slider.getOrientation() == 0 ? mouseEvent.getX() : mouseEvent.getY();
            if (this.slider.getOrientation() == 0) {
                f = (float)(n3 - this.trackRect.x) / (float)this.trackRect.width;
                if (this.slider.isInverted()) {
                    f = 1.0f - f;
                }
            } else {
                f = (float)(n3 - this.trackRect.y) / (float)this.trackRect.height;
                if (!this.slider.isInverted()) {
                    f = 1.0f - f;
                }
            }
            if (f > 0.0f && f < 1.0f) {
                int n4 = this.slider.addThumb(f);
                this.slider.setSelectedThumb(n4);
            }
            mouseEvent.consume();
        } else if (this.slider.getSelectedThumb() != -1) {
            this.slider.setSelectedThumb(-1);
            mouseEvent.consume();
        }
        this.pressedState = new State();
    }

    private int getIndex(MouseEvent mouseEvent) {
        int n;
        if (this.slider.getOrientation() == 0 ? (n = mouseEvent.getX()) < this.trackRect.x - this.getClickLocationTolerance() + 1 || n > this.trackRect.x + this.trackRect.width + this.getClickLocationTolerance() - 1 : (n = mouseEvent.getY()) < this.trackRect.y - this.getClickLocationTolerance() + 1 || n > this.trackRect.y + this.trackRect.height + this.getClickLocationTolerance() - 1) {
            return -1;
        }
        int n2 = Math.abs(n - this.thumbPositions[0]);
        int n3 = 0;
        for (int i = 1; i < this.thumbPositions.length; ++i) {
            int n4 = Math.abs(n - this.thumbPositions[i]);
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i;
        }
        if (n2 < this.getClickLocationTolerance()) {
            return n3;
        }
        return -1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setCurrentIndicatedThumb(-1);
        this.setMouseInside(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl;
        if (!this.slider.isEnabled()) {
            return;
        }
        int n = this.getIndex(mouseEvent);
        this.setCurrentIndicatedThumb(n);
        boolean bl2 = bl = mouseEvent.getX() >= 0 && mouseEvent.getX() < this.slider.getWidth() && mouseEvent.getY() >= 0 && mouseEvent.getY() < this.slider.getHeight();
        if (this.mouseIsDown) {
            bl = true;
        }
        this.setMouseInside(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentIndicatedThumb(int n) {
        if (MultiThumbSliderUI.getProperty(this.slider, "MultiThumbSlider.indicateThumb", "true").equals("false")) {
            n = -1;
        }
        this.currentIndicatedThumb = n;
        boolean bl = true;
        for (int i = 0; i < this.thumbIndications.length; ++i) {
            if (i == this.currentIndicatedThumb) {
                if (this.thumbIndications[i] == 1.0f) continue;
                bl = false;
                continue;
            }
            if (this.thumbIndications[i] == 0.0f) continue;
            bl = false;
        }
        if (!bl) {
            MultiThumbSliderUI multiThumbSliderUI = this;
            synchronized (multiThumbSliderUI) {
                if (this.animatingThread == null || !this.animatingThread.isAlive()) {
                    this.animatingThread = new Thread(this.animatingRunnable);
                    this.animatingThread.start();
                }
            }
        }
    }

    private void setMouseInside(boolean bl) {
        this.mouseInside = bl;
        this.updateIndication();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.slider.isEnabled()) {
            return;
        }
        mouseEvent.translatePoint(this.dx, this.dy);
        this.mouseMoved(mouseEvent);
        if (this.pressedState != null && this.pressedState.selectedThumb != -1) {
            boolean bl;
            float f;
            this.slider.setValueIsAdjusting(true);
            State state = new State(this.pressedState);
            if (this.slider.getOrientation() == 0) {
                f = (float)(mouseEvent.getX() - this.trackRect.x) / (float)this.trackRect.width;
                if (this.slider.isInverted()) {
                    f = 1.0f - f;
                }
                boolean bl2 = bl = mouseEvent.getY() < this.trackRect.y - 10 || mouseEvent.getY() > this.trackRect.y + this.trackRect.height + 10;
                if (mouseEvent.getX() > this.trackRect.x - 10 && mouseEvent.getX() < this.trackRect.x + this.trackRect.width + 10) {
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                }
            } else {
                f = (float)(mouseEvent.getY() - this.trackRect.y) / (float)this.trackRect.height;
                if (!this.slider.isInverted()) {
                    f = 1.0f - f;
                }
                boolean bl3 = bl = mouseEvent.getX() < this.trackRect.x - 10 || mouseEvent.getX() > this.trackRect.x + this.trackRect.width + 10;
                if (mouseEvent.getY() > this.trackRect.y - 10 && mouseEvent.getY() < this.trackRect.y + this.trackRect.height + 10) {
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                }
            }
            if (state.positions.length <= 2) {
                bl = false;
            }
            state.positions[state.selectedThumb] = f;
            if (bl) {
                state.removeThumb(state.selectedThumb);
            }
            if (MultiThumbSliderUI.validatePositions(state)) {
                state.install();
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.slider.isEnabled()) {
            return;
        }
        this.mouseIsDown = false;
        if (this.pressedState != null && this.slider.getThumbCount() <= this.pressedState.positions.length) {
            this.mouseDragged(mouseEvent);
        }
        if (this.slider.isValueAdjusting()) {
            this.slider.setValueIsAdjusting(false);
        }
        if (mouseEvent.isPopupTrigger() && this.slider.doPopup(mouseEvent.getX(), mouseEvent.getY())) {
            mouseEvent.consume();
            return;
        }
    }

    public static String getProperty(JComponent jComponent, String string, String string2) {
        Object object = jComponent.getClientProperty(string);
        if (object != null) {
            return object.toString();
        }
        Object object2 = UIManager.get(string);
        if (object2 != null) {
            return object2.toString();
        }
        return string2;
    }

    public abstract int getClickLocationTolerance();

    protected static boolean validatePositions(State state) {
        int n;
        float[] fArray = state.positions;
        Object[] objectArray = state.values;
        if (fArray.length <= 2) {
            for (n = 0; n < fArray.length; ++n) {
                if (fArray[n] < 0.0f) {
                    fArray[n] = 0.0f;
                    continue;
                }
                if (!(fArray[n] > 1.0f)) continue;
                fArray[n] = 1.0f;
            }
        }
        n = 1;
        while (n != 0) {
            n = 0;
            for (int i = 0; i < fArray.length - 1; ++i) {
                if (fArray[i] == fArray[i + 1]) {
                    return false;
                }
                if (!(fArray[i] > fArray[i + 1])) continue;
                n = 1;
                float f = fArray[i];
                fArray[i] = fArray[i + 1];
                fArray[i + 1] = f;
                Object object = objectArray[i];
                objectArray[i] = objectArray[i + 1];
                objectArray[i + 1] = object;
                if (i == state.selectedThumb) {
                    state.selectedThumb = i + 1;
                    continue;
                }
                if (i + 1 != state.selectedThumb) continue;
                state.selectedThumb = i;
            }
        }
        return true;
    }

    protected boolean addThumb(int n, int n2) {
        int n3;
        int n4;
        float f = 0.0f;
        float f2 = 1.0f;
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        float[] fArray = this.slider.getThumbPositions();
        if (n4 >= 0) {
            f = fArray[n4];
        }
        if (n3 < fArray.length) {
            f2 = fArray[n3];
        }
        if ((double)(f2 - f) < 0.05) {
            return false;
        }
        float f3 = (f + f2) / 2.0f;
        this.slider.setSelectedThumb(this.slider.addThumb(f3));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndication() {
        MultiThumbSliderUI multiThumbSliderUI = this;
        synchronized (multiThumbSliderUI) {
            this.indicationGoal = this.slider.isEnabled() && (this.slider.hasFocus() || this.mouseInside) ? 1.0f : 0.0f;
            if (MultiThumbSliderUI.getProperty(this.slider, "MultiThumbSlider.indicateComponent", "true").equals("false")) {
                this.indicationGoal = 1.0f;
                if (!this.slider.isVisible()) {
                    this.indication = 1.0f;
                }
            }
            if (!(this.indication == this.indicationGoal || this.animatingThread != null && this.animatingThread.isAlive())) {
                this.animatingThread = new Thread(this.animatingRunnable);
                this.animatingThread.start();
            }
        }
    }

    protected synchronized void calculateGeometry() {
        this.trackRect = this.calculateTrackRect();
        float[] fArray = this.slider.getThumbPositions();
        if (this.thumbPositions.length != fArray.length) {
            this.thumbPositions = new int[fArray.length];
            this.thumbIndications = new float[fArray.length];
        }
        if (this.slider.getOrientation() == 0) {
            for (int i = 0; i < this.thumbPositions.length; ++i) {
                this.thumbPositions[i] = !this.slider.isInverted() ? this.trackRect.x + (int)((float)this.trackRect.width * fArray[i]) : this.trackRect.x + (int)((float)this.trackRect.width * (1.0f - fArray[i]));
                this.thumbIndications[i] = 0.0f;
            }
        } else {
            for (int i = 0; i < this.thumbPositions.length; ++i) {
                this.thumbPositions[i] = this.slider.isInverted() ? this.trackRect.y + (int)((float)this.trackRect.height * fArray[i]) : this.trackRect.y + (int)((float)this.trackRect.height * (1.0f - fArray[i]));
                this.thumbIndications[i] = 0.0f;
            }
        }
    }

    protected Rectangle calculateTrackRect() {
        int n;
        int n2;
        Insets insets = new Insets(5, 5, 5, 5);
        if (this.slider.getOrientation() == 0) {
            n2 = this.slider.getWidth() - insets.left - insets.right;
            n = Math.min(this.DEPTH, this.slider.getHeight() - insets.top - insets.bottom);
        } else {
            n = this.slider.getHeight() - insets.top - insets.bottom;
            n2 = Math.min(this.DEPTH, this.slider.getWidth() - insets.left - insets.right);
        }
        return new Rectangle(this.slider.getWidth() / 2 - n2 / 2, this.slider.getHeight() / 2 - n / 2, n2, n);
    }

    private void nudge(int n, int n2) {
        float f = this.slider.getOrientation() == 0 ? 1.0f / (float)this.trackRect.width : 1.0f / (float)this.trackRect.height;
        if (n2 < 0) {
            f *= -1.0f;
        }
        if (this.slider.isInverted()) {
            f *= -1.0f;
        }
        if (this.slider.getOrientation() == 1) {
            f *= -1.0f;
        }
        State state = new State();
        while (state.positions[n] >= 0.0f && state.positions[n] <= 1.0f) {
            int n3 = n;
            state.positions[n3] = state.positions[n3] + f;
            if (!MultiThumbSliderUI.validatePositions(state)) continue;
            state.install();
            return;
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        jComponent.addFocusListener(this.focusListener);
        jComponent.addKeyListener(this.keyListener);
        jComponent.addComponentListener(this.compListener);
        jComponent.addPropertyChangeListener(this.propertyListener);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (jComponent != this.slider) {
            throw new RuntimeException("only use this UI on the GradientSlider it was constructed with");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.slider.getWidth();
        int n2 = this.slider.getHeight();
        if (this.slider.isOpaque()) {
            graphics.setColor(this.slider.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintTrack(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintFocus(graphics2D);
        this.paintThumbs(graphics2D);
    }

    protected abstract void paintTrack(Graphics2D var1);

    protected abstract void paintFocus(Graphics2D var1);

    protected abstract void paintThumbs(Graphics2D var1);

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this);
        jComponent.removeFocusListener(this.focusListener);
        jComponent.removeKeyListener(this.keyListener);
        jComponent.removeComponentListener(this.compListener);
        jComponent.removePropertyChangeListener(this.propertyListener);
        super.uninstallUI(jComponent);
    }

    class State {
        Object[] values;
        float[] positions;
        int selectedThumb;

        public State() {
            this.values = MultiThumbSliderUI.this.slider.getValues();
            this.positions = MultiThumbSliderUI.this.slider.getThumbPositions();
            this.selectedThumb = MultiThumbSliderUI.this.slider.getSelectedThumb(false);
        }

        public State(State state) {
            this.selectedThumb = state.selectedThumb;
            this.positions = new float[state.positions.length];
            this.values = new Object[state.values.length];
            System.arraycopy(state.positions, 0, this.positions, 0, this.positions.length);
            System.arraycopy(state.values, 0, this.values, 0, this.values.length);
        }

        private void polish() {
            Object[] objectArray;
            float[] fArray;
            while (this.positions[0] < 0.0f) {
                fArray = new float[this.positions.length - 1];
                System.arraycopy(this.positions, 1, fArray, 0, this.positions.length - 1);
                objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.values, 1, objectArray, 0, this.positions.length - 1);
                this.positions = fArray;
                this.values = objectArray;
                ++this.selectedThumb;
            }
            while (this.positions[this.positions.length - 1] > 1.0f) {
                fArray = new float[this.positions.length - 1];
                System.arraycopy(this.positions, 0, fArray, 0, this.positions.length - 1);
                objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.values, 0, objectArray, 0, this.positions.length - 1);
                this.positions = fArray;
                this.values = objectArray;
                --this.selectedThumb;
            }
            if (this.selectedThumb >= this.positions.length) {
                this.selectedThumb = -1;
            }
        }

        public void install() {
            this.polish();
            MultiThumbSliderUI.this.slider.setValues(this.positions, this.values);
            MultiThumbSliderUI.this.slider.setSelectedThumb(this.selectedThumb);
        }

        public void removeThumb(int n) {
            float[] fArray = new float[this.positions.length - 1];
            Object[] objectArray = new Object[this.values.length - 1];
            System.arraycopy(this.positions, 0, fArray, 0, n);
            System.arraycopy(this.values, 0, objectArray, 0, n);
            System.arraycopy(this.positions, n + 1, fArray, n, fArray.length - n);
            System.arraycopy(this.values, n + 1, objectArray, n, fArray.length - n);
            this.positions = fArray;
            this.values = objectArray;
            this.selectedThumb = -1;
        }
    }
}

