/*
 * Decompiled with CFR 0.152.
 */
package com.bric.plaf;

import com.bric.plaf.MultiThumbSliderUI;
import com.bric.plaf.PlafPaintUtils;
import com.bric.swing.GradientSlider;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class GradientSliderUI
extends MultiThumbSliderUI {
    int TRIANGLE_SIZE = 8;
    BufferedImage img = new BufferedImage(1000, 1, 2);
    int[] array = new int[this.img.getWidth()];
    static TexturePaint checkerPaint;
    static GeneralPath hTriangle;
    static GeneralPath vTriangle;

    public GradientSliderUI(GradientSlider gradientSlider) {
        super(gradientSlider);
    }

    @Override
    public int getClickLocationTolerance() {
        return this.TRIANGLE_SIZE;
    }

    protected void calculateImage() {
        int n;
        Color[] colorArray;
        Object[] objectArray;
        float[] fArray = this.slider.getThumbPositions();
        Color[] colorArray2 = ((GradientSlider)this.slider).getColors();
        if (fArray[0] != 0.0f) {
            objectArray = new float[fArray.length + 1];
            System.arraycopy(fArray, 0, objectArray, 1, fArray.length);
            colorArray = new Color[colorArray2.length + 1];
            System.arraycopy(colorArray2, 0, colorArray, 1, fArray.length);
            fArray = objectArray;
            colorArray2 = colorArray;
            fArray[0] = 0.0f;
            colorArray2[0] = colorArray2[1];
        }
        if (fArray[fArray.length - 1] != 1.0f) {
            objectArray = new float[fArray.length + 1];
            System.arraycopy(fArray, 0, objectArray, 0, fArray.length);
            colorArray = new Color[colorArray2.length + 1];
            System.arraycopy(colorArray2, 0, colorArray, 0, fArray.length);
            fArray = objectArray;
            colorArray2 = colorArray;
            fArray[fArray.length - 1] = 1.0f;
            colorArray2[colorArray2.length - 1] = colorArray2[colorArray2.length - 2];
        }
        objectArray = new int[colorArray2.length];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = ((colorArray2[n].getAlpha() & 0xFF) << 24) + ((colorArray2[n].getRed() & 0xFF) << 16) + ((colorArray2[n].getGreen() & 0xFF) << 8) + ((colorArray2[n].getBlue() & 0xFF) << 0);
        }
        n = this.slider.getOrientation() == 0 ? this.trackRect.width : this.trackRect.height;
        if (n <= 0) {
            return;
        }
        boolean bl = GradientSliderUI.getProperty(this.slider, "GradientSlider.showTranslucency", "true").equals("false");
        int n2 = 0;
        int n3 = 1;
        int n4 = objectArray[0] >> 24 & 0xFF;
        int n5 = (objectArray[0] & 0xFF0000) >> 16;
        int n6 = (objectArray[0] & 0xFF00) >> 8;
        int n7 = (objectArray[0] & 0xFF) >> 0;
        int n8 = objectArray[1] >> 24 & 0xFF;
        int n9 = (objectArray[1] & 0xFF0000) >> 16;
        int n10 = (objectArray[1] & 0xFF00) >> 8;
        int n11 = (objectArray[1] & 0xFF) >> 0;
        for (int i = 0; i < n; ++i) {
            float f;
            float f2 = (float)i / (float)(n - 1);
            if (f2 < 1.0f && f2 >= fArray[n3]) {
                while (f2 < 1.0f && f2 >= fArray[n3]) {
                    ++n2;
                    ++n3;
                }
                n4 = objectArray[n2] >> 24 & 0xFF;
                n5 = (objectArray[n2] & 0xFF0000) >> 16;
                n6 = (objectArray[n2] & 0xFF00) >> 8;
                n7 = (objectArray[n2] & 0xFF) >> 0;
                n8 = objectArray[n3] >> 24 & 0xFF;
                n9 = (objectArray[n3] & 0xFF0000) >> 16;
                n10 = (objectArray[n3] & 0xFF00) >> 8;
                n11 = (objectArray[n3] & 0xFF) >> 0;
            }
            if ((f = (f2 - fArray[n2]) / (fArray[n3] - fArray[n2])) > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (bl) {
                n4 = 255;
                n8 = 255;
            }
            this.array[i] = ((int)((float)n4 * (1.0f - f) + (float)n8 * f) << 24) + ((int)((float)n5 * (1.0f - f) + (float)n9 * f) << 16) + ((int)((float)n6 * (1.0f - f) + (float)n10 * f) << 8) + (int)((float)n7 * (1.0f - f) + (float)n11 * f);
        }
        this.img.getRaster().setDataElements(0, 0, n, 1, this.array);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        if (this.slider.getOrientation() == 0) {
            dimension.height += 2;
        } else {
            dimension.width += 2;
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 0) {
            dimension.height += 2;
        } else {
            dimension.width += 2;
        }
        return dimension;
    }

    @Override
    protected Rectangle calculateTrackRect() {
        int n = this.slider.getWidth();
        int n2 = this.slider.getHeight();
        Rectangle rectangle = new Rectangle();
        if (this.slider.getOrientation() == 0) {
            rectangle.x = this.TRIANGLE_SIZE;
            rectangle.y = 3;
            rectangle.height = n2 - this.TRIANGLE_SIZE - rectangle.y;
            rectangle.width = n - 2 * this.TRIANGLE_SIZE;
            if (rectangle.width > this.img.getWidth()) {
                rectangle.width = this.img.getWidth();
                rectangle.x = (n - 2 * this.TRIANGLE_SIZE) / 2 - rectangle.width / 2;
            }
            if (rectangle.height > 2 * this.DEPTH) {
                rectangle.height = 2 * this.DEPTH;
                rectangle.y = (n2 - this.TRIANGLE_SIZE) / 2 - rectangle.height / 2;
            }
        } else {
            rectangle.x = 3;
            rectangle.y = this.TRIANGLE_SIZE;
            rectangle.width = n - this.TRIANGLE_SIZE - rectangle.x;
            rectangle.height = n2 - 2 * this.TRIANGLE_SIZE;
            if (rectangle.height > this.img.getWidth()) {
                rectangle.height = this.img.getWidth();
                rectangle.y = (n2 - 2 * this.TRIANGLE_SIZE) / 2 - rectangle.height / 2;
            }
            if (rectangle.width > 2 * this.DEPTH) {
                rectangle.width = 2 * this.DEPTH;
                rectangle.x = (n - this.TRIANGLE_SIZE) / 2 - rectangle.width / 2;
            }
        }
        return rectangle;
    }

    @Override
    protected void calculateGeometry() {
        super.calculateGeometry();
        this.calculateImage();
    }

    private static void createCheckerPaint() {
        int n = 4;
        BufferedImage bufferedImage = new BufferedImage(2 * n, 2 * n, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 2 * n, 2 * n);
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillRect(0, 0, n, n);
        graphics2D.fillRect(n, n, n, n);
        checkerPaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    private Shape getFrame() {
        if (GradientSliderUI.getProperty(this.slider, "GradientSlider.useBevel", "false").equals("true")) {
            return this.trackRect;
        }
        if (this.slider.getOrientation() == 0) {
            int n = Math.min(this.TRIANGLE_SIZE - 2, this.trackRect.height / 2);
            return new RoundRectangle2D.Float(this.trackRect.x - n, this.trackRect.y, this.trackRect.width + 2 * n, this.trackRect.height, n * 2, n * 2);
        }
        int n = Math.min(this.TRIANGLE_SIZE - 2, this.trackRect.width / 2);
        return new RoundRectangle2D.Float(this.trackRect.x, this.trackRect.y - n, this.trackRect.width, this.trackRect.height + 2 * n, n * 2, n * 2);
    }

    @Override
    protected void paintTrack(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        float f = this.slider.isEnabled() ? 1.0f : 0.5f;
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        Shape shape = this.getFrame();
        boolean bl = GradientSliderUI.getProperty(this.slider, "GradientSlider.showTranslucency", "true").equals("false");
        if (!bl) {
            if (checkerPaint == null) {
                GradientSliderUI.createCheckerPaint();
            }
            graphics2D.setPaint(checkerPaint);
            graphics2D.fill(shape);
        }
        TexturePaint texturePaint = new TexturePaint(this.img, new Rectangle(this.trackRect.x, 0, this.img.getWidth(), 1));
        graphics2D.setPaint(texturePaint);
        AffineTransform affineTransform = null;
        affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        if (this.slider.getOrientation() == 1) {
            if (this.slider.isInverted()) {
                affineTransform2.rotate(1.5707963267948966, this.trackRect.x, this.trackRect.y);
            } else {
                affineTransform2.rotate(-1.5707963267948966, this.trackRect.x, this.trackRect.y + this.trackRect.height);
            }
        } else if (this.slider.isInverted()) {
            double d = this.trackRect.x;
            double d2 = this.trackRect.x + this.trackRect.width;
            double d3 = (d2 - d) / (d - d2);
            double d4 = d - d3 * d2;
            affineTransform2.setTransform(d3, 0.0, 0.0, 1.0, d4, 0.0);
        }
        graphics2D.transform(affineTransform2);
        try {
            graphics2D.fill(affineTransform2.createInverse().createTransformedShape(this.trackRect));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
        if (GradientSliderUI.getProperty(this.slider, "GradientSlider.useBevel", "false").equals("true")) {
            PlafPaintUtils.drawBevel(graphics2D, this.trackRect);
        } else {
            int n;
            int n2;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape shape2 = graphics2D.getClip();
            Color[] colorArray = ((GradientSlider)this.slider).getColors();
            float[] fArray = this.slider.getThumbPositions();
            if (!this.slider.isInverted() && this.slider.getOrientation() == 0 || this.slider.isInverted() && this.slider.getOrientation() == 1) {
                n2 = 0;
                n = colorArray.length - 1;
                while (fArray[n2] < 0.0f) {
                    ++n2;
                }
                while (fArray[n] > 1.0f) {
                    --n;
                }
            } else {
                n = 0;
                n2 = colorArray.length - 1;
                while (fArray[n] < 0.0f) {
                    ++n;
                }
                while (fArray[n2] > 1.0f) {
                    --n2;
                }
            }
            if (this.slider.getOrientation() == 0) {
                graphics2D.clip(shape);
                graphics2D.setColor(colorArray[n2]);
                graphics2D.fillRect(0, 0, this.trackRect.x, this.slider.getHeight());
                graphics2D.setColor(colorArray[n]);
                graphics2D.fillRect(this.trackRect.x + this.trackRect.width, 0, this.slider.getWidth() - (this.trackRect.x + this.trackRect.width), this.slider.getHeight());
            } else {
                graphics2D.clip(shape);
                graphics2D.setColor(colorArray[n2]);
                graphics2D.fillRect(0, 0, this.slider.getWidth(), this.trackRect.y);
                graphics2D.setColor(colorArray[n]);
                graphics2D.fillRect(0, this.trackRect.y + this.trackRect.height, this.slider.getWidth(), this.slider.getHeight() - (this.trackRect.y + this.trackRect.height));
            }
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setClip(shape2);
            graphics2D.setColor(new Color(0, 0, 0, 130));
            graphics2D.draw(shape);
            graphics2D.setColor(new Color(0, 0, 0, 130));
        }
        if (this.slider.isPaintTicks()) {
            this.paintTick(graphics2D, 0.25f, 2);
            this.paintTick(graphics2D, 0.5f, 2);
            this.paintTick(graphics2D, 0.75f, 2);
            this.paintTick(graphics2D, 0.0f, 2);
            this.paintTick(graphics2D, 1.0f, 2);
        }
        graphics2D.setComposite(composite);
    }

    protected void paintTick(Graphics2D graphics2D, float f, int n) {
        if (this.slider.getOrientation() == 0) {
            int n2 = (int)((float)this.trackRect.x + (float)this.trackRect.width * f + 0.5f);
            int n3 = this.trackRect.y + this.trackRect.height;
            graphics2D.drawLine(n2, n3, n2, n3 + n);
            n3 = this.trackRect.y;
            graphics2D.drawLine(n2, n3, n2, n3 - n);
        } else {
            int n4 = (int)((float)this.trackRect.y + (float)this.trackRect.height * f + 0.5f);
            int n5 = this.trackRect.x + this.trackRect.width;
            graphics2D.drawLine(n5, n4, n5 + n, n4);
            n5 = this.trackRect.x;
            graphics2D.drawLine(n5, n4, n5 - n, n4);
        }
    }

    @Override
    protected void paintFocus(Graphics2D graphics2D) {
    }

    @Override
    protected void paintThumbs(Graphics2D graphics2D) {
        GeneralPath generalPath;
        if (!this.slider.isEnabled()) {
            return;
        }
        if (hTriangle == null) {
            hTriangle = new GeneralPath();
            hTriangle.moveTo(0.0f, 0.0f);
            hTriangle.lineTo(this.TRIANGLE_SIZE, this.TRIANGLE_SIZE);
            hTriangle.lineTo(-this.TRIANGLE_SIZE, this.TRIANGLE_SIZE);
            hTriangle.lineTo(0.0f, 0.0f);
            hTriangle.closePath();
            vTriangle = new GeneralPath();
            vTriangle.moveTo(0.0f, 0.0f);
            vTriangle.lineTo(this.TRIANGLE_SIZE, this.TRIANGLE_SIZE);
            vTriangle.lineTo(this.TRIANGLE_SIZE, -this.TRIANGLE_SIZE);
            vTriangle.lineTo(0.0f, 0.0f);
            vTriangle.closePath();
        }
        AffineTransform affineTransform = new AffineTransform();
        int n = this.trackRect.x + this.trackRect.width;
        int n2 = this.trackRect.y + this.trackRect.height;
        n2 -= this.trackRect.height / 6;
        n -= this.trackRect.width / 6;
        int n3 = this.slider.getSelectedThumb(false);
        float[] fArray = this.slider.getThumbPositions();
        int n4 = this.slider.getOrientation();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.indication));
        for (int i = 0; i < this.thumbPositions.length; ++i) {
            if (!(fArray[i] >= 0.0f) || !(fArray[i] <= 1.0f) || i == n3) continue;
            if (n4 == 0) {
                n = this.thumbPositions[i];
                generalPath = hTriangle;
            } else {
                n2 = this.thumbPositions[i];
                generalPath = vTriangle;
            }
            affineTransform.setToTranslation(n, n2);
            graphics2D.transform(affineTransform);
            float f = Math.max(0.0f, this.thumbIndications[i] * 0.6f);
            graphics2D.setColor(new Color((int)(255.0f * f), (int)(255.0f * f), (int)(255.0f * f)));
            graphics2D.fill(generalPath);
            graphics2D.translate(-0.5, -0.5);
            graphics2D.setColor(new Color(255, 255, 255));
            graphics2D.draw(generalPath);
            graphics2D.translate(0.5, 0.5);
            affineTransform.setToTranslation(-n, -n2);
            graphics2D.transform(affineTransform);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.indication));
        if (n3 != -1 && fArray[n3] >= 0.0f && fArray[n3] <= 1.0f) {
            if (n4 == 0) {
                n = this.thumbPositions[n3];
                generalPath = hTriangle;
            } else {
                n2 = this.thumbPositions[n3];
                generalPath = vTriangle;
            }
            affineTransform.setToTranslation(n, n2);
            graphics2D.transform(affineTransform);
            graphics2D.setColor(new Color(255, 255, 255));
            graphics2D.fill(generalPath);
            graphics2D.translate(-0.5, -0.5);
            graphics2D.setColor(new Color(0, 0, 0));
            graphics2D.draw(generalPath);
            graphics2D.translate(0.5, 0.5);
            affineTransform.setToTranslation(-n, -n2);
            graphics2D.transform(affineTransform);
        }
        graphics2D.setComposite(composite);
    }

    static {
        hTriangle = null;
        vTriangle = null;
    }
}

