/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import com.bric.geom.PathWriter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public abstract class PathSegment {
    public int type;

    public static final String toTypeName(int n) {
        if (n == 4) {
            return "SEG_CLOSE";
        }
        if (n == 3) {
            return "SEG_CUBICTO";
        }
        if (n == 1) {
            return "SEG_LINETO";
        }
        if (n == 0) {
            return "SEG_MOVETO";
        }
        if (n == 2) {
            return "SEG_QUADTO";
        }
        return "UNKNOWN";
    }

    public abstract void rotate(float var1);

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < fArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(java.lang.Float.toString(fArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class Float
    extends PathSegment {
        public float[] data;
        public Float next;
        public Float prev;
        private float[] xCoeffs;
        private float[] yCoeffs;
        protected static final float ZERO = 0.01f;

        public Float(float f, float f2) {
            this.type = 0;
            this.data = new float[]{f, f2};
        }

        protected Float() {
        }

        protected Float newSegment() {
            return new Float();
        }

        public float[] getXCoeffs() {
            return this.getXCoeffs(null);
        }

        public float[] getXCoeffs(AffineTransform affineTransform) {
            float[] fArray;
            if (this.prev == null) {
                System.err.println(this);
                throw new NullPointerException("prev was null");
            }
            if (this.prev.data == null) {
                System.err.println(this);
                throw new NullPointerException("prev.data was null");
            }
            if (affineTransform != null && affineTransform.isIdentity()) {
                affineTransform = null;
            }
            if (this.xCoeffs != null && affineTransform == null) {
                return this.xCoeffs;
            }
            double[] dArray = new double[]{this.prev.data[this.prev.data.length - 2], this.prev.data[this.prev.data.length - 1]};
            if (affineTransform != null) {
                affineTransform.transform(dArray, 0, dArray, 0, 1);
            }
            if (affineTransform != null) {
                fArray = new float[this.data.length];
                affineTransform.transform(this.data, 0, fArray, 0, this.data.length / 2);
            } else {
                fArray = this.data;
            }
            float[] fArray2 = null;
            if (this.type == 3) {
                fArray2 = new float[]{(float)(-dArray[0] + (double)(3.0f * fArray[0]) - (double)(3.0f * fArray[2]) + (double)fArray[4]), (float)(3.0 * dArray[0] - (double)(6.0f * fArray[0]) + (double)(3.0f * fArray[2])), (float)(-3.0 * dArray[0] + (double)(3.0f * fArray[0])), (float)dArray[0]};
            } else if (this.type == 2) {
                fArray2 = new float[]{(float)(dArray[0] - (double)(2.0f * fArray[0]) + (double)fArray[2]), (float)(-2.0 * dArray[0] + (double)(2.0f * fArray[0])), (float)dArray[0]};
            } else if (this.type == 1) {
                fArray2 = new float[]{(float)(-dArray[0] + (double)fArray[0]), (float)dArray[0]};
            } else {
                if (this.type == 0) {
                    throw new UnsupportedOperationException("MOVETO segments cannot be broken down into parametric equations.");
                }
                if (this.type == 4) {
                    throw new UnsupportedOperationException("CLOSE segments cannot be broken down into parametric equations.");
                }
            }
            if (affineTransform == null) {
                this.xCoeffs = fArray2;
            }
            return fArray2;
        }

        public float[] getYCoeffs() {
            return this.getYCoeffs(null);
        }

        public float[] getYCoeffs(AffineTransform affineTransform) {
            float[] fArray;
            if (this.prev == null) {
                throw new NullPointerException("prev was null");
            }
            if (this.prev.data == null) {
                throw new NullPointerException("prev.data was null");
            }
            if (affineTransform != null && affineTransform.isIdentity()) {
                affineTransform = null;
            }
            if (this.yCoeffs != null && affineTransform == null) {
                return this.yCoeffs;
            }
            double[] dArray = new double[]{this.prev.data[this.prev.data.length - 2], this.prev.data[this.prev.data.length - 1]};
            if (affineTransform != null) {
                affineTransform.transform(dArray, 0, dArray, 0, 1);
            }
            if (affineTransform != null) {
                fArray = new float[this.data.length];
                affineTransform.transform(this.data, 0, fArray, 0, this.data.length / 2);
            } else {
                fArray = this.data;
            }
            float[] fArray2 = null;
            if (this.type == 3) {
                fArray2 = new float[]{(float)(-dArray[1] + (double)(3.0f * fArray[1]) - (double)(3.0f * fArray[3]) + (double)fArray[5]), (float)(3.0 * dArray[1] - (double)(6.0f * fArray[1]) + (double)(3.0f * fArray[3])), (float)(-3.0 * dArray[1] + (double)(3.0f * fArray[1])), (float)dArray[1]};
            } else if (this.type == 2) {
                fArray2 = new float[]{(float)(dArray[1] - (double)(2.0f * fArray[1]) + (double)fArray[3]), (float)(-2.0 * dArray[1] + (double)(2.0f * fArray[1])), (float)dArray[1]};
            } else if (this.type == 1) {
                fArray2 = new float[]{(float)(-dArray[1] + (double)fArray[1]), (float)dArray[1]};
            } else {
                if (this.type == 0) {
                    throw new UnsupportedOperationException("MOVETO segments cannot be broken down into parametric equations.");
                }
                if (this.type == 4) {
                    throw new UnsupportedOperationException("CLOSE segments cannot be broken down into parametric equations.");
                }
            }
            if (affineTransform == null) {
                this.yCoeffs = fArray2;
            }
            return fArray2;
        }

        public float getTheta(float f, boolean bl) {
            float f2 = this.getTheta(f, 0);
            if (bl) {
                if ((double)f2 > 1.5707963267948966) {
                    f2 -= (float)Math.PI;
                } else if ((double)f2 < -1.5707963267948966) {
                    f2 += (float)Math.PI;
                }
            }
            return f2;
        }

        public boolean isThetaWellDefined(float f) {
            float f2;
            float f3;
            float[] fArray = this.getXCoeffs();
            float[] fArray2 = this.getYCoeffs();
            if (fArray.length == 2) {
                f3 = fArray[0];
                f2 = fArray2[0];
            } else if (fArray.length == 3) {
                f3 = 2.0f * fArray[0] * f + fArray[1];
                f2 = 2.0f * fArray2[0] * f + fArray2[1];
            } else if (fArray.length == 4) {
                f3 = 3.0f * fArray[0] * f * f + 2.0f * fArray[1] * f + fArray[2];
                f2 = 3.0f * fArray2[0] * f * f + 2.0f * fArray2[1] * f + fArray2[2];
            } else {
                System.err.println("x_coeffs.length = " + fArray.length);
                System.err.println(this);
                throw new RuntimeException("Unexpected condition.");
            }
            return !(Math.abs(f3) < 0.01f) || !(Math.abs(f2) < 0.01f);
        }

        public float getTheta(float f, int n) {
            float f2;
            float f3;
            float[] fArray = this.getXCoeffs();
            float[] fArray2 = this.getYCoeffs();
            if (fArray.length == 2) {
                f3 = fArray[0];
                f2 = fArray2[0];
            } else if (fArray.length == 3) {
                f3 = 2.0f * fArray[0] * f + fArray[1];
                f2 = 2.0f * fArray2[0] * f + fArray2[1];
            } else if (fArray.length == 4) {
                f3 = 3.0f * fArray[0] * f * f + 2.0f * fArray[1] * f + fArray[2];
                f2 = 3.0f * fArray2[0] * f * f + 2.0f * fArray2[1] * f + fArray2[2];
            } else {
                System.err.println("x_coeffs.length = " + fArray.length);
                System.err.println(this);
                throw new RuntimeException("Unexpected condition.");
            }
            if (!(Math.abs(f3) < 0.01f) || !(Math.abs(f2) < 0.01f)) {
                float f4 = (float)Math.atan2(f2, f3);
                return f4;
            }
            if (fArray.length == 3) {
                f3 = 2.0f * fArray[0];
                f2 = 2.0f * fArray2[0];
            } else if (fArray.length == 4) {
                f3 = 6.0f * fArray[0] * f + 2.0f * fArray[1];
                f2 = 6.0f * fArray2[0] * f + 2.0f * fArray2[1];
            }
            float f5 = (float)Math.atan2(f2, f3);
            float f6 = f5 > 0.0f ? f5 - (float)Math.PI : f5 + (float)Math.PI;
            if (n == 0) {
                return f5;
            }
            if (fArray.length == 2) {
                return f5;
            }
            f3 = 0.0f;
            f2 = 0.0f;
            if (n > 1) {
                n = 1;
            }
            if (n < 1) {
                n = -1;
            }
            float f7 = 1.0E-6f * (float)n;
            while (Math.abs(f3) < 0.01f && Math.abs(f2) < 0.01f) {
                if (fArray.length == 3) {
                    f3 = 2.0f * fArray[0] * f + fArray[1];
                    f2 = 2.0f * fArray2[0] * f + fArray2[1];
                } else if (fArray.length == 4) {
                    f3 = 3.0f * fArray[0] * f * f + 2.0f * fArray[1] * f + fArray[2];
                    f2 = 3.0f * fArray2[0] * f * f + 2.0f * fArray2[1] * f + fArray2[2];
                }
                f += f7;
            }
            float f8 = (float)Math.atan2(f2, f3);
            if (this.difference(f8, f5) < this.difference(f8, f6)) {
                return f5;
            }
            return f6;
        }

        private float difference(float f, float f2) {
            float f3 = Math.abs(f - f2);
            if ((double)f3 > Math.PI) {
                f3 = (float)(Math.PI * 2 - (double)f3);
            }
            return f3;
        }

        public float getX(float f) {
            float[] fArray = this.getXCoeffs();
            if (fArray.length == 2) {
                return fArray[0] * f + fArray[1];
            }
            if (fArray.length == 3) {
                return fArray[0] * f * f + fArray[1] * f + fArray[2];
            }
            if (fArray.length == 4) {
                return fArray[0] * f * f * f + fArray[1] * f * f + fArray[2] * f + fArray[3];
            }
            System.err.println("x_coeffs.length = " + fArray.length);
            System.err.println(this);
            throw new RuntimeException("Unexpected condition.");
        }

        public float getY(float f) {
            float[] fArray = this.getYCoeffs();
            if (fArray.length == 2) {
                return fArray[0] * f + fArray[1];
            }
            if (fArray.length == 3) {
                return fArray[0] * f * f + fArray[1] * f + fArray[2];
            }
            if (fArray.length == 4) {
                return fArray[0] * f * f * f + fArray[1] * f * f + fArray[2] * f + fArray[3];
            }
            System.err.println("y_coeffs.length = " + fArray.length);
            System.err.println(this);
            throw new RuntimeException("Unexpected condition.");
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Float float_) {
            return "PathSegment.Float[ " + this.getPath(float_) + " ]";
        }

        protected String getPath(Float float_) {
            StringBuffer stringBuffer = new StringBuffer();
            Float float_2 = this;
            while (float_2 != float_ && float_2 != null) {
                if (float_2.type == 0) {
                    stringBuffer.append("m " + float_2.data[0] + " " + float_2.data[1] + " ");
                } else if (float_2.type == 1) {
                    stringBuffer.append("l " + float_2.data[0] + " " + float_2.data[1] + " ");
                } else if (float_2.type == 2) {
                    stringBuffer.append("q " + float_2.data[0] + " " + float_2.data[1] + " " + float_2.data[2] + " " + float_2.data[3] + " ");
                } else if (float_2.type == 3) {
                    stringBuffer.append("c " + float_2.data[0] + " " + float_2.data[1] + " " + float_2.data[2] + " " + float_2.data[3] + " " + float_2.data[4] + " " + float_2.data[5] + " ");
                } else if (float_2.type == 4) {
                    stringBuffer.append("z ");
                } else {
                    throw new RuntimeException("Unexpected type: " + this.type);
                }
                float_2 = float_2.next;
            }
            return stringBuffer.toString().trim();
        }

        public Float moveTo(float f, float f2) {
            Float float_ = this.newSegment();
            float_.type = 0;
            float_.data = new float[]{f, f2};
            this.append(float_);
            return float_;
        }

        public Float lineTo(float f, float f2) {
            Float float_ = this.newSegment();
            float_.type = 1;
            float_.data = new float[]{f, f2};
            this.append(float_);
            return float_;
        }

        public Float quadTo(float f, float f2, float f3, float f4) {
            Float float_ = this.newSegment();
            float_.type = 2;
            float_.data = new float[]{f, f2, f3, f4};
            this.append(float_);
            return float_;
        }

        public Float cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
            Float float_ = this.newSegment();
            float_.type = 3;
            float_.data = new float[]{f, f2, f3, f4, f5, f6};
            this.append(float_);
            return float_;
        }

        public Float close() {
            Float float_ = this.newSegment();
            float_.type = 4;
            this.append(float_);
            return float_;
        }

        protected void append(Float float_) {
            if (this.next != null) {
                throw new RuntimeException("Illegal attempt to append shape data to a segment that already has a next segment.");
            }
            if (float_.prev != null) {
                throw new RuntimeException("Illegal attempt to append shape data that already exists in another sequence.");
            }
            this.next = float_;
            float_.prev = this;
        }

        public Float getHead() {
            Float float_ = this;
            while (float_.prev != null) {
                float_ = float_.prev;
            }
            return float_;
        }

        public Float getTail() {
            Float float_ = this;
            while (float_.next != null) {
                float_ = float_.next;
            }
            return float_;
        }

        @Override
        public void rotate(float f) {
            if (f == 0.0f) {
                return;
            }
            float f2 = (float)Math.cos(f);
            float f3 = (float)Math.sin(f);
            for (int i = 0; i < this.data.length; i += 2) {
                float f4 = this.data[i];
                float f5 = this.data[i + 1];
                this.data[i] = f2 * f4 - f3 * f5;
                this.data[i + 1] = f3 * f4 + f2 * f5;
            }
            this.xCoeffs = null;
            this.yCoeffs = null;
        }

        public void write(GeneralPath generalPath, float f, float f2, AffineTransform affineTransform) {
            if (this.type == 1) {
                double[] dArray = new double[]{this.getX(f2), this.getY(f2)};
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 1);
                }
                generalPath.lineTo((float)dArray[0], (float)dArray[1]);
            } else if (this.type == 2) {
                float[] fArray = this.getXCoeffs(affineTransform);
                float[] fArray2 = this.getYCoeffs(affineTransform);
                PathWriter.quadTo(generalPath, (double)f, (double)f2, (double)fArray[0], (double)fArray[1], (double)fArray[2], (double)fArray2[0], (double)fArray2[1], (double)fArray2[2]);
            } else if (this.type == 3) {
                float[] fArray = this.getXCoeffs(affineTransform);
                float[] fArray3 = this.getYCoeffs(affineTransform);
                PathWriter.cubicTo(generalPath, (double)f, (double)f2, (double)fArray[0], (double)fArray[1], (double)fArray[2], (double)fArray[3], (double)fArray3[0], (double)fArray3[1], (double)fArray3[2], (double)fArray3[3]);
            } else {
                throw new UnsupportedOperationException(Float.toTypeName(this.type) + " not supported here.");
            }
        }
    }
}

