/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.ImageMath;
import imager.plugins.Noise;
import imager.plugins.TransformFilter;
import java.awt.Rectangle;

public class RippleFilter
extends TransformFilter {
    static final long serialVersionUID = 5101667633854087384L;
    public static final int SINE = 0;
    public static final int SAWTOOTH = 1;
    public static final int TRIANGLE = 2;
    public static final int NOISE = 3;
    public float xAmplitude = 5.0f;
    public float yAmplitude = 0.0f;
    public float xWavelength = 16.0f;
    public float yWavelength = 16.0f;
    private int U_waveType;

    public void setXAmplitude(float f) {
        this.xAmplitude = f;
    }

    public float getXAmplitude() {
        return this.xAmplitude;
    }

    public void setXWavelength(float f) {
        this.xWavelength = f;
    }

    public float getXWavelength() {
        return this.xWavelength;
    }

    public void setYAmplitude(float f) {
        this.yAmplitude = f;
    }

    public float getYAmplitude() {
        return this.yAmplitude;
    }

    public void setYWavelength(float f) {
        this.yWavelength = f;
    }

    public float getYWavelength() {
        return this.yWavelength;
    }

    public void setWaveType(int n) {
        this.U_waveType = n;
    }

    public int getWaveType() {
        return this.U_waveType;
    }

    protected void transformSpace(Rectangle rectangle) {
        if (this.edgeAction == 0) {
            rectangle.x -= (int)this.xAmplitude;
            rectangle.width += (int)(2.0f * this.xAmplitude);
            rectangle.y -= (int)this.yAmplitude;
            rectangle.height += (int)(2.0f * this.yAmplitude);
        }
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f;
        float f2;
        float f3 = (float)n2 / this.xWavelength;
        float f4 = (float)n / this.yWavelength;
        switch (this.U_waveType) {
            default: {
                f2 = (float)Math.sin(f3);
                f = (float)Math.sin(f4);
                break;
            }
            case 1: {
                f2 = ImageMath.mod(f3, 1.0f);
                f = ImageMath.mod(f4, 1.0f);
                break;
            }
            case 2: {
                f2 = ImageMath.triangle(f3);
                f = ImageMath.triangle(f4);
                break;
            }
            case 3: {
                f2 = Noise.noise1(f3);
                f = Noise.noise1(f4);
            }
        }
        fArray[0] = (float)n + this.xAmplitude * f2;
        fArray[1] = (float)n2 + this.yAmplitude * f;
    }

    public String toString() {
        return "Distort/Ripple...";
    }
}

