/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.MemoryFileInputFilter;
import imager.imagefileio.TIFF.enhanced.MotorolaIntelInputFilter;
import imager.imagefileio.TIFF.enhanced.tiff.Header;
import imager.imagefileio.TIFF.enhanced.tiff.IFD;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class Tiff {
    Header header = new Header();
    IFD[] pages = null;
    int pageCount = 0;

    public int getPageCount() {
        return this.pageCount;
    }

    public Image getImage(int n) {
        if (this.pageCount == 0 || n > this.pageCount) {
            return null;
        }
        return this.pages[n].getImage();
    }

    public Object getImageProducer(int n) {
        if (this.pageCount == 0 || n > this.pageCount) {
            return null;
        }
        return this.pages[n].getImageProducer();
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        long l = this.header.offset;
        MotorolaIntelInputFilter motorolaIntelInputFilter = new MotorolaIntelInputFilter(randomAccessFile, this.header.byteOrder == 18761);
        if (this.pageCount == 0) {
            return;
        }
        this.header.write(motorolaIntelInputFilter);
        l = this.header.offset;
        int n = 0;
        while (n < this.pageCount) {
            motorolaIntelInputFilter.seek(l);
            this.pages[n].write(motorolaIntelInputFilter);
            l = this.pages[n].offset;
            ++n;
        }
    }

    public void readInputStream(InputStream inputStream) throws IOException {
        int n = 10240;
        int n2 = 10 * n;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while ((n4 = inputStream.read(byArray)) != -1) {
            if (n3 + n4 > n2) {
                byte[] byArray3 = new byte[n3 + n4 + n];
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
                n2 = n3 + n4 + n;
                byArray2 = byArray3;
            }
            System.arraycopy(byArray, 0, byArray2, n3, n4);
            n3 += n4;
        }
        byArray = null;
        byArray = new byte[n3];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        byArray2 = byArray;
        this.read(byArray2);
    }

    public void read(byte[] byArray) throws IOException {
        MemoryFileInputFilter memoryFileInputFilter = new MemoryFileInputFilter(byArray);
        this.pageCount = 0;
        this.pages = new IFD[10];
        this.header.read(memoryFileInputFilter);
        long l = this.header.offset;
        while (l != 0L) {
            memoryFileInputFilter.seek(l);
            this.pages[this.pageCount] = new IFD();
            this.pages[this.pageCount].read(memoryFileInputFilter);
            l = this.pages[this.pageCount].offset;
            ++this.pageCount;
            if (this.pageCount < 10 || l == 0L) continue;
            System.out.println("Oop, I was cheating and only allowed for 10 pages in a tif file");
            break;
        }
        memoryFileInputFilter.close();
    }

    public String toString() {
        String string = "Tiff has " + this.pageCount + " pages\n\n";
        string = String.valueOf(string) + this.header.toString() + "\n";
        int n = 0;
        while (n < this.pageCount) {
            string = String.valueOf(string) + "Page #" + n + "\n" + this.pages[n].toString();
            ++n;
        }
        return string;
    }
}

