/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.Converter;
import imager.imagefileio.TIFF.enhanced.tiff.T4Tables;

class T4Code {
    public static final int EOL = -1;
    public static final int INVALID = -2;
    public static final int EOF = -3;
    public static final int INCOMP = -4;
    public int bitLength;
    public int codeWord;
    public int runLength;

    public T4Code() {
        this.bitLength = 0;
        this.codeWord = 0;
        this.runLength = 0;
    }

    public T4Code(T4Code t4Code) {
        if (t4Code != null) {
            this.bitLength = t4Code.bitLength;
            this.codeWord = t4Code.codeWord;
            this.runLength = t4Code.runLength;
        } else {
            this.bitLength = 0;
            this.codeWord = 0;
            this.runLength = 0;
        }
    }

    public T4Code(int n, int n2, int n3) {
        this.bitLength = n;
        this.codeWord = n2;
        this.runLength = n3;
    }

    public T4Code(int[] nArray) {
        if (nArray.length == 3) {
            this.bitLength = nArray[0];
            this.codeWord = nArray[1];
            this.runLength = nArray[2];
        } else {
            this.bitLength = 0;
            this.codeWord = 0;
            this.runLength = 0;
        }
    }

    public T4Code(byte[] byArray, boolean bl) {
        this();
        T4Code t4Code = this.getCode(byArray, bl);
        if (t4Code != null) {
            this.bitLength = t4Code.bitLength;
            this.codeWord = t4Code.codeWord;
            this.runLength = t4Code.runLength;
        }
    }

    public T4Code getCode(byte[] byArray, boolean bl) {
        int n;
        int[][] nArray;
        T4Code t4Code = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (bl) {
            nArray = T4Tables.WhiteCodes;
            n = byArray[0] == 0 ? 92 : 0;
        } else {
            nArray = T4Tables.BlackCodes;
            n = byArray[0] == 0 ? 15 : 0;
        }
        while (!bl2 && n < nArray.length) {
            int[] nArray2 = nArray[n];
            if (n2 != nArray2[0]) {
                n2 = nArray2[0];
                n3 = Converter.getBits(byArray, n2);
            }
            if (n3 == nArray2[1]) {
                t4Code = new T4Code(nArray2);
                bl2 = true;
            }
            ++n;
        }
        return t4Code;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(this.bitLength);
        stringBuffer.append(",");
        stringBuffer.append(this.runLength);
        stringBuffer.append(",");
        stringBuffer.append(Converter.intToBinaryString(this.codeWord, this.bitLength));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

