/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.tiff.IFD;
import imager.imagefileio.TIFF.enhanced.tiff.RawImage;

class PackbitsImage
extends RawImage {
    public PackbitsImage(IFD iFD) {
        super(iFD);
    }

    public Object getImageProducer() {
        if (!this.CanDecodeImage()) {
            return null;
        }
        if (this.imageBytes == null && this.imageStrips != null) {
            int n = 0;
            int n2 = 0;
            while (n < this.imageStrips.length) {
                n2 += this.imageStrips[n].length;
                ++n;
            }
            this.imageBytes = new byte[n2];
            n = 0;
            int n3 = 0;
            while (n < this.imageStrips.length) {
                System.arraycopy(this.imageStrips[n], 0, this.imageBytes, n3, this.imageStrips[n].length);
                n3 += this.imageStrips[n].length;
                ++n;
            }
            this.imageStrips = null;
        }
        if (!this.DecodeImage()) {
            return null;
        }
        return super.getImageProducer();
    }

    boolean DecodeImage() {
        int n = this.imageWidth * this.imageHeight;
        byte[] byArray = new byte[n];
        int n2 = this.imageBytes.length;
        int n3 = 0;
        int n4 = 0;
        while (n2 > 0 && (long)n > 0L) {
            long l = this.imageBytes[n3++];
            --n2;
            if (l >= 128L) {
                l -= 256L;
            }
            if (l < 0L) {
                if (l == -128L) continue;
                l = -l + 1L;
                n = (int)((long)n - l);
                byte by = this.imageBytes[n3++];
                --n2;
                while (l-- > 0L) {
                    byArray[n4++] = by;
                }
                continue;
            }
            System.arraycopy(this.imageBytes, n3, byArray, n4, (int)(++l));
            n4 = (int)((long)n4 + l);
            n = (int)((long)n - l);
            n3 = (int)((long)n3 + l);
            n2 = (int)((long)n2 - l);
        }
        this.imageBytes = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.imageBytes, 0, byArray.length);
        return true;
    }
}

