/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.MemoryFileInputFilter;
import imager.imagefileio.TIFF.enhanced.MotorolaIntelInputFilter;
import imager.imagefileio.TIFF.enhanced.tiff.CCITTG3Image;
import imager.imagefileio.TIFF.enhanced.tiff.CCITTG4Image;
import imager.imagefileio.TIFF.enhanced.tiff.CodedImage;
import imager.imagefileio.TIFF.enhanced.tiff.IFDEntry;
import imager.imagefileio.TIFF.enhanced.tiff.JPEGImage;
import imager.imagefileio.TIFF.enhanced.tiff.PackbitsImage;
import imager.imagefileio.TIFF.enhanced.tiff.RawImage;
import imager.imagefileio.TIFF.enhanced.tiff.UnisysISIS_IFD;
import imager.imagefileio.TIFF.enhanced.tiff.UnisysIXPS_IFD;
import imager.imagefileio.TIFF.enhanced.tiff.Weird_IFD;
import java.awt.Image;
import java.io.IOException;

class IFD {
    public int count;
    public IFDEntry[] entries;
    public long offset;
    CodedImage cImg;
    IFD unisys;

    public IFD() {
        this.init();
    }

    void init() {
        this.count = 0;
        this.entries = null;
        this.offset = 0L;
        this.cImg = null;
        this.unisys = null;
    }

    IFDEntry GetEntry(int n) {
        int n2 = 0;
        while (n2 < this.count) {
            if (this.entries[n2].tag.equals(n)) {
                return this.entries[n2];
            }
            ++n2;
        }
        return null;
    }

    int GetFieldValue(int n) {
        int n2 = 0;
        while (n2 < this.count) {
            if (this.entries[n2].tag.equals(n)) {
                return (int)this.entries[n2].value;
            }
            ++n2;
        }
        return 0;
    }

    int GetCompressionType() {
        return this.GetFieldValue(259);
    }

    int size() {
        return 2 + 12 * this.count + 4;
    }

    public String toString() {
        String string = "IFD Entry Count: " + this.count + "\n";
        int n = 0;
        while (n < this.count) {
            string = !this.entries[n].tag.equals(33881) && !this.entries[n].tag.equals(34975) && !this.entries[n].tag.equals(33884) ? String.valueOf(string) + "\t" + this.entries[n].toString() + "\n" : String.valueOf(string) + "\tTag: " + this.entries[n].tag.toString() + "\n";
            ++n;
        }
        if (this.unisys != null) {
            string = String.valueOf(string) + this.unisys.toString();
        }
        string = String.valueOf(string) + "\t\tNext Offset: " + this.offset + "\n";
        return string;
    }

    public Image getImage() {
        return this.cImg.getImage();
    }

    public Object getImageProducer() {
        return this.cImg.getImageProducer();
    }

    public void write(MotorolaIntelInputFilter motorolaIntelInputFilter) throws IOException {
        int n = 0;
        int n2 = 0;
        long l = this.offset;
        if (this.count == 0 || this.cImg == null) {
            return;
        }
        long l2 = motorolaIntelInputFilter.getFilePointer();
        l2 += (long)this.size();
        motorolaIntelInputFilter.writeShort(this.count);
        int n3 = 0;
        while (n3 < this.count) {
            if (this.entries[n3].tag.equals(273)) {
                n = n3;
                this.entries[n3].count = 1L;
                this.entries[n3].value = l2;
                l2 += (long)this.cImg.imageBytes.length;
            } else if (this.entries[n3].tag.equals(279)) {
                n2 = n3;
                this.entries[n3].count = 1L;
                this.entries[n3].value = this.cImg.imageBytes.length;
            }
            if (this.entries[n3].isOffset()) {
                this.entries[n3].value = l2;
                l2 += (long)this.entries[n3].sizeOfData();
            }
            this.entries[n3].writeEntry(motorolaIntelInputFilter);
            ++n3;
        }
        motorolaIntelInputFilter.writeInt((int)l);
        n3 = 0;
        while (n3 < this.count) {
            if (this.entries[n3].isOffset()) {
                this.entries[n3].writeData(motorolaIntelInputFilter);
            }
            ++n3;
        }
        this.writeImageBytes(motorolaIntelInputFilter, n, n2);
    }

    public void writeImageBytes(MotorolaIntelInputFilter motorolaIntelInputFilter, int n, int n2) throws IOException {
        int n3 = 0;
        boolean bl = false;
        if (this.entries[n2].isOffset()) {
            System.out.println("No I won't write out in strips for now");
        } else {
            n3 = (int)this.entries[n2].value;
            motorolaIntelInputFilter.seek(this.entries[n].value);
            motorolaIntelInputFilter.write(this.cImg.imageBytes, 0, n3);
        }
    }

    public void read(MemoryFileInputFilter memoryFileInputFilter) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.count = memoryFileInputFilter.readUnsignedShort();
        this.entries = new IFDEntry[this.count];
        int n4 = 0;
        while (n4 < this.count) {
            this.entries[n4] = new IFDEntry();
            this.entries[n4].read(memoryFileInputFilter);
            if (this.entries[n4].tag.equals(259)) {
                n3 = (int)this.entries[n4].value;
            }
            if (this.entries[n4].tag.equals(279)) {
                n2 = n4;
            }
            if (this.entries[n4].tag.equals(273)) {
                n = n4;
            }
            if (this.entries[n4].tag.equals(33881)) {
                this.unisys = new UnisysISIS_IFD();
                this.unisys.offset = this.entries[n4].value;
            }
            if (this.entries[n4].tag.equals(34975)) {
                this.unisys = new Weird_IFD();
                this.unisys.offset = this.entries[n4].value;
            }
            if (this.entries[n4].tag.equals(33884)) {
                this.unisys = new UnisysIXPS_IFD();
                this.unisys.offset = this.entries[n4].value;
            }
            ++n4;
        }
        this.offset = memoryFileInputFilter.readInt();
        switch (n3) {
            case 1: {
                this.cImg = new RawImage(this);
                break;
            }
            case 3: {
                this.cImg = new CCITTG3Image(this);
                break;
            }
            case 4: {
                this.cImg = new CCITTG4Image(this);
                break;
            }
            case 6: 
            case 7: {
                this.cImg = new JPEGImage(this);
                break;
            }
            case 32773: {
                this.cImg = new PackbitsImage(this);
                break;
            }
            default: {
                this.cImg = new CodedImage(this);
            }
        }
        this.readImageBytes(memoryFileInputFilter, n, n2);
        if (this.unisys != null) {
            memoryFileInputFilter.seek(this.unisys.offset);
            this.unisys.read(memoryFileInputFilter);
        }
    }

    public void readImageBytes(MemoryFileInputFilter memoryFileInputFilter, int n, int n2) {
        int n3 = 0;
        if (n2 != 0 && this.entries[n2].isOffset()) {
            long l = this.entries[n2].count;
            long[] lArray = new long[(int)l];
            this.cImg.imageStrips = new byte[(int)l][];
            memoryFileInputFilter.seek(this.entries[n2].value);
            int n4 = 0;
            n3 = 0;
            while ((long)n4 < l) {
                lArray[n4] = memoryFileInputFilter.readInt();
                n3 = (int)((long)n3 + lArray[n4]);
                ++n4;
            }
            long[] lArray2 = new long[(int)l];
            memoryFileInputFilter.seek(this.entries[n].value);
            n4 = 0;
            while ((long)n4 < l) {
                lArray2[n4] = memoryFileInputFilter.readInt();
                ++n4;
            }
            int n5 = 0;
            n4 = 0;
            while ((long)n4 < l) {
                this.cImg.imageStrips[n4] = new byte[(int)lArray[n4]];
                memoryFileInputFilter.seek(lArray2[n4]);
                memoryFileInputFilter.readFully(this.cImg.imageStrips[n4]);
                n5 = (int)((long)n5 + lArray[n4]);
                ++n4;
            }
        } else {
            long l = this.entries[n].value;
            n3 = n2 > 0 ? (int)this.entries[n2].value : (int)(memoryFileInputFilter.length() - l);
            this.cImg.imageBytes = new byte[n3];
            memoryFileInputFilter.seek(l);
            memoryFileInputFilter.readFully(this.cImg.imageBytes);
        }
    }
}

