/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.PICT;

import imager.imagefileio.PICT.DataCompression;
import imager.imagefileio.PICT.VectorImageProducer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class PICTReader
extends VectorImageProducer {
    Image img;
    public static final int SRC_COPY = 0;
    public static final int SRC_OR = 1;
    public static final int SRC_XOR = 2;
    public static final int SRC_BIC = 3;
    public static final int NOT_SRC_COPY = 4;
    public static final int NOT_SRC_OR = 5;
    public static final int NOT_SRC_XOR = 6;
    public static final int NOT_SRC_BIC = 7;
    public static final int BLEND = 32;
    public static final int ADD_PIN = 33;
    public static final int ADD_OVER = 34;
    public static final int SUB_PIN = 35;
    public static final int TRANSPARENT = 36;
    public static final int AD_MAX = 37;
    public static final int SUB_OVER = 38;
    public static final int AD_MIN = 39;
    public static final int GRAYISH_TEXT_OR = 49;
    public static final int MASK = 64;
    public static final int TX_BOLD_MASK = 1;
    public static final int TX_ITALIC_MASK = 2;
    public static final int TX_UNDERLINE_MASK = 4;
    public static final int TX_OUTLINE_MASK = 8;
    public static final int TX_SHADOWED_MASK = 16;
    public static final int TX_CONDENSED_MASK = 32;
    public static final int TX_EXTENDED_MASK = 64;
    public static final byte[] OP_HEADER_OP;
    public static final int NOP = 0;
    public static final int OP_CLIP_RGN = 1;
    public static final int OP_BK_PAT = 2;
    public static final int OP_TX_FONT = 3;
    public static final int OP_TX_FACE = 4;
    public static final int OP_TX_MODE = 5;
    public static final int OP_SP_EXTRA = 6;
    public static final int OP_PN_SIZE = 7;
    public static final int OP_PN_MODE = 8;
    public static final int OP_PN_PAT = 9;
    public static final int OP_FILL_PAT = 10;
    public static final int OP_OV_SIZE = 11;
    public static final int OP_ORIGIN = 12;
    public static final int OP_TX_SIZE = 13;
    public static final int OP_FG_COLOR = 14;
    public static final int OP_BK_COLOR = 15;
    public static final int OP_TX_RATIO = 16;
    public static final int OP_VERSION = 17;
    public static final int OP_BK_PIX_PAT = 18;
    public static final int OP_PN_PIX_PAT = 19;
    public static final int OP_FILL_PIX_PAT = 20;
    public static final int OP_PN_LOC_H_FRAC = 21;
    public static final int OP_CH_EXTRA = 22;
    public static final int OP_RGB_FG_COL = 26;
    public static final int OP_RGB_BK_COL = 27;
    public static final int OP_HILITE_MODE = 28;
    public static final int OP_HILITE_COLOR = 29;
    public static final int OP_DEF_HILITE = 30;
    public static final int OP_OP_COLOR = 31;
    public static final int OP_LINE = 32;
    public static final int OP_LINE_FROM = 33;
    public static final int OP_SHORT_LINE = 34;
    public static final int OP_SHORT_LINE_FROM = 35;
    public static final int OP_LONG_TEXT = 40;
    public static final int OP_DH_TEXT = 41;
    public static final int OP_DV_TEXT = 42;
    public static final int OP_DHDV_TEXT = 43;
    public static final int OP_FONT_NAME = 44;
    public static final int OP_LINE_JUSTIFY = 45;
    public static final int OP_GLYPH_STATE = 46;
    public static final int OP_FRAME_RECT = 48;
    public static final int OP_PAINT_RECT = 49;
    public static final int OP_ERASE_RECT = 50;
    public static final int OP_INVERT_RECT = 51;
    public static final int OP_FILL_RECT = 52;
    public static final int OP_FRAME_SAME_RECT = 56;
    public static final int OP_PAINT_SAME_RECT = 57;
    public static final int OP_ERASE_SAME_RECT = 58;
    public static final int OP_INVERT_SAME_RECT = 59;
    public static final int OP_FILL_SAME_RECT = 60;
    public static final int OP_FRAME_R_RECT = 64;
    public static final int OP_PAINT_R_RECT = 65;
    public static final int OP_ERASE_R_RECT = 66;
    public static final int OP_INVERT_R_RECT = 67;
    public static final int OP_FILL_R_RECT = 68;
    public static final int OP_FRAME_SAME_R_RECT = 72;
    public static final int OP_PAINT_SAME_R_RECT = 73;
    public static final int OP_ERASE_SAME_R_RECT = 74;
    public static final int OP_INVERT_SAME_R_RECT = 75;
    public static final int OP_FILL_SAME_R_RECT = 76;
    public static final int OP_FRAME_OVAL = 80;
    public static final int OP_PAINT_OVAL = 81;
    public static final int OP_ERASE_OVAL = 82;
    public static final int OP_INVERT_OVAL = 83;
    public static final int OP_FILL_OVAL = 84;
    public static final int OP_FRAME_SAME_OVAL = 88;
    public static final int OP_PAINT_SAME_OVAL = 89;
    public static final int OP_ERASE_SAME_OVAL = 90;
    public static final int OP_INVERT_SAME_OVAL = 91;
    public static final int OP_FILL_SAME_OVAL = 92;
    public static final int OP_FRAME_ARC = 96;
    public static final int OP_PAINT_ARC = 97;
    public static final int OP_ERASE_ARC = 98;
    public static final int OP_INVERT_ARC = 99;
    public static final int OP_FILL_ARC = 100;
    public static final int OP_FRAME_SAME_ARC = 104;
    public static final int OP_PAINT_SAME_ARC = 105;
    public static final int OP_ERASE_SAME_ARC = 106;
    public static final int OP_INVERT_SAME_ARC = 107;
    public static final int OP_FILL_SAME_ARC = 108;
    public static final int OP_FRAME_POLY = 112;
    public static final int OP_PAINT_POLY = 113;
    public static final int OP_ERASE_POLY = 114;
    public static final int OP_INVERT_POLY = 115;
    public static final int OP_FILL_POLY = 116;
    public static final int OP_FRAME_SAME_POLY = 120;
    public static final int OP_PAINT_SAME_POLY = 121;
    public static final int OP_ERASE_SAME_POLY = 122;
    public static final int OP_INVERT_SAME_POLY = 123;
    public static final int OP_FILL_SAME_POLY = 124;
    public static final int OP_FRAME_RGN = 128;
    public static final int OP_PAINT_RGN = 129;
    public static final int OP_ERASE_RGN = 130;
    public static final int OP_INVERT_RGN = 131;
    public static final int OP_FILL_RGN = 132;
    public static final int OP_FRAME_SAME_RGN = 136;
    public static final int OP_PAINT_SAME_RGN = 137;
    public static final int OP_ERASE_SAME_RGN = 138;
    public static final int OP_INVERT_SAME_RGN = 139;
    public static final int OP_FILL_SAME_RGN = 140;
    public static final int OP_BITS_RECT = 144;
    public static final int OP_BITS_RGN = 145;
    public static final int OP_PACK_BITS_RECT = 152;
    public static final int OP_PACK_BITS_RGN = 153;
    public static final int OP_DIRECT_BITS_RECT = 154;
    public static final int OP_DIRECT_BITS_RGN = 155;
    public static final int OP_SHORT_COMMENT = 160;
    public static final int OP_LONG_COMMENT = 161;
    public static final int OP_END_OF_PICTURE = 255;
    public static final int OP_VERSION_2 = 767;
    public static final int OP_COMPRESSED_QUICKTIME = 33280;
    public static final int OP_UNCOMPRESSED_QUICKTIME = 33281;
    private final boolean UUU_OBLIGATORY_REGISTRATION = false;
    private static final int uuu_PICT_NULL_HEADER_SIZE = 512;
    private static final int uuV_NBR_BYTES_IN_WORD = 2;
    private static final int uuU_NBR_BYTES_IN_LONG = 4;
    private static final int uVv_MIN_REGION_SIZE = 10;
    private static final int uVu_MIN_POLY_SIZE = 10;
    private static final int uVV_NBR_BYTES_PICT_COLOR_COMP = 2;
    private String uVU_APPLE_USE_RESERVED_FIELD_STR = "Reserved for Apple use.";
    private File uUv_pictureFile;
    private FileInputStream uUu_pictureFIS;
    private BufferedInputStream uUV_pictureBIS;
    private Graphics uUU_drawGraphics;
    private Component Vvv_drawComponent;
    private boolean Vvu_verbose = false;
    private int VvV_picSize;
    private Rectangle VvU_pictFrame;
    private int Vuv_version;
    private boolean Vuu_isExtendedVersion2;
    private Point VuV_penPosition = new Point(0, 0);
    private Rectangle VuU_lastRectangle = new Rectangle(0, 0);
    private double VVv_screenImageXRatio;
    private double VVu_screenImageYRatio;
    private Color fgColor = Color.black;
    private Color bgColor = Color.white;
    private Color VVV_hiliteColor = Color.red;
    private Vector VVU_imgVector;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 12;
        OP_HEADER_OP = byArray;
    }

    public int getWidth() {
        if (this.VvU_pictFrame == null) {
            this.VUv_getPICTFrame();
        }
        return this.VvU_pictFrame.width;
    }

    public int getHeight() {
        if (this.VvU_pictFrame == null) {
            this.VUv_getPICTFrame();
        }
        return this.VvU_pictFrame.height;
    }

    public void playIt(Graphics graphics, Component component) {
        this.uUU_drawGraphics = graphics;
        this.Vvv_drawComponent = component;
        this.readPICTFile();
    }

    public Image getImage() {
        if (this.readPICTFile()) {
            return this.img;
        }
        return null;
    }

    public int checkImage() {
        return 32;
    }

    public void setImageFile(String string) {
        this.uUv_pictureFile = new File(string);
        this.VvU_pictFrame = null;
    }

    public void setVerbose(boolean bl) {
        this.Vvu_verbose = bl;
    }

    public boolean isVerbose(boolean bl) {
        return this.Vvu_verbose;
    }

    public boolean readPICTFile() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[8];
        if (!this.VUu_getInputStreams()) {
            return false;
        }
        if (!this.VUV_readPICTHeader(this.uUV_pictureBIS)) {
            if (this.Vvu_verbose) {
                System.out.println("Error parsing file!");
            }
            this.VUU_closeInputStreams();
            return false;
        }
        if (!this.Uvv_readPICTopcodes(this.uUV_pictureBIS)) {
            this.VUU_closeInputStreams();
            if (this.Vvu_verbose) {
                System.out.println("Error parsing file!");
            }
            return false;
        }
        this.VUU_closeInputStreams();
        if (this.Vvu_verbose) {
            System.out.println("Finished reading file!");
        }
        return true;
    }

    private boolean VUv_getPICTFrame() {
        if (!this.VUu_getInputStreams()) {
            return false;
        }
        if (!this.VUV_readPICTHeader(this.uUV_pictureBIS)) {
            if (this.Vvu_verbose) {
                System.out.println("Error parsing file!");
            }
            this.VUU_closeInputStreams();
            return false;
        }
        this.VUU_closeInputStreams();
        return true;
    }

    private boolean VUu_getInputStreams() {
        if (this.uUv_pictureFile == null || !this.uUv_pictureFile.exists()) {
            return false;
        }
        try {
            this.uUu_pictureFIS = new FileInputStream(this.uUv_pictureFile);
            this.uUV_pictureBIS = new BufferedInputStream(this.uUu_pictureFIS);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void VUU_closeInputStreams() {
        try {
            if (this.uUV_pictureBIS != null) {
                this.uUV_pictureBIS.close();
            }
            if (this.uUu_pictureFIS != null) {
                this.uUu_pictureFIS.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean VUV_readPICTHeader(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[8];
        if (bufferedInputStream == null) {
            return false;
        }
        try {
            this.Uvu_fillByteBuf(bufferedInputStream, new byte[512], 0, 512);
            this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            this.VvV_picSize = this.UvV_getBytesAsInt(byArray2, 0, byArray2.length);
            if (this.Vvu_verbose) {
                System.out.println("picSize: " + this.VvV_picSize);
            }
            this.Uvu_fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
            this.VvU_pictFrame = new Rectangle(this.UvV_getBytesAsInt(byArray3, 2, 4), this.UvV_getBytesAsInt(byArray3, 0, 2), this.UvV_getBytesAsInt(byArray3, 6, 8), this.UvV_getBytesAsInt(byArray3, 4, 6));
            if (this.Vvu_verbose) {
                System.out.println("pictFrame: " + this.VvU_pictFrame);
            }
            int n = 72;
            this.VVv_screenImageXRatio = 1.0;
            this.VVu_screenImageYRatio = 1.0;
            this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            if (byArray2[0] == 17 && byArray2[1] == 1) {
                this.Vuv_version = 1;
            } else {
                if (byArray2[0] != 0 || byArray2[1] != 17) return false;
                this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
                if (byArray2[0] != 2 || byArray2[1] != -1) return false;
                this.Vuv_version = 2;
                this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
                if (byArray2[0] != OP_HEADER_OP[0] || byArray2[1] != OP_HEADER_OP[1]) {
                    return false;
                }
                byte[] byArray4 = new byte[24];
                this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                if (byArray4[1] == -2) {
                    this.Vuu_isExtendedVersion2 = true;
                    int n2 = this.UvV_getBytesAsInt(byArray4, 4, 6);
                    int n3 = this.UvV_getBytesAsInt(byArray4, 8, 10);
                    this.VVv_screenImageXRatio = (double)n / (double)n2;
                    this.VVu_screenImageYRatio = (double)n / (double)n3;
                    if (this.Vvu_verbose) {
                        System.out.println("xResolution: " + n2);
                    }
                    if (this.Vvu_verbose) {
                        System.out.println("yResolution: " + n3);
                    }
                    if (this.Vvu_verbose) {
                        System.out.println("screenImageXRatio: " + this.VVv_screenImageXRatio);
                    }
                    if (this.Vvu_verbose) {
                        System.out.println("screenImageYRatio: " + this.VVu_screenImageYRatio);
                    }
                }
            }
            if (this.Vvu_verbose) {
                System.out.println("Version: " + this.Vuv_version);
            }
            if (!this.Vvu_verbose) return true;
            System.out.println("isExtendedVersion2: " + this.Vuu_isExtendedVersion2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean Uvv_readPICTopcodes(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[8];
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[6];
        Point point = new Point();
        Point point2 = new Point();
        Point point3 = new Point();
        long l = 0L;
        Rectangle rectangle = new Rectangle();
        Polygon polygon = new Polygon();
        Polygon polygon2 = new Polygon();
        Font font = null;
        int n = 0;
        if (this.uUU_drawGraphics != null) {
            font = this.uUU_drawGraphics.getFont();
        }
        try {
            int n2;
            block115: do {
                if (this.Vuv_version == 1) {
                    this.Uvu_fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
                    ++l;
                    n2 = this.UvV_getBytesAsInt(byArray, 0, byArray.length);
                } else {
                    if ((l & 1L) > 0L) {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray3, 0, 1);
                        ++l;
                    }
                    this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
                    l += 2L;
                    n2 = this.UvV_getBytesAsInt(byArray2, 0, byArray2.length);
                }
                switch (n2) {
                    case 0: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.print("NOP");
                        break;
                    }
                    case 1: {
                        polygon2 = this.UvU_readRegion(bufferedInputStream, rectangle);
                        if (polygon2 == null) {
                            return false;
                        }
                        if (this.uUU_drawGraphics != null && polygon2.npoints == 0) {
                            this.uUU_drawGraphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (!this.Vvu_verbose) continue block115;
                        this.Uuv_verboseRegionCmd("clipRgn", rectangle, polygon2);
                        break;
                    }
                    case 2: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("bkPat");
                        break;
                    }
                    case 3: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("txFont");
                        break;
                    }
                    case 4: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                        l += (long)byArray3.length;
                        if (this.uUU_drawGraphics != null) {
                            font = this.uUU_drawGraphics.getFont();
                            int n3 = 0;
                            if ((byArray3[0] & 1) > 0) {
                                n3 |= 1;
                            }
                            if ((byArray3[0] & 2) > 0) {
                                n3 |= 2;
                            }
                            this.uUU_drawGraphics.setFont(new Font(font.getName(), n3, font.getSize()));
                        }
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("txFace: " + byArray3[0]);
                        break;
                    }
                    case 5: {
                        byte[] byArray9 = new byte[2];
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray9, 0, byArray9.length);
                        l += (long)byArray9.length;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("txMode: " + byArray9[0] + ", " + byArray9[1]);
                        break;
                    }
                    case 6: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[4], 0, 4);
                        l += 4L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("spExtra");
                        break;
                    }
                    case 7: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        Point point4 = new Point(this.UvV_getBytesAsInt(byArray5, 0, 2), this.UvV_getBytesAsInt(byArray5, 2, 4));
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("pnsize: " + point4);
                        break;
                    }
                    case 8: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("pnMode");
                        break;
                    }
                    case 9: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("pnPat");
                        break;
                    }
                    case 10: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("fillPat");
                        break;
                    }
                    case 11: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        this.Uuu_setPointFromBuf(byArray5, point);
                        point.x *= 2;
                        point.y *= 2;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("ovSize: " + point);
                        break;
                    }
                    case 12: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        Point point5 = new Point(this.UuV_getXPtCoord(this.UvV_getBytesAsInt(byArray5, 2, 4)), this.UuU_getYPtCoord(this.UvV_getBytesAsInt(byArray5, 0, 2)));
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.translate(point5.x, point5.y);
                        }
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("Origin: " + point5);
                        break;
                    }
                    case 13: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n4 = this.UuU_getYPtCoord(this.UvV_getBytesAsInt(byArray4, 0, byArray4.length));
                        if (this.uUU_drawGraphics != null) {
                            font = this.uUU_drawGraphics.getFont();
                            this.uUU_drawGraphics.setFont(new Font(font.getName(), font.getStyle(), n4));
                        }
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("txSize: " + n4);
                        break;
                    }
                    case 14: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("fgColor");
                        break;
                    }
                    case 15: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("bgColor");
                        break;
                    }
                    case 16: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("txRatio");
                        break;
                    }
                    case 17: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[1], 0, 1);
                        ++l;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opVersion");
                        break;
                    }
                    case 21: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opPnLocHFrac");
                        break;
                    }
                    case 22: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        l += 2L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opChExtra");
                        break;
                    }
                    case 26: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        this.fgColor = new Color(byArray8[0] & 0xFF, byArray8[2] & 0xFF, byArray8[4] & 0xFF);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.setColor(this.fgColor);
                        }
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("rgbFgColor: " + this.fgColor);
                        break;
                    }
                    case 27: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        this.bgColor = new Color(byArray8[0] & 0xFF, byArray8[2] & 0xFF, byArray8[4] & 0xFF);
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("rgbBgColor: " + this.bgColor);
                        break;
                    }
                    case 28: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opHiliteMode");
                        break;
                    }
                    case 29: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        this.VVV_hiliteColor = new Color(byArray8[0] & 0xFF, byArray8[2] & 0xFF, byArray8[4] & 0xFF);
                        if (this.Vvu_verbose) {
                            System.out.println("opHiliteColor: " + this.VVV_hiliteColor);
                        }
                        l += (long)byArray8.length;
                        break;
                    }
                    case 30: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opDefHilite");
                        break;
                    }
                    case 31: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray8, 0, byArray8.length);
                        l += (long)byArray8.length;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opOpColor");
                        break;
                    }
                    case 32: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        Point point5 = new Point();
                        this.Uuu_setPointFromBuf(byArray5, point5);
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        this.Uuu_setPointFromBuf(byArray5, this.VuV_penPosition);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawLine(point5.x, point5.y, this.VuV_penPosition.x, this.VuV_penPosition.y);
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("line from: " + point5 + " to: " + this.VuV_penPosition);
                        }
                        l += (long)(2 * byArray5.length);
                        break;
                    }
                    case 33: {
                        Point point5 = new Point(this.VuV_penPosition);
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        this.Uuu_setPointFromBuf(byArray5, this.VuV_penPosition);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawLine(point5.x, point5.y, this.VuV_penPosition.x, this.VuV_penPosition.y);
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("lineFrom to: " + this.VuV_penPosition);
                        }
                        l += (long)byArray5.length;
                        break;
                    }
                    case 34: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        Point point5 = new Point();
                        this.Uuu_setPointFromBuf(byArray5, point5);
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        Point point6 = new Point(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray4, 0, 1)), this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray4, 1, 2)));
                        this.VuV_penPosition.setLocation(point5.x + point6.x, point5.y + point6.y);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawLine(point5.x, point5.y, this.VuV_penPosition.x, this.VuV_penPosition.y);
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("Short line origin: " + point5 + ", dh,dv: " + point6);
                        }
                        l += (long)(byArray5.length + byArray4.length);
                        break;
                    }
                    case 35: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        Point point6 = new Point(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray4, 0, 1)), this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray4, 1, 2)));
                        point2.setLocation(this.VuV_penPosition.x + point6.x, this.VuV_penPosition.y + point6.y);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawLine(this.VuV_penPosition.x, this.VuV_penPosition.y, point2.x, point2.y);
                        }
                        this.VuV_penPosition.setLocation(point2);
                        if (this.Vvu_verbose) {
                            System.out.println("Short line from dh,dv: " + point6);
                        }
                        l += (long)byArray4.length;
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 40: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        Point point5 = new Point();
                        this.Uuu_setPointFromBuf(byArray5, point5);
                        this.VuV_penPosition = point5;
                        String string = this.UVu_readText(bufferedInputStream);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawString(string, this.VuV_penPosition.x, this.VuV_penPosition.y);
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("longText origin: " + this.VuV_penPosition + ", text:" + string);
                        }
                        l += (long)(5 + string.length());
                        break;
                    }
                    case 41: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                        int n6 = this.UuV_getXPtCoord(byArray3[0]);
                        this.VuV_penPosition.translate(n6, 0);
                        String string = this.UVu_readText(bufferedInputStream);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawString(string, this.VuV_penPosition.x, this.VuV_penPosition.y);
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("DHText dh: " + n6 + ", text:" + string);
                        }
                        l += (long)(byArray3.length + 1 + string.length());
                        break;
                    }
                    case 42: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                        int n7 = this.UuU_getYPtCoord(byArray3[0]);
                        this.VuV_penPosition.translate(0, n7);
                        String string = this.UVu_readText(bufferedInputStream);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawString(string, this.VuV_penPosition.x, this.VuV_penPosition.y);
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("DVText dv: " + n7 + ", text:" + string);
                        }
                        l += (long)(byArray3.length + 1 + string.length());
                        break;
                    }
                    case 43: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        this.VuV_penPosition.translate(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray4, 0, 1)), this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray4, 1, 2)));
                        String string = this.UVu_readText(bufferedInputStream);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.drawString(string, this.VuV_penPosition.x, this.VuV_penPosition.y);
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("DHDVText penPosition: " + this.VuV_penPosition + ", text:" + string);
                        }
                        l += (long)(byArray4.length + 1 + string.length());
                        break;
                    }
                    case 44: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        int n5 = this.UvV_getBytesAsInt(byArray4, 0, 2);
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        String string = this.UVu_readText(bufferedInputStream);
                        if (this.uUU_drawGraphics != null) {
                            this.uUU_drawGraphics.setFont(new Font(Font.decode(string).getName(), font.getStyle(), font.getSize()));
                        }
                        if (this.Vvu_verbose) {
                            System.out.println("fontName: " + string);
                        }
                        l += (long)(5 + string.length());
                        break;
                    }
                    case 45: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[10], 0, 10);
                        if (this.Vvu_verbose) {
                            System.out.println("opLineJustify");
                        }
                        l += 10L;
                        break;
                    }
                    case 46: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[6], 0, 6);
                        if (this.Vvu_verbose) {
                            System.out.println("glyphState");
                        }
                        l += 6L;
                        break;
                    }
                    case 47: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.UVV_setRectFromBuf(byArray6, this.VuU_lastRectangle);
                    }
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: {
                        if (this.uUU_drawGraphics != null) {
                            switch (n2) {
                                case 48: 
                                case 56: {
                                    this.uUU_drawGraphics.drawRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    break;
                                }
                                case 49: 
                                case 57: {
                                    this.uUU_drawGraphics.fillRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    break;
                                }
                                case 50: 
                                case 58: {
                                    this.uUU_drawGraphics.setColor(this.bgColor);
                                    this.uUU_drawGraphics.fillRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    this.uUU_drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 51: 
                                case 59: {
                                    this.uUU_drawGraphics.setXORMode(this.bgColor);
                                    this.uUU_drawGraphics.fillRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    this.uUU_drawGraphics.setPaintMode();
                                    break;
                                }
                                case 52: 
                                case 60: {
                                    this.uUU_drawGraphics.fillRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                }
                            }
                        }
                        if (this.Vvu_verbose && n2 == 48) {
                            System.out.println("frameRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 49) {
                            System.out.println("paintRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 50) {
                            System.out.println("eraseRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 51) {
                            System.out.println("invertRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 52) {
                            System.out.println("fillRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 56) {
                            System.out.println("frameSameRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 57) {
                            System.out.println("paintSameRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 58) {
                            System.out.println("eraseSameRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 59) {
                            System.out.println("invertSameRect: " + this.VuU_lastRectangle);
                        }
                        if (!this.Vvu_verbose || n2 != 60) continue block115;
                        System.out.println("fillSameRect: " + this.VuU_lastRectangle);
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.UVV_setRectFromBuf(byArray6, this.VuU_lastRectangle);
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: {
                        if (this.uUU_drawGraphics != null) {
                            switch (n2) {
                                case 64: 
                                case 72: {
                                    this.uUU_drawGraphics.drawRoundRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point.x, point.y);
                                    break;
                                }
                                case 65: 
                                case 73: {
                                    this.uUU_drawGraphics.fillRoundRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point.x, point.y);
                                    break;
                                }
                                case 66: 
                                case 74: {
                                    this.uUU_drawGraphics.setColor(this.bgColor);
                                    this.uUU_drawGraphics.fillRoundRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point.x, point.y);
                                    this.uUU_drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 67: 
                                case 75: {
                                    this.uUU_drawGraphics.setXORMode(this.bgColor);
                                    this.uUU_drawGraphics.fillRoundRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point.x, point.y);
                                    this.uUU_drawGraphics.setPaintMode();
                                    break;
                                }
                                case 68: 
                                case 76: {
                                    this.uUU_drawGraphics.fillRoundRect(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point.x, point.y);
                                }
                            }
                        }
                        if (this.Vvu_verbose && n2 == 64) {
                            System.out.println("frameRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 65) {
                            System.out.println("paintRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 66) {
                            System.out.println("eraseRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 67) {
                            System.out.println("invertRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 68) {
                            System.out.println("fillRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 72) {
                            System.out.println("frameSameRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 73) {
                            System.out.println("paintSameRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 74) {
                            System.out.println("eraseSameRRect: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 75) {
                            System.out.println("invertSameRRect: " + this.VuU_lastRectangle);
                        }
                        if (!this.Vvu_verbose || n2 != 76) continue block115;
                        System.out.println("fillSameRRect: " + this.VuU_lastRectangle);
                        break;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.UVV_setRectFromBuf(byArray6, this.VuU_lastRectangle);
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: {
                        if (this.uUU_drawGraphics != null) {
                            switch (n2) {
                                case 80: 
                                case 88: {
                                    this.uUU_drawGraphics.drawOval(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    break;
                                }
                                case 81: 
                                case 89: {
                                    this.uUU_drawGraphics.fillOval(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    break;
                                }
                                case 82: 
                                case 90: {
                                    this.uUU_drawGraphics.setColor(this.bgColor);
                                    this.uUU_drawGraphics.fillOval(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    this.uUU_drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 83: 
                                case 91: {
                                    this.uUU_drawGraphics.setXORMode(this.bgColor);
                                    this.uUU_drawGraphics.fillOval(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                    this.uUU_drawGraphics.setPaintMode();
                                    break;
                                }
                                case 84: 
                                case 92: {
                                    this.uUU_drawGraphics.fillOval(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height);
                                }
                            }
                        }
                        if (this.Vvu_verbose && n2 == 80) {
                            System.out.println("frameOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 81) {
                            System.out.println("paintOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 82) {
                            System.out.println("eraseOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 83) {
                            System.out.println("invertOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 84) {
                            System.out.println("fillOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 88) {
                            System.out.println("frameSameOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 89) {
                            System.out.println("paintSameOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 90) {
                            System.out.println("eraseSameOval: " + this.VuU_lastRectangle);
                        }
                        if (this.Vvu_verbose && n2 == 91) {
                            System.out.println("invertSameOval: " + this.VuU_lastRectangle);
                        }
                        if (!this.Vvu_verbose || n2 != 92) continue block115;
                        System.out.println("fillSameOval: " + this.VuU_lastRectangle);
                        break;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 85: 
                    case 86: 
                    case 87: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[8], 0, 8);
                        l += 8L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.UVV_setRectFromBuf(byArray6, this.VuU_lastRectangle);
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray5, 0, byArray5.length);
                        l += (long)byArray5.length;
                        this.Uuu_setPointFromBuf(byArray5, point3);
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        if (this.uUU_drawGraphics != null) {
                            switch (n2) {
                                case 96: 
                                case 104: {
                                    this.uUU_drawGraphics.drawArc(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point3.x, point3.y);
                                    break;
                                }
                                case 97: 
                                case 105: {
                                    this.uUU_drawGraphics.fillArc(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point3.x, point3.y);
                                    break;
                                }
                                case 98: 
                                case 106: {
                                    this.uUU_drawGraphics.setColor(this.bgColor);
                                    this.uUU_drawGraphics.fillArc(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point3.x, point3.y);
                                    this.uUU_drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 99: 
                                case 107: {
                                    this.uUU_drawGraphics.setXORMode(this.bgColor);
                                    this.uUU_drawGraphics.fillArc(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point3.x, point3.y);
                                    this.uUU_drawGraphics.setPaintMode();
                                    break;
                                }
                                case 100: 
                                case 108: {
                                    this.uUU_drawGraphics.fillArc(this.VuU_lastRectangle.x, this.VuU_lastRectangle.y, this.VuU_lastRectangle.width, this.VuU_lastRectangle.height, point3.x, point3.y);
                                }
                            }
                        }
                        if (this.Vvu_verbose && n2 == 96) {
                            System.out.println("frameArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 97) {
                            System.out.println("paintArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 98) {
                            System.out.println("eraseArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 99) {
                            System.out.println("invertArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 100) {
                            System.out.println("fillArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 104) {
                            System.out.println("frameSameArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 105) {
                            System.out.println("paintSameArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 106) {
                            System.out.println("eraseSameArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (this.Vvu_verbose && n2 == 107) {
                            System.out.println("invertSameArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        }
                        if (!this.Vvu_verbose || n2 != 108) continue block115;
                        System.out.println("fillSameArc: " + this.VuU_lastRectangle + ", angles:" + point3);
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 103: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[12], 0, 12);
                        l += 12L;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: {
                        polygon = this.UVU_readPoly(bufferedInputStream, rectangle);
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: {
                        if (this.uUU_drawGraphics != null && polygon != null && polygon.npoints > 1) {
                            switch (n2) {
                                case 112: 
                                case 120: {
                                    if (polygon.xpoints[0] == polygon.xpoints[polygon.npoints - 1] && polygon.ypoints[0] == polygon.ypoints[polygon.npoints - 1]) {
                                        this.uUU_drawGraphics.drawPolygon(polygon);
                                        break;
                                    }
                                    this.uUU_drawGraphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
                                    break;
                                }
                                case 113: 
                                case 121: {
                                    this.uUU_drawGraphics.fillPolygon(polygon);
                                    break;
                                }
                                case 114: 
                                case 122: {
                                    this.uUU_drawGraphics.setColor(this.bgColor);
                                    this.uUU_drawGraphics.fillPolygon(polygon);
                                    this.uUU_drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 115: 
                                case 123: {
                                    this.uUU_drawGraphics.setXORMode(this.bgColor);
                                    this.uUU_drawGraphics.fillPolygon(polygon);
                                    this.uUU_drawGraphics.setPaintMode();
                                    break;
                                }
                                case 116: 
                                case 124: {
                                    this.uUU_drawGraphics.fillPolygon(polygon);
                                }
                            }
                        }
                        if (this.Vvu_verbose && n2 == 112) {
                            this.UUv_verbosePolyCmd("framePoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 113) {
                            this.UUv_verbosePolyCmd("paintPoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 114) {
                            this.UUv_verbosePolyCmd("erasePoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 115) {
                            this.UUv_verbosePolyCmd("invertPoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 116) {
                            this.UUv_verbosePolyCmd("fillPoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 120) {
                            this.UUv_verbosePolyCmd("frameSamePoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 121) {
                            this.UUv_verbosePolyCmd("paintSamePoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 122) {
                            this.UUv_verbosePolyCmd("eraseSamePoly", rectangle, polygon);
                        }
                        if (this.Vvu_verbose && n2 == 123) {
                            this.UUv_verbosePolyCmd("invertSamePoly", rectangle, polygon);
                        }
                        if (!this.Vvu_verbose || n2 != 124) continue block115;
                        this.UUv_verbosePolyCmd("fillSamePoly", rectangle, polygon);
                        break;
                    }
                    case 117: 
                    case 118: 
                    case 119: {
                        polygon = this.UVU_readPoly(bufferedInputStream, rectangle);
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: {
                        polygon2 = this.UvU_readRegion(bufferedInputStream, rectangle);
                    }
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: {
                        if (this.uUU_drawGraphics != null && polygon2 != null && polygon2.npoints > 1) {
                            switch (n2) {
                                case 128: 
                                case 136: {
                                    this.uUU_drawGraphics.drawPolygon(polygon2);
                                    break;
                                }
                                case 129: 
                                case 137: {
                                    this.uUU_drawGraphics.fillPolygon(polygon2);
                                    break;
                                }
                                case 130: 
                                case 138: {
                                    this.uUU_drawGraphics.setColor(this.bgColor);
                                    this.uUU_drawGraphics.fillPolygon(polygon2);
                                    this.uUU_drawGraphics.setColor(this.fgColor);
                                    break;
                                }
                                case 131: 
                                case 139: {
                                    this.uUU_drawGraphics.setXORMode(this.bgColor);
                                    this.uUU_drawGraphics.fillPolygon(polygon2);
                                    this.uUU_drawGraphics.setPaintMode();
                                    break;
                                }
                                case 132: 
                                case 140: {
                                    this.uUU_drawGraphics.fillPolygon(polygon2);
                                }
                            }
                        }
                        if (this.Vvu_verbose && n2 == 128) {
                            this.Uuv_verboseRegionCmd("frameRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 129) {
                            this.Uuv_verboseRegionCmd("paintRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 130) {
                            this.Uuv_verboseRegionCmd("eraseRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 131) {
                            this.Uuv_verboseRegionCmd("invertRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 132) {
                            this.Uuv_verboseRegionCmd("fillRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 136) {
                            this.Uuv_verboseRegionCmd("frameSameRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 137) {
                            this.Uuv_verboseRegionCmd("paintSameRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 138) {
                            this.Uuv_verboseRegionCmd("eraseSameRgn", rectangle, polygon2);
                        }
                        if (this.Vvu_verbose && n2 == 139) {
                            this.Uuv_verboseRegionCmd("invertSameRgn", rectangle, polygon2);
                        }
                        if (!this.Vvu_verbose || n2 != 140) continue block115;
                        this.Uuv_verboseRegionCmd("fillSameRgn", rectangle, polygon2);
                        break;
                    }
                    case 133: 
                    case 134: 
                    case 135: {
                        polygon2 = this.UvU_readRegion(bufferedInputStream, rectangle);
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 144: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opBitsRect");
                        break;
                    }
                    case 145: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opBitsRgn");
                        break;
                    }
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 152: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opPackBitsRect");
                        break;
                    }
                    case 153: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opPackBitsRgn");
                        break;
                    }
                    case 154: {
                        if (this.Vvu_verbose) {
                            System.out.println("opDirectBitsRect");
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[4], 0, 4);
                        l += 4L;
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n8 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length) & 0x3FFF;
                        if (this.Vvu_verbose) {
                            System.out.print("opDirectBitsRect, rowBytes: " + n8);
                            if ((byArray4[0] & 0x80) > 0) {
                                System.out.print(", it is a PixMap");
                            } else {
                                System.out.print(", it is a BitMap");
                            }
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        rectangle.setLocation(this.UvV_getBytesAsInt(byArray6, 2, 4), this.UvV_getBytesAsInt(byArray6, 0, 2));
                        rectangle.setSize(this.UvV_getBytesAsInt(byArray6, 6, 8) - rectangle.x, this.UvV_getBytesAsInt(byArray6, 4, 6) - rectangle.y);
                        if (this.Vvu_verbose) {
                            System.out.print(", bounds: " + rectangle);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n9 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length) & 0xFFFF;
                        if (this.Vvu_verbose) {
                            System.out.print(", pmVersion: " + n9);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n10 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length) & 0xFFFF;
                        if (this.Vvu_verbose) {
                            System.out.print(", packType: " + n10);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n11 = this.UvV_getBytesAsInt(byArray7, 0, byArray7.length);
                        if (this.Vvu_verbose) {
                            System.out.println(", packSize: " + n11);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n12 = this.UvV_getBytesAsInt(byArray7, 0, 2);
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n13 = this.UvV_getBytesAsInt(byArray7, 0, 2);
                        if (this.Vvu_verbose) {
                            System.out.print("hRes: " + n12 + ", vRes: " + n13);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n14 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.Vvu_verbose) {
                            if (n14 == 0) {
                                System.out.print(", indexed pixels");
                            } else {
                                System.out.print(", RGBDirect");
                            }
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n15 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.Vvu_verbose) {
                            System.out.print(", pixelSize:" + n15);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n16 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.Vvu_verbose) {
                            System.out.print(", cmpCount:" + n16);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n17 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.Vvu_verbose) {
                            System.out.println(", cmpSize:" + n17);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        Rectangle rectangle2 = new Rectangle();
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        rectangle2.setLocation(this.UvV_getBytesAsInt(byArray6, 2, 4), this.UvV_getBytesAsInt(byArray6, 0, 2));
                        rectangle2.setSize(this.UvV_getBytesAsInt(byArray6, 6, 8) - rectangle2.x, this.UvV_getBytesAsInt(byArray6, 4, 6) - rectangle2.y);
                        if (this.Vvu_verbose) {
                            System.out.print("opDirectBitsRect, srcRect:" + rectangle2);
                        }
                        Rectangle rectangle3 = new Rectangle();
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray6, 0, byArray6.length);
                        l += (long)byArray6.length;
                        this.UVV_setRectFromBuf(byArray6, rectangle3);
                        if (this.Vvu_verbose) {
                            System.out.print(", dstRect:" + rectangle3);
                        }
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n18 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        if (this.Vvu_verbose) {
                            System.out.print(", mode: " + n18);
                        }
                        int n19 = rectangle.height * rectangle.width;
                        int[] nArray = new int[n19];
                        int n20 = 0;
                        byte[] byArray10 = new byte[3 * rectangle.width];
                        int n21 = 0;
                        while (n21 < rectangle.height) {
                            int n22;
                            if (n8 > 250) {
                                this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                                l += (long)byArray4.length;
                                n22 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                            } else {
                                this.Uvu_fillByteBuf(bufferedInputStream, byArray3, 0, byArray3.length);
                                l += (long)byArray3.length;
                                n22 = this.UvV_getBytesAsInt(byArray3, 0, byArray3.length);
                            }
                            if (this.Vvu_verbose) {
                                System.out.println();
                                System.out.print("Line " + n21 + ", byteCount: " + n22);
                            }
                            byte[] byArray11 = new byte[n22];
                            this.Uvu_fillByteBuf(bufferedInputStream, byArray11, 0, byArray11.length);
                            l += (long)byArray11.length;
                            int n23 = DataCompression.unPackBits(byArray11, byArray10, 0, byArray11.length);
                            int n24 = 0;
                            while (n24 < rectangle.width) {
                                nArray[n20 + n24] = -16777216;
                                ++n24;
                            }
                            n24 = 0;
                            while (n24 < rectangle.width) {
                                int n25 = n20 + n24;
                                nArray[n25] = nArray[n25] | (byArray10[n24] & 0xFF) << 16;
                                ++n24;
                            }
                            n24 = 0;
                            while (n24 < rectangle.width) {
                                int n26 = n20 + n24;
                                nArray[n26] = nArray[n26] | (byArray10[rectangle.width + n24] & 0xFF) << 8;
                                ++n24;
                            }
                            n24 = 0;
                            while (n24 < rectangle.width) {
                                int n27 = n20 + n24;
                                nArray[n27] = nArray[n27] | byArray10[2 * rectangle.width + n24] & 0xFF;
                                ++n24;
                            }
                            n20 += rectangle.width;
                            ++n21;
                        }
                        if (this.VVU_imgVector == null) {
                            this.VVU_imgVector = new Vector();
                        }
                        if (this.VVU_imgVector.size() <= n) {
                            this.img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(rectangle.width, rectangle.height, nArray, 0, rectangle.width));
                            this.VVU_imgVector.addElement(this.img);
                        }
                        this.img = (Image)this.VVU_imgVector.elementAt(n);
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println();
                        break;
                    }
                    case 155: {
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opDirectBitsRgn");
                        break;
                    }
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray4, 0, byArray4.length);
                        l += (long)byArray4.length;
                        int n5 = this.UvV_getBytesAsInt(byArray4, 0, byArray4.length);
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println(this.uVU_APPLE_USE_RESERVED_FIELD_STR);
                        break;
                    }
                    case 160: {
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[2], 0, 2);
                        if (this.Vvu_verbose) {
                            System.out.println("Short comment");
                        }
                        l += 2L;
                        break;
                    }
                    case 161: {
                        if (!this.UUu_readLongComment(bufferedInputStream)) {
                            return false;
                        }
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("Long comment");
                        break;
                    }
                    case 255: {
                        break;
                    }
                    case 33280: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n5 = this.UvV_getBytesAsInt(byArray7, 0, byArray7.length);
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opCompressedQuickTime");
                        break;
                    }
                    case 33281: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n5 = this.UvV_getBytesAsInt(byArray7, 0, byArray7.length);
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opUnCompressedQuickTime");
                        break;
                    }
                    case 65535: {
                        this.Uvu_fillByteBuf(bufferedInputStream, byArray7, 0, byArray7.length);
                        l += (long)byArray7.length;
                        int n5 = this.UvV_getBytesAsInt(byArray7, 0, byArray7.length);
                        this.Uvu_fillByteBuf(bufferedInputStream, new byte[n5], 0, n5);
                        l += (long)n5;
                        if (!this.Vvu_verbose) continue block115;
                        System.out.println("opUnCompressedQuickTime");
                        break;
                    }
                    default: {
                        System.out.println("Found unknown opcode: " + n2);
                        return false;
                    }
                }
            } while (n2 != 255);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void Uuu_setPointFromBuf(byte[] byArray, Point point) {
        point.setLocation(this.UuV_getXPtCoord(this.UvV_getBytesAsInt(byArray, 2, 4)), this.UuU_getYPtCoord(this.UvV_getBytesAsInt(byArray, 0, 2)));
    }

    private void UVV_setRectFromBuf(byte[] byArray, Rectangle rectangle) {
        int n = this.UvV_getBytesAsInt(byArray, 2, 4);
        int n2 = this.UvV_getBytesAsInt(byArray, 0, 2);
        rectangle.setLocation(this.UuV_getXPtCoord(n), this.UuU_getYPtCoord(n2));
        rectangle.setSize(this.UuV_getXPtCoord(this.UvV_getBytesAsInt(byArray, 6, 8) - n), this.UuU_getYPtCoord(this.UvV_getBytesAsInt(byArray, 4, 6) - n2));
    }

    private Polygon UvU_readRegion(BufferedInputStream bufferedInputStream, Rectangle rectangle) {
        Polygon polygon;
        byte[] byArray = new byte[10];
        try {
            this.Uvu_fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            int n = this.UvV_getBytesAsInt(byArray, 0, 2);
            int n2 = 2;
            rectangle.setLocation(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray, n2 + 2, n2 + 4)), this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray, n2, n2 + 2)));
            rectangle.setSize(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray, (n2 += 4) + 2, n2 + 4)) - rectangle.getLocation().x, this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray, n2, n2 + 2)) - rectangle.getLocation().y);
            int n3 = (n - (n2 += 4)) / 4;
            polygon = new Polygon();
            byte[] byArray2 = new byte[n3 * 2 * 2];
            this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                polygon.addPoint(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray2, n2 + 2, n2 + 4)), this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray2, n2, n2 + 2)));
                n2 += 4;
                ++n4;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return polygon;
    }

    private Polygon UVU_readPoly(BufferedInputStream bufferedInputStream, Rectangle rectangle) {
        Polygon polygon;
        byte[] byArray = new byte[10];
        try {
            this.Uvu_fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            int n = this.UvV_getBytesAsInt(byArray, 0, 2);
            int n2 = 2;
            rectangle.setLocation(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray, n2 + 2, n2 + 4)), this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray, n2, n2 + 2)));
            rectangle.setSize(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray, (n2 += 4) + 2, n2 + 4)) - rectangle.getLocation().x, this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray, n2, n2 + 2)) - rectangle.getLocation().y);
            int n3 = (n - (n2 += 4)) / 4;
            polygon = new Polygon();
            byte[] byArray2 = new byte[n3 * 2 * 2];
            this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                polygon.addPoint(this.UuV_getXPtCoord(this.UVv_bytesAsSignedInt(byArray2, n2 + 2, n2 + 4)), this.UuU_getYPtCoord(this.UVv_bytesAsSignedInt(byArray2, n2, n2 + 2)));
                n2 += 4;
                ++n4;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return polygon;
    }

    private String UVu_readText(BufferedInputStream bufferedInputStream) {
        byte[] byArray;
        byte[] byArray2 = new byte[1];
        try {
            this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            byte by = byArray2[0];
            byArray = new byte[by];
            this.Uvu_fillByteBuf(bufferedInputStream, byArray, 0, by);
        }
        catch (IOException iOException) {
            return null;
        }
        return new String(byArray);
    }

    private void UUV_readPixPat(BufferedInputStream bufferedInputStream) {
    }

    private boolean UUu_readLongComment(BufferedInputStream bufferedInputStream) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[2];
        try {
            this.Uvu_fillByteBuf(bufferedInputStream, byArray, 0, byArray.length);
            this.Uvu_fillByteBuf(bufferedInputStream, byArray2, 0, byArray2.length);
            int n = this.UvV_getBytesAsInt(byArray2, 0, byArray2.length);
            this.Uvu_fillByteBuf(bufferedInputStream, new byte[n], 0, n);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private int UuV_getXPtCoord(int n) {
        return (int)((double)n * this.VVv_screenImageXRatio);
    }

    private int UuU_getYPtCoord(int n) {
        return (int)((double)n * this.VVu_screenImageYRatio);
    }

    private int UvV_getBytesAsInt(byte[] byArray, int n, int n2) {
        int n3 = byArray[n] & 0xFF;
        int n4 = n + 1;
        while (n4 < byArray.length && n4 < n2) {
            n3 = n3 << 8 | byArray[n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    private int UVv_bytesAsSignedInt(byte[] byArray, int n, int n2) {
        boolean bl = false;
        if ((byArray[n] & 0x80) != 0) {
            bl = true;
        }
        int n3 = n;
        byArray[n3] = (byte)(byArray[n3] & 0x7F);
        int n4 = this.UvV_getBytesAsInt(byArray, n, n2);
        if (bl) {
            int n5 = (int)Math.pow(2.0, (n2 - n) * 8 - 1);
            n4 -= n5;
        }
        return n4;
    }

    private void Uvu_fillByteBuf(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        boolean bl = false;
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new IOException("Unexpected EOF");
            }
            n += n3;
            n2 -= n3;
        }
    }

    private void UUv_verbosePolyCmd(String string, Rectangle rectangle, Polygon polygon) {
        System.out.println(String.valueOf(string) + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Polygon points: ");
        int n = 0;
        while (polygon != null && n < polygon.npoints - 1) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
            ++n;
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }

    private void Uuv_verboseRegionCmd(String string, Rectangle rectangle, Polygon polygon) {
        System.out.println(String.valueOf(string) + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Region points: ");
        int n = 0;
        while (polygon != null && n < polygon.npoints - 1) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
            ++n;
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }
}

