/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.ICO;

import imager.imagefileio.ICO.ICOBitmap;
import imager.imagefileio.ICO.ICOBitmapIndexed;
import imager.imagefileio.ICO.ICOBitmapMask;
import imager.imagefileio.ICO.ICOFile;
import imager.imagefileio.ICO.ICOHeader;
import imager.imagefileio.ICO.general.FileDecoder;
import java.awt.Image;
import java.io.IOException;

public class ICOEntry {
    private ICOHeader UU_fHeader;
    private int uU_fWidth;
    private int VV_fHeight;
    private int Uu_fColorCount;
    private int uu_fReserved;
    private int Vv_fPlanes;
    private int VU_fBitCount;
    private int UV_fSize;
    private int uV_fOffset;
    private ICOBitmap Vu_fBitmap;
    private ICOBitmapMask Uv_fMask;

    public ICOEntry(FileDecoder fileDecoder) throws IOException {
        ICOFile.log(2, "Reading entry at " + fileDecoder.getPos());
        this.uU_fWidth = fileDecoder.readUInt1();
        this.VV_fHeight = fileDecoder.readUInt1();
        this.Uu_fColorCount = fileDecoder.readUInt1();
        this.uu_fReserved = fileDecoder.readUInt1();
        this.Vv_fPlanes = fileDecoder.readUInt2();
        this.VU_fBitCount = fileDecoder.readUInt2();
        this.UV_fSize = fileDecoder.readUInt4();
        this.uV_fOffset = fileDecoder.readUInt4();
        ICOFile.log(2, this.toString());
    }

    public String toString() {
        return "Entry: width: " + this.uU_fWidth + ", height: " + this.VV_fHeight + ", colorCount: " + this.Uu_fColorCount + " (" + this.getColorCount() + ")" + ", planes: " + this.Vv_fPlanes + ", bitCount: " + this.VU_fBitCount + ", size: " + this.UV_fSize + ", offset: " + this.uV_fOffset;
    }

    public Image getImageIndexed() {
        if (!(this.Vu_fBitmap instanceof ICOBitmapIndexed)) {
            return null;
        }
        ICOBitmapIndexed iCOBitmapIndexed = (ICOBitmapIndexed)this.Vu_fBitmap;
        return iCOBitmapIndexed.createImageIndexed();
    }

    public int getBitCount() {
        return this.VU_fBitCount != 0 ? this.VU_fBitCount : this.UU_fHeader.getBitCount();
    }

    public int getBitCountRaw() {
        return this.VU_fBitCount;
    }

    public Image getImageRGB() {
        return this.Vu_fBitmap.createImageRGB();
    }

    public int getColorCountRaw() {
        return this.Uu_fColorCount;
    }

    public int getColorCount() {
        return this.Uu_fColorCount == 0 ? 256 : this.Uu_fColorCount;
    }

    public int getHeight() {
        return this.VV_fHeight;
    }

    public int getOffset() {
        return this.uV_fOffset;
    }

    public int getPlanes() {
        return this.Vv_fPlanes;
    }

    public int getReserved() {
        return this.uu_fReserved;
    }

    public int getSize() {
        return this.UV_fSize;
    }

    public int getWidth() {
        return this.uU_fWidth;
    }

    public ICOHeader getHeader() {
        return this.UU_fHeader;
    }

    public void setHeader(ICOHeader iCOHeader) {
        this.UU_fHeader = iCOHeader;
    }

    public ICOBitmapMask getMask() {
        return this.Uv_fMask;
    }

    public void setMask(ICOBitmapMask iCOBitmapMask) {
        this.Uv_fMask = iCOBitmapMask;
    }

    public ICOBitmap getBitmap() {
        return this.Vu_fBitmap;
    }

    public void setBitmap(ICOBitmap iCOBitmap) {
        this.Vu_fBitmap = iCOBitmap;
    }
}

