/*
 * Decompiled with CFR 0.152.
 */
package imager.components.dialogs;

import imager.Animation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class AnimationPreviewPanel
extends JPanel
implements Runnable {
    private BufferedImage U_image;
    private Animation u_animation;
    private boolean animate = true;
    Dimension bannerSize = new Dimension(378, 78);
    int counter = 0;

    AnimationPreviewPanel() {
    }

    public void startAnimation() {
        if (this.U_image == null) {
            this.V_createImage();
        }
        this.animate = true;
        this.u_animation.reset();
        new Thread(this).start();
    }

    public void run() {
        while (this.animate && this.u_animation != null && this.U_image != null) {
            try {
                Animation animation = this.u_animation;
                synchronized (animation) {
                    Graphics graphics = this.U_image.getGraphics();
                    if (this.u_animation.isTransparent()) {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, this.U_image.getWidth(), this.U_image.getHeight());
                    }
                    this.u_animation.animate(graphics, new Rectangle(this.U_image.getWidth(), this.U_image.getHeight()));
                }
                this.repaint();
                Thread.sleep(this.u_animation.getDelay());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stopAnimate() {
        this.animate = false;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.U_image != null) {
            graphics.drawImage(this.U_image, (this.getWidth() - this.bannerSize.width) / 2, (this.getHeight() - this.bannerSize.height) / 2, this);
        }
    }

    public Animation getAnimation() {
        return this.u_animation;
    }

    public void setAnimation(Animation animation) {
        this.u_animation = animation;
    }

    public Dimension getBannerSize() {
        return this.bannerSize;
    }

    public void setBannerSize(Dimension dimension) {
        this.bannerSize = dimension;
        this.V_createImage();
    }

    public void setBannerWidth(int n) {
        this.bannerSize.width = n;
        this.V_createImage();
    }

    public void setBannerHeight(int n) {
        this.bannerSize.height = n;
        this.V_createImage();
    }

    private void V_createImage() {
        this.U_image = new BufferedImage(this.bannerSize.width, this.bannerSize.height, 2);
        this.u_animation.reset();
    }
}

