/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageHandler;
import imager.ImageScrollPane;
import imager.Imager;
import imager.ImagerGlobal;
import imager.MarkImagePanel;
import imager.Spotlight;
import imager.components.dialogs.JPhotoDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpotlightDialog
extends JPhotoDialog {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JSlider m_StrengthSlider = new JSlider();
    JLabel jLabel1 = new JLabel();
    JButton m_ColorButton = new JButton();
    JPanel m_ColorPanel = new JPanel();
    JButton m_CancelButton = new JButton();
    JButton m_OkButton = new JButton();
    int m_CenterX;
    int m_CenterY;
    Image m_Image;
    float m_ImagePreviewScale;
    Imager m_Imager;
    ImageScrollPane imageScrollPane1;
    MarkImagePanel m_MarkImagePanel;
    TitledBorder titledBorder1;
    Border border1;
    int ImagePanelWidth = 230;
    int ImagePanelHeight = 180;
    ImageHandler m_ImageHandler;
    Color m_Color = Color.white;
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton m_PreviewButton = new JButton();
    JButton m_RestoreButton = new JButton();
    JLabel jLabel2 = new JLabel();
    JSlider m_LossSlider = new JSlider();
    private JLabel U_jLabel3 = new JLabel();

    public SpotlightDialog(Imager imager) {
        super(imager, "Spotlight Dialog", true);
        try {
            this.m_Imager = imager;
            this.m_Image = imager.getSelectedImagePortion();
            int n = this.m_Image.getWidth(null);
            this.m_Image = ImagerGlobal.getScaledImage(this.m_Image, this.ImagePanelWidth, this.ImagePanelHeight, this);
            this.m_ImagePreviewScale = (float)this.m_Image.getWidth(null) / (float)n;
            this.m_MarkImagePanel = new MarkImagePanel();
            this.jbInit();
            this.m_StrengthSlider.setValue(100);
            this.jLabel1.setText("Strength: 100");
            this.m_LossSlider.setValue(2);
            this.jLabel2.setText("Loss: 2");
            this.setSize(450, 310);
            this.setLocationRelativeTo(imager);
            this.m_ImageHandler = new ImageHandler(this, this.m_Image);
            this.getRootPane().setDefaultButton(this.m_OkButton);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_MarkImagePanel.getImage() == null) {
            this.m_MarkImagePanel.setImage(this.m_Image);
        }
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.panel1.setLayout(this.borderLayout1);
        this.jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanel2.setLayout(null);
        this.jPanel1.setMinimumSize(new Dimension(10, 50));
        this.jPanel1.setPreferredSize(new Dimension(10, 50));
        this.m_StrengthSlider.setMajorTickSpacing(10);
        this.m_StrengthSlider.setPaintTicks(true);
        this.m_StrengthSlider.setBounds(new Rectangle(250, 37, 137, 28));
        this.m_StrengthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SpotlightDialog.this.m_StrengthSlider_stateChanged(changeEvent);
            }
        });
        this.jLabel1.setText("Strength:");
        this.jLabel1.setBounds(new Rectangle(250, 12, 98, 25));
        this.m_ColorButton.setText("Color");
        this.m_ColorButton.setBounds(new Rectangle(250, 148, 68, 24));
        this.m_ColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpotlightDialog.this.m_ColorButton_actionPerformed(actionEvent);
            }
        });
        this.m_ColorPanel.setBackground(Color.white);
        this.m_ColorPanel.setBounds(new Rectangle(321, 149, 62, 22));
        this.m_CancelButton.setText("Cancel");
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpotlightDialog.this.m_CancelButton_actionPerformed(actionEvent);
            }
        });
        this.m_OkButton.setText("   Ok   ");
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpotlightDialog.this.m_OkButton_actionPerformed(actionEvent);
            }
        });
        this.m_MarkImagePanel.setBorder(this.border1);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setBounds(new Rectangle(10, 20, 230, 180));
        this.jPanel3.setLayout(this.borderLayout2);
        this.m_PreviewButton.setText("Preview");
        this.m_PreviewButton.setBounds(new Rectangle(250, 176, 82, 26));
        this.m_PreviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpotlightDialog.this.m_PreviewButton_actionPerformed(actionEvent);
            }
        });
        this.m_RestoreButton.setText("Restore");
        this.m_RestoreButton.setBounds(new Rectangle(337, 175, 84, 27));
        this.m_RestoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpotlightDialog.this.m_RestoreButton_actionPerformed(actionEvent);
            }
        });
        this.jLabel2.setText("Loss:");
        this.jLabel2.setBounds(new Rectangle(250, 73, 78, 23));
        this.m_LossSlider.setMajorTickSpacing(1);
        this.m_LossSlider.setMaximum(5);
        this.m_LossSlider.setMinimum(1);
        this.m_LossSlider.setMinorTickSpacing(1);
        this.m_LossSlider.setPaintTicks(true);
        this.m_LossSlider.setBounds(new Rectangle(250, 100, 151, 32));
        this.m_LossSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SpotlightDialog.this.m_LossSlider_stateChanged(changeEvent);
            }
        });
        this.setResizable(false);
        this.U_jLabel3.setText("You can drag the Spotlight source to the desired location with the mouse");
        this.U_jLabel3.setBounds(new Rectangle(10, 203, 408, 26));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.m_OkButton, null);
        this.jPanel1.add((Component)this.m_CancelButton, null);
        this.panel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.m_MarkImagePanel, "Center");
        this.jPanel2.add((Component)this.m_PreviewButton, null);
        this.jPanel2.add((Component)this.m_RestoreButton, null);
        this.jPanel2.add((Component)this.m_ColorButton, null);
        this.jPanel2.add((Component)this.m_ColorPanel, null);
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.m_StrengthSlider, null);
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.m_LossSlider, null);
        this.jPanel2.add((Component)this.U_jLabel3, null);
    }

    void m_OkButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
        this.m_CenterX = this.m_MarkImagePanel.getSelectedX();
        this.m_CenterY = this.m_MarkImagePanel.getSelectedY();
        this.m_Imager.executeProcessImageThread(new Spotlight((int)((float)this.m_CenterX / this.m_ImagePreviewScale), (int)((float)this.m_CenterY / this.m_ImagePreviewScale), this.m_LossSlider.getValue(), this.m_StrengthSlider.getValue(), this.m_Color));
    }

    void m_CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void m_PreviewButton_actionPerformed(ActionEvent actionEvent) {
        this.m_CenterX = this.m_MarkImagePanel.getSelectedX();
        this.m_CenterY = this.m_MarkImagePanel.getSelectedY();
        this.m_MarkImagePanel.setImage(this.m_ImageHandler.processImage(new Spotlight(this.m_CenterX, this.m_CenterY, this.m_LossSlider.getValue(), (int)((float)this.m_StrengthSlider.getValue() * this.m_ImagePreviewScale), this.m_Color)));
    }

    void m_RestoreButton_actionPerformed(ActionEvent actionEvent) {
        this.m_MarkImagePanel.setImage(this.m_Image);
    }

    void m_StrengthSlider_stateChanged(ChangeEvent changeEvent) {
        this.jLabel1.setText("Strength: " + this.m_StrengthSlider.getValue());
    }

    void m_LossSlider_stateChanged(ChangeEvent changeEvent) {
        this.jLabel2.setText("Loss: " + this.m_LossSlider.getValue());
    }

    void m_ColorButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Spotlight color", this.m_Color);
        if (color != null) {
            this.m_Color = color;
        }
        this.m_ColorPanel.setBackground(this.m_Color);
    }
}

