/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class MarkImagePanel
extends ImagePanel {
    int m_CircleX;
    int m_CircleY;
    int width = 15;
    boolean m_inCircle = false;
    boolean first = true;

    public MarkImagePanel() {
        this((Image)null);
    }

    public MarkImagePanel(Image image) {
        super(image);
        this.addMouseMotionListener(new MarkImagePanelMouseMotionAdapter());
        this.addMouseListener(new MarkImagePanelMouseAdapter());
        if (image == null) {
            return;
        }
        this.m_CircleX = this.m_ImageX + this.m_Image.getWidth(null) / 2;
        this.m_CircleY = this.m_ImageY + this.m_Image.getHeight(null) / 2;
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (image == null && !this.first) {
            return;
        }
        if (this.first && image != null) {
            this.m_CircleX = this.getWidth() / 2;
            this.m_CircleY = this.getHeight() / 2;
            this.first = false;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_Image == null) {
            return;
        }
        graphics.setXORMode(Color.black);
        graphics.setColor(Color.white);
        graphics.fillOval(this.m_CircleX - this.width / 2, this.m_CircleY - this.width / 2, this.width, this.width);
    }

    public int getSelectedX() {
        return this.m_CircleX;
    }

    public int getSelectedY() {
        return this.m_CircleY;
    }

    class MarkImagePanelMouseMotionAdapter
    extends MouseMotionAdapter {
        MarkImagePanelMouseMotionAdapter() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!MarkImagePanel.this.m_inCircle) {
                return;
            }
            MarkImagePanel.this.m_CircleX = mouseEvent.getX();
            MarkImagePanel.this.m_CircleY = mouseEvent.getY();
            MarkImagePanel.this.repaint(MarkImagePanel.this.m_ImageX, MarkImagePanel.this.m_ImageY, MarkImagePanel.this.m_Image.getWidth(null), MarkImagePanel.this.m_Image.getHeight(null));
            MarkImagePanel.this.m_inCircle = true;
        }
    }

    class MarkImagePanelMouseAdapter
    extends MouseAdapter {
        MarkImagePanelMouseAdapter() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (MarkImagePanel.this.m_inCircle) {
                MarkImagePanel.this.m_CircleX = mouseEvent.getX();
                MarkImagePanel.this.m_CircleY = mouseEvent.getY();
                MarkImagePanel.this.repaint(MarkImagePanel.this.m_ImageX, MarkImagePanel.this.m_ImageY, MarkImagePanel.this.m_Image.getWidth(null), MarkImagePanel.this.m_Image.getHeight(null));
                MarkImagePanel.this.m_inCircle = false;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getX() >= MarkImagePanel.this.m_CircleX - MarkImagePanel.this.width / 2 && mouseEvent.getX() <= MarkImagePanel.this.m_CircleX + MarkImagePanel.this.width / 2 && mouseEvent.getY() >= MarkImagePanel.this.m_CircleY - MarkImagePanel.this.width / 2 && mouseEvent.getY() <= MarkImagePanel.this.m_CircleY + MarkImagePanel.this.width / 2) {
                MarkImagePanel.this.m_inCircle = true;
            }
        }
    }
}

