/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageFile;
import imager.ImagePanel;
import imager.ImagePrintable;
import imager.ImagerGlobal;
import imager.JPhotoImage;
import imager.PrintImage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class InternalImageFrame
extends JInternalFrame
implements ImagePrintable {
    static int OpenFrameCount = 0;
    static int UntitledCount = 0;
    ImageFile m_ImageFile;
    JScrollPane m_ImageScrollPane;
    ImagePanel m_ImagePanel;
    Frame m_Parent;
    Image m_PrevImage;
    Image m_RedoImage;
    public static int counter = 0;
    Stack UndoStack = new Stack();
    boolean finalized = false;

    public InternalImageFrame() {
    }

    public InternalImageFrame(String string, Frame frame, boolean bl) {
        this(string, null, frame, bl);
    }

    public InternalImageFrame(String string, Image image, Frame frame, boolean bl) {
        this(new File(string), image, frame, bl, -1, -1);
    }

    public InternalImageFrame(File file, Image image, Frame frame, boolean bl, int n, int n2) {
        this(file, image, frame, true, true, true, true, bl, n, n2);
    }

    public InternalImageFrame(File file, Image image, Frame frame, boolean bl) {
        this(file, image, frame, true, true, true, true, bl, -1, -1);
    }

    public InternalImageFrame(File file, Image image, Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(file, image, frame, bl, bl2, bl3, bl4, bl5, -1, -1);
    }

    public InternalImageFrame(File file, Image image, Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, int n2) {
        super(file.getName(), bl, bl2, bl3, bl4);
        this.m_ImagePanel = n == -1 && n2 == -1 ? new ImagePanel(image) : new ImagePanel(image, n, n2);
        this.m_ImagePanel.setOwner(this);
        this.m_ImageFile = new ImageFile(file);
        this.setSaved(bl5);
        this.setPrevImage(this.m_ImagePanel.getImage());
        this.m_ImageScrollPane = new JScrollPane(this.m_ImagePanel);
        this.getContentPane().add(this.m_ImageScrollPane);
        this.m_Parent = frame;
        try {
            this.U_jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
        this.setLocation(10 * OpenFrameCount, 10 * OpenFrameCount);
        ++OpenFrameCount;
        this.setVisible(true);
    }

    public void setImage(Image image, boolean bl) {
        this.m_ImagePanel.setImage(image);
        if (this.m_ImagePanel.getImage() != null) {
            this.setUndo(this.m_ImagePanel.getImage());
        } else if (bl) {
            this.pack();
        }
        this.m_ImageScrollPane.repaint();
    }

    public void setImage(Image image) {
        this.setImage(image, true);
    }

    public void setImageMaintainOriginalRatio(Image image) {
        this.setImageMaintainOriginalRatio(image, true);
    }

    public void setImageMaintainOriginalRatio(Image image, boolean bl) {
        if (this.m_ImagePanel.getImage() != null && bl) {
            this.setUndo(this.m_ImagePanel.getImage());
        }
        this.m_ImagePanel.setImageMaintainOrginalRatio(image);
        this.m_ImageScrollPane.repaint();
    }

    public void setUndo(Image image) {
        this.setPrevImage(image);
        this.m_ImageFile.setUndo(true);
        this.m_ImageFile.setRedo(false);
    }

    public Image getImage() {
        return this.m_ImagePanel.getImage();
    }

    public Graphics getImageGraphics() {
        Graphics graphics = this.m_ImagePanel.getGraphics();
        this.m_ImagePanel.paint(graphics);
        return graphics;
    }

    public ImagePanel getImagePanel() {
        return this.m_ImagePanel;
    }

    public ImageFile getImageFile() {
        return this.m_ImageFile;
    }

    public void setImageFile(ImageFile imageFile) {
        this.m_ImageFile = imageFile;
        if (imageFile != null) {
            this.setTitle(imageFile.getName());
        }
    }

    private void U_jbInit() throws Exception {
        this.getContentPane().add((Component)this.m_ImageScrollPane, "Center");
    }

    public static String getUntitled() {
        return "Untitled" + UntitledCount++;
    }

    public void setDimensionMaintainRatio(int n, int n2) {
        this.m_ImagePanel.setDimensionMaintainRatio(n, n2);
        this.setLocation(10, 10);
        this.pack();
    }

    public void setDimensionBy(double d, double d2) {
        this.m_ImagePanel.setDimensionBy(d, d2);
        this.setMaximum(false);
        this.pack();
    }

    public void restoreOriginalImageRatio() {
        this.m_ImagePanel.setDimensionBy(1.0, 1.0);
    }

    public void zoomIn() {
        this.m_ImagePanel.zoomIn();
        this.pack();
    }

    public void zoomOut() {
        this.m_ImagePanel.zoomOut();
        this.pack();
    }

    public void resetImageSize() {
        this.m_ImagePanel.resetImageSize();
        this.pack();
    }

    public void setPrevImage(Image image) {
        if (this.finalized) {
            try {
                throw new Exception("error!!!");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.m_PrevImage != null) {
            new SaveImageThread(this.m_PrevImage, this).start();
        }
        this.m_PrevImage = image;
    }

    public void performUndo() {
        Image image = this.m_PrevImage;
        this.m_RedoImage = this.m_ImagePanel.getImage();
        this.m_ImagePanel.setImageMaintainOrginalRatio(image);
        if (!this.UndoStack.isEmpty()) {
            new LoadImageThread().start();
        } else {
            this.m_PrevImage = null;
        }
    }

    public void performRedo() {
        this.m_PrevImage = this.m_ImagePanel.getImage();
        this.m_ImagePanel.setImageMaintainOrginalRatio(this.m_RedoImage);
        this.m_RedoImage = null;
    }

    public boolean canUndo() {
        return !this.UndoStack.isEmpty();
    }

    private void V_captureEvents(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, this);
        this.dispatchEvent(mouseEvent2);
        component.setCursor(this.getCursor());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = this.m_ImagePanel.print(graphics, pageFormat, n);
        if (PrintImage.PrintOption != null && PrintImage.PrintOption.getisDisplayFilenameCheckBox().isSelected()) {
            graphics.drawString(String.valueOf(PrintImage.PrintOption.getisDisplayFilepathCheckBox().isSelected() ? this.m_ImageFile.getParentFile().getAbsolutePath() : "") + File.separator + this.m_ImageFile.getName(), 10, (int)pageFormat.getImageableHeight() - 10);
        }
        return n2;
    }

    public int getNumPages(PageFormat pageFormat) {
        return this.m_ImagePanel.getNumPages(pageFormat);
    }

    public boolean isImageNormalViewed() {
        return this.m_ImagePanel.isImageNormalViewed();
    }

    public int getViewPortX() {
        return this.m_ImageScrollPane.getViewport().getViewPosition().x;
    }

    public int getViewPortY() {
        return this.m_ImageScrollPane.getViewport().getViewPosition().y;
    }

    public void setMaximum(boolean bl) {
        if (bl) {
            this.m_ImagePanel.setDimensionBy(1.0, 1.0);
        }
        try {
            super.setMaximum(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void cleanUp() {
        try {
            this.m_PrevImage = null;
            this.m_RedoImage = null;
            this.m_ImagePanel.setImage(null);
            this.m_ImageFile = null;
            while (!this.UndoStack.isEmpty()) {
                new File((String)this.UndoStack.pop()).delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.finalized = true;
    }

    public Image getSelectedImageRegion() {
        if (this.m_ImagePanel.getDraggable().isMoveable()) {
            if (!this.m_ImagePanel.getDraggable().isTextSelection()) {
                return this.m_ImagePanel.getDraggable().getImage();
            }
            this.m_ImagePanel.embeddDraggable();
            return this.getImage();
        }
        return this.getImage();
    }

    public Image getOriginalImage() {
        if (this.UndoStack.size() == 0) {
            return this.m_PrevImage;
        }
        String string = (String)this.UndoStack.firstElement();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            JPhotoImage jPhotoImage = (JPhotoImage)objectInputStream.readObject();
            objectInputStream.close();
            return ImagerGlobal.getBufferedImage(ImagerGlobal.createImage(jPhotoImage.pixels, jPhotoImage.w, jPhotoImage.h), this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setSaved(boolean bl) {
        this.m_ImageFile.setSaved(bl);
        if (!bl && !this.getTitle().endsWith("*")) {
            this.setTitle(String.valueOf(this.getTitle()) + " *");
        }
    }

    public boolean isUndoStackEmpty() {
        return this.UndoStack.isEmpty();
    }

    public class SaveImageThread
    extends Thread {
        Image image;
        JComponent com;

        SaveImageThread(Image image, JComponent jComponent) {
            this.image = image;
            this.com = jComponent;
            this.setPriority(4);
        }

        public void run() {
            try {
                File file = File.createTempFile("jpimage", ".tmp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                file.deleteOnExit();
                int n = this.image.getWidth(null);
                int n2 = this.image.getHeight(null);
                int[] nArray = new int[n * n2];
                PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, n, n2, nArray, 0, n);
                pixelGrabber.grabPixels();
                JPhotoImage jPhotoImage = new JPhotoImage();
                jPhotoImage.pixels = nArray;
                jPhotoImage.w = n;
                jPhotoImage.h = n2;
                objectOutputStream.writeObject(jPhotoImage);
                objectOutputStream.close();
                InternalImageFrame.this.UndoStack.push(file.getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class LoadImageThread
    extends Thread {
        LoadImageThread() {
        }

        public void run() {
            String string = (String)InternalImageFrame.this.UndoStack.pop();
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                JPhotoImage jPhotoImage = (JPhotoImage)objectInputStream.readObject();
                InternalImageFrame.this.m_PrevImage = ImagerGlobal.createImage(jPhotoImage.pixels, jPhotoImage.w, jPhotoImage.h);
                objectInputStream.close();
                new File(string).delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

