/*
 * Decompiled with CFR 0.152.
 */
package imager;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import imager.AlphaFilter;
import imager.DemoStamper;
import imager.ImageIOUtils;
import imager.ImageWrapper;
import imager.ImagerGlobal;
import imager.imagefileio.BMP.BMP;
import imager.imagefileio.GIF.AnimatedGifEncoder;
import imager.imagefileio.PICT.PICTImageSaver;
import imager.imagefileio.PNG.PNGEncoderB;
import imager.imagefileio.TGA.TGAoutput;
import imager.imagefileio.TIFF.TIFFoutput;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

final class ImageSavingThread
extends Thread {
    File imageFile;
    boolean isNewSave;
    Image m_Image;
    ImageWrapper m_wrapper;
    int type = 0;

    ImageSavingThread(ThreadGroup threadGroup, Image image, File file, boolean bl, ImageWrapper imageWrapper, int n) {
        super(threadGroup, "Image Saving Thread");
        this.m_wrapper = imageWrapper;
        this.m_Image = image;
        this.imageFile = file;
        this.isNewSave = bl;
        this.type = n;
    }

    ImageSavingThread(ImageWrapper imageWrapper, int n) {
        this.m_wrapper = imageWrapper;
        this.type = n;
    }

    ImageSavingThread(Image image, File file, boolean bl, ImageWrapper imageWrapper, int n) {
        this.m_wrapper = imageWrapper;
        this.m_Image = image;
        this.imageFile = file;
        this.isNewSave = bl;
        this.type = n;
    }

    public void setImage(Image image, File file, boolean bl) {
        this.m_Image = image;
        this.imageFile = file;
        this.isNewSave = bl;
    }

    public void run() {
        this.U_saveFile(this.imageFile, this.isNewSave);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void U_saveFile(File file, boolean bl) {
        try {
            try {
                Object object;
                BufferedImage bufferedImage = null;
                bufferedImage = new BufferedImage(this.m_Image.getWidth(null), this.m_Image.getHeight(null), 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(this.m_Image, 0, 0, this.m_Image.getWidth(null), this.m_Image.getHeight(null), null);
                if (this.type == 0) {
                    DemoStamper.stamp(bufferedImage, "Saved in Trial Version of JPhotoBrush Pro");
                }
                if (!System.getProperty("java.version").startsWith("1.3")) {
                    int n = file.getName().lastIndexOf(".");
                    object = file.getName().substring(n + 1);
                    if (!ImagerGlobal.JPG_FILTER.accept(file) && !ImagerGlobal.PNG_FILTER.accept(file) && ImageIOUtils.isWriteSupportedFormat((String)object) && ImageIOUtils.saveUsingImageIO(file, bufferedImage, (String)object)) {
                        this.m_wrapper.imageSaved(file);
                        Object var7_15 = null;
                        file = null;
                        this.m_Image = null;
                        return;
                    }
                }
                if (ImagerGlobal.JPG_FILTER.accept(file)) {
                    JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
                    if (bl) {
                        jPEGEncodeParam.setQuality((float)((double)ImagerGlobal.SaveImageFileChooser.getJPEGCompressionFactor() / 100.0), true);
                    }
                    object = JPEGCodec.createJPEGEncoder((OutputStream)new FileOutputStream(file), (JPEGEncodeParam)jPEGEncodeParam);
                    object.encode(bufferedImage);
                    object.getOutputStream().close();
                    bufferedImage.flush();
                } else if (file.getAbsolutePath().toLowerCase().endsWith(".gif")) {
                    AnimatedGifEncoder animatedGifEncoder = new AnimatedGifEncoder();
                    animatedGifEncoder.start(new FileOutputStream(file));
                    animatedGifEncoder.setTransparent(AlphaFilter.TRANSPARENTCOLOR);
                    animatedGifEncoder.addFrame(bufferedImage);
                    animatedGifEncoder.finish();
                } else if (file.getAbsolutePath().toLowerCase().endsWith(".bmp")) {
                    BMP bMP = new BMP(bufferedImage);
                    bMP.write(file);
                } else if (file.getAbsolutePath().toLowerCase().endsWith(".png")) {
                    PNGEncoderB pNGEncoderB = new PNGEncoderB(bufferedImage, ImagerGlobal.SaveImageFileChooser.encodePNGAlpha(), ImagerGlobal.SaveImageFileChooser.getPNGFilter(), ImagerGlobal.SaveImageFileChooser.getPNGCompressionFactor());
                    object = new FileOutputStream(file);
                    ((FileOutputStream)object).write(pNGEncoderB.pngEncode());
                    ((OutputStream)object).flush();
                    ((FileOutputStream)object).close();
                } else if (file.getAbsolutePath().toLowerCase().endsWith(".tif")) {
                    TIFFoutput tIFFoutput = new TIFFoutput(new FileOutputStream(file));
                    bufferedImage.getSource().startProduction(tIFFoutput);
                } else if (file.getAbsolutePath().toLowerCase().endsWith(".tga")) {
                    TGAoutput tGAoutput = new TGAoutput(new FileOutputStream(file));
                    bufferedImage.getSource().startProduction(tGAoutput);
                } else {
                    if (!file.getAbsolutePath().toLowerCase().endsWith(".pict")) throw new Exception("Invalid file type. \nSaving Aborted");
                    PICTImageSaver pICTImageSaver = new PICTImageSaver();
                    pICTImageSaver.setSaveImage(bufferedImage);
                    pICTImageSaver.setSavePath(file.getAbsolutePath());
                    pICTImageSaver.saveIt();
                }
                this.m_wrapper.imageSaved(file);
            }
            catch (Exception exception) {
                this.m_wrapper.imageNotSaved(exception, file);
                Object var7_16 = null;
                file = null;
                this.m_Image = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_17 = null;
            file = null;
            this.m_Image = null;
            throw throwable;
        }
        {
            Object var7_18 = null;
            file = null;
            this.m_Image = null;
            return;
        }
    }
}

