/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageBlendFilter;
import imager.ImageHandler;
import imager.ImagePanel;
import imager.ImageScrollPane;
import imager.Imager;
import imager.ImagerGlobal;
import imager.InternalImageFrame;
import imager.components.dialogs.JPhotoDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;

class ImageBlendDialog
extends JPhotoDialog {
    Imager m_Imager;
    ImageHandler m_ImageHandler;
    JInternalFrame[] m_InFrames;
    Image m_LeftImage;
    Image m_RightImage;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel m_ButtonPanel = new JPanel();
    JPanel m_MainPanel = new JPanel();
    JButton m_CancelButton = new JButton();
    JButton m_OkButton = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    protected JPanel m_OptionPanel = new JPanel();
    ImageScrollPane m_ImageScrollPane;
    JSlider jSlider2 = new JSlider();
    JComboBox m_LeftImageComboBox = new JComboBox();
    JComboBox m_RightImageComboBox = new JComboBox();
    JButton m_PreviewButton = new JButton();
    JPanel jPanel1 = new JPanel();
    JSlider jSlider1 = new JSlider();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    TitledBorder titledBorder1;
    boolean m_bLeftImageSelected;

    public ImageBlendDialog(Imager imager) {
        super(imager, "Image Blend", true);
        try {
            this.m_Imager = imager;
            this.m_ImageScrollPane = new ImageScrollPane(new ImagePanel());
            this.m_ImageHandler = new ImageHandler(this);
            this.jbInit();
            this.getImages();
            this.getRootPane().setDefaultButton(this.m_OkButton);
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSize(430, 400);
        this.setLocationRelativeTo(imager);
    }

    public ImageBlendDialog() {
        this((Imager)null);
    }

    public static void main(String[] stringArray) {
        new ImageBlendDialog();
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.panel1.setLayout(this.borderLayout1);
        this.getContentPane().setLayout(this.borderLayout2);
        this.m_ButtonPanel.setPreferredSize(new Dimension(10, 50));
        this.m_ButtonPanel.setLayout(this.flowLayout1);
        this.m_MainPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_MainPanel.setLayout(null);
        this.m_CancelButton.setText("Cancel");
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageBlendDialog.this.m_CancelButton_actionPerformed(actionEvent);
            }
        });
        this.m_OkButton.setText("   OK   ");
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageBlendDialog.this.m_OkButton_actionPerformed(actionEvent);
            }
        });
        this.m_OptionPanel.setMinimumSize(new Dimension(10, 150));
        this.m_OptionPanel.setPreferredSize(new Dimension(10, 150));
        this.m_OptionPanel.setBounds(new Rectangle(2, 185, 415, 138));
        this.m_OptionPanel.setLayout(null);
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.setBounds(new Rectangle(53, 18, 315, 24));
        this.m_LeftImageComboBox.setBounds(new Rectangle(17, 51, 182, 29));
        this.m_LeftImageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageBlendDialog.this.m_LeftImageComboBox_actionPerformed(actionEvent);
            }
        });
        this.m_RightImageComboBox.setBounds(new Rectangle(218, 51, 182, 29));
        this.m_RightImageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageBlendDialog.this.m_RightImageComboBox_actionPerformed(actionEvent);
            }
        });
        this.setModal(true);
        this.setResizable(false);
        this.m_PreviewButton.setText("Preview");
        this.m_PreviewButton.setBounds(new Rectangle(168, 102, 91, 29));
        this.m_PreviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageBlendDialog.this.m_PreviewButton_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(null);
        this.jSlider1.setBounds(new Rectangle(52, 5, 317, 24));
        this.jPanel1.setMinimumSize(new Dimension(100, 50));
        this.jPanel1.setPreferredSize(new Dimension(100, 20));
        this.jPanel1.setBounds(new Rectangle(2, 2, 407, 20));
        this.jLabel1.setBounds(new Rectangle(16, 99, 143, 31));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setHorizontalTextPosition(4);
        this.jLabel2.setBounds(new Rectangle(278, 106, 122, 23));
        this.m_ImageScrollPane.setBounds(new Rectangle(56, 28, 310, 152));
        this.getContentPane().add((Component)this.panel1, "Center");
        this.m_ButtonPanel.add((Component)this.m_OkButton, null);
        this.m_ButtonPanel.add((Component)this.m_CancelButton, null);
        this.panel1.add((Component)this.m_MainPanel, "Center");
        this.m_MainPanel.add((Component)this.m_ImageScrollPane, null);
        this.m_MainPanel.add((Component)this.m_OptionPanel, null);
        this.m_OptionPanel.add((Component)this.m_LeftImageComboBox, null);
        this.m_OptionPanel.add((Component)this.m_RightImageComboBox, null);
        this.m_OptionPanel.add((Component)this.m_PreviewButton, null);
        this.m_OptionPanel.add((Component)this.jLabel1, null);
        this.m_OptionPanel.add((Component)this.jLabel2, null);
        this.m_OptionPanel.add((Component)this.jSlider2, null);
        this.m_MainPanel.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jSlider1, null);
        this.getContentPane().add((Component)this.m_ButtonPanel, "South");
    }

    protected void getImages() {
        this.m_InFrames = this.m_Imager.getInternalImageFrames();
        if (this.m_InFrames == null) {
            JOptionPane.showConfirmDialog(this, "Images loading problem!", "JPhotoBrush Pro Dialog", -1, 0);
            return;
        }
        int n = 0;
        while (n < this.m_InFrames.length) {
            this.m_LeftImageComboBox.addItem(((InternalImageFrame)this.m_InFrames[n]).getTitle());
            this.m_RightImageComboBox.addItem(this.m_InFrames[n].getTitle());
            ++n;
        }
        this.m_LeftImage = ((InternalImageFrame)this.m_InFrames[0]).getSelectedImageRegion();
        this.m_RightImage = ((InternalImageFrame)this.m_InFrames[0]).getSelectedImageRegion();
    }

    void m_LeftImageComboBox_actionPerformed(ActionEvent actionEvent) {
        this.m_LeftImage = ((InternalImageFrame)this.m_InFrames[this.m_LeftImageComboBox.getSelectedIndex()]).getImage();
        this.m_ImageScrollPane.setImage(this.m_LeftImage);
        this.m_bLeftImageSelected = true;
        this.updateImageAndSliders();
        this.m_bLeftImageSelected = false;
        this.jLabel1.setText(String.valueOf(this.m_LeftImage.getWidth(null)) + "," + this.m_LeftImage.getHeight(null));
    }

    void m_RightImageComboBox_actionPerformed(ActionEvent actionEvent) {
        this.m_RightImage = ((InternalImageFrame)this.m_InFrames[this.m_RightImageComboBox.getSelectedIndex()]).getImage();
        this.m_ImageScrollPane.setImage(this.m_RightImage);
        this.updateImageAndSliders();
        this.jLabel2.setText(String.valueOf(this.m_RightImage.getWidth(null)) + "," + this.m_RightImage.getHeight(null));
    }

    protected void updateImageAndSliders() {
        this.m_ImageScrollPane.m_ImagePanel.setDimensionMaintainRatio(this.m_ImageScrollPane.getWidth(), this.m_ImageScrollPane.getHeight() - 5);
        Dimension dimension = this.m_ImageScrollPane.m_ImagePanel.getDimension();
        Rectangle rectangle = this.jSlider1.getBounds();
        rectangle.x = (int)((double)(this.m_ImageScrollPane.getBounds().x + this.m_ImageScrollPane.getBounds().width / 2) - dimension.getWidth() / 2.0);
        if (this.m_bLeftImageSelected) {
            this.jSlider1.setBounds((int)rectangle.getX(), (int)rectangle.getY(), (int)dimension.getWidth(), (int)rectangle.getHeight());
            this.jSlider1.setMaximum(this.m_LeftImage.getWidth(null));
            this.jSlider1.setValue(this.jSlider1.getMaximum() / 2);
        }
        rectangle = this.jSlider2.getBounds();
        rectangle.x = (int)((double)(this.m_ImageScrollPane.getBounds().x + this.m_ImageScrollPane.getBounds().width / 2) - dimension.getWidth() / 2.0);
        if (this.m_bLeftImageSelected) {
            this.jSlider2.setBounds((int)rectangle.getX(), (int)rectangle.getY(), (int)dimension.getWidth(), (int)rectangle.getHeight());
            this.jSlider2.setMaximum(this.m_LeftImage.getWidth(null));
            this.jSlider2.setValue(this.jSlider2.getMaximum() / 2);
        }
    }

    void m_PreviewButton_actionPerformed(ActionEvent actionEvent) {
        this.preview();
    }

    protected void preview() {
        if (this.m_LeftImage.getWidth(null) != this.m_RightImage.getWidth(null) && this.m_LeftImage.getHeight(null) != this.m_RightImage.getHeight(null)) {
            this.m_RightImage = ImagerGlobal.getImage(this.createImage(new FilteredImageSource(this.m_RightImage.getSource(), new AreaAveragingScaleFilter(this.m_LeftImage.getWidth(null), this.m_LeftImage.getHeight(null)))), this);
        }
        Image[] imageArray = new Image[]{this.m_LeftImage, this.m_RightImage};
        this.m_ImageHandler.setImages(imageArray);
        int n = this.jSlider1.getValue() > this.jSlider2.getValue() ? this.jSlider2.getValue() : this.jSlider1.getValue();
        int n2 = this.jSlider2.getValue() > this.jSlider1.getValue() ? this.jSlider2.getValue() : this.jSlider1.getValue();
        this.m_ImageScrollPane.setImage(this.m_ImageHandler.processImage(new ImageBlendFilter(n, n2)));
        this.m_ImageScrollPane.m_ImagePanel.setDimensionMaintainRatio(this.m_ImageScrollPane.getWidth(), this.m_ImageScrollPane.getHeight() - 5);
        this.repaint();
    }

    void m_OkButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
        this.preview();
        this.m_Imager.createInternalImageFrame(null, this.m_ImageScrollPane.m_ImagePanel.getImage(), false);
    }

    void m_CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

