/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.BrightnessContrastFilter;
import imager.ColorStatusPanel;
import imager.ImageHandler;
import imager.ImagePanel;
import imager.Imager;
import imager.components.dialogs.JPhotoDialog;
import imager.utils.ImageOpUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BrightnessContrastDialog
extends JPhotoDialog {
    BrightnessContrastFilter m_BCFilter;
    Imager m_Imager;
    Image m_Image;
    ImageHandler m_ImageHandler;
    JPanel m_BrightnessPanel = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    JPanel m_ContrastPanel = new JPanel();
    Border border2;
    TitledBorder titledBorder2;
    JLabel m_BrightnessLabel = new JLabel();
    JLabel m_ContrastLabel = new JLabel();
    JSlider m_BrightnessSlider = new JSlider();
    JSlider m_ContrastSlider = new JSlider();
    JButton m_OkButton = new JButton();
    JButton m_CanceljButton = new JButton();
    JCheckBox m_PreviewCheckBox = new JCheckBox();
    ImagePanel m_ImagePanel;

    public BrightnessContrastDialog(Imager imager) {
        super(imager, "Brightness/Contrast", true);
        try {
            this.m_Imager = imager;
            this.m_ImagePanel = new ImagePanel();
            this.m_ImagePanel.setPreferredSize(new Dimension(327, 113));
            this.m_ImageHandler = new ImageHandler(this);
            this.setImage(imager.getSelectedImagePortion());
            this.m_BCFilter = new BrightnessContrastFilter();
            this.jbInit();
            this.setSize(370, 300);
            this.setLocationRelativeTo(imager);
            this.m_PreviewCheckBox.setSelected(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder();
        this.titledBorder1 = new TitledBorder(BorderFactory.createEmptyBorder(), "Brightness:");
        this.border2 = BorderFactory.createEmptyBorder();
        this.titledBorder2 = new TitledBorder(this.border2, "% Contrast:");
        this.getContentPane().setLayout(null);
        this.m_BrightnessPanel.setBorder(this.titledBorder1);
        this.m_BrightnessPanel.setBounds(new Rectangle(14, 149, 175, 63));
        this.m_BrightnessPanel.setLayout(null);
        this.m_ContrastPanel.setBorder(this.titledBorder2);
        this.m_ContrastPanel.setBounds(new Rectangle(182, 148, 175, 63));
        this.m_ContrastPanel.setLayout(null);
        this.m_BrightnessLabel.setText("0");
        this.m_BrightnessLabel.setBounds(new Rectangle(73, 0, 74, 19));
        this.m_ContrastLabel.setText("0");
        this.m_ContrastLabel.setBounds(new Rectangle(77, 0, 41, 17));
        this.m_BrightnessSlider.setMajorTickSpacing(50);
        this.m_BrightnessSlider.setMaximum(255);
        this.m_BrightnessSlider.setMinimum(-255);
        this.m_BrightnessSlider.setMinorTickSpacing(50);
        this.m_BrightnessSlider.setPaintTicks(true);
        this.m_BrightnessSlider.setValue(0);
        this.m_BrightnessSlider.setBounds(new Rectangle(3, 21, 166, 41));
        this.m_BrightnessSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BrightnessContrastDialog.this.m_BrightnessSlider_stateChanged(changeEvent);
            }
        });
        this.m_ContrastSlider.setMajorTickSpacing(10);
        this.m_ContrastSlider.setMinimum(-100);
        this.m_ContrastSlider.setMinorTickSpacing(10);
        this.m_ContrastSlider.setPaintTicks(true);
        this.m_ContrastSlider.setBounds(new Rectangle(2, 22, 172, 40));
        this.m_ContrastSlider.setValue(0);
        this.m_ContrastSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BrightnessContrastDialog.this.m_ContrastSlider_stateChanged(changeEvent);
            }
        });
        this.m_OkButton.setSelected(true);
        this.m_OkButton.setText("OK");
        this.m_OkButton.setBounds(new Rectangle(37, 214, 83, 26));
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrightnessContrastDialog.this.m_OkButton_actionPerformed(actionEvent);
            }
        });
        this.m_CanceljButton.setText("Cancel");
        this.m_CanceljButton.setBounds(new Rectangle(142, 214, 83, 26));
        this.m_CanceljButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrightnessContrastDialog.this.m_CanceljButton_actionPerformed(actionEvent);
            }
        });
        this.m_ImagePanel.setBounds(new Rectangle(15, 9, 342, 122));
        this.m_PreviewCheckBox.setText("Preview");
        this.m_PreviewCheckBox.setBounds(new Rectangle(255, 213, 84, 28));
        this.m_PreviewCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrightnessContrastDialog.this.m_PreviewCheckBox_actionPerformed(actionEvent);
            }
        });
        this.setModal(true);
        this.setResizable(false);
        this.m_BrightnessPanel.add((Component)this.m_BrightnessLabel, null);
        this.m_BrightnessPanel.add((Component)this.m_BrightnessSlider, null);
        this.getContentPane().add((Component)this.m_ContrastPanel, null);
        this.m_ContrastPanel.add((Component)this.m_ContrastLabel, null);
        this.m_ContrastPanel.add((Component)this.m_ContrastSlider, null);
        this.getContentPane().add((Component)this.m_BrightnessPanel, null);
        this.getContentPane().add((Component)this.m_ImagePanel, null);
        this.getContentPane().add((Component)this.m_OkButton, null);
        this.getContentPane().add((Component)this.m_PreviewCheckBox, null);
        this.getContentPane().add((Component)this.m_CanceljButton, null);
    }

    void m_BrightnessSlider_stateChanged(ChangeEvent changeEvent) {
        this.m_BrightnessLabel.setText("" + ((JSlider)changeEvent.getSource()).getValue());
        if (!this.m_BrightnessSlider.getValueIsAdjusting()) {
            this.processImage();
        }
    }

    void m_ContrastSlider_stateChanged(ChangeEvent changeEvent) {
        this.m_ContrastLabel.setText("" + ((JSlider)changeEvent.getSource()).getValue());
        if (!this.m_ContrastSlider.getValueIsAdjusting()) {
            this.processImage();
        }
    }

    void m_PreviewCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this.m_PreviewCheckBox.isSelected()) {
            this.processImage();
        } else {
            this.m_ImagePanel.setImage(this.m_Image);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.setImage(null);
        }
    }

    protected void processImage() {
        if (this.m_Image != null) {
            this.m_BCFilter.setBrightnessContrast(this.m_BrightnessSlider.getValue(), this.m_ContrastSlider.getValue());
            if (this.m_PreviewCheckBox.isSelected()) {
                this.m_ImagePanel.setImage(this.m_ImageHandler.processImage(this.m_BCFilter));
            }
        }
    }

    protected void setImage(Image image) {
        this.m_Image = image != null ? ImageOpUtils.createCentrallyCroppedImage(this.m_Imager.getSelectedImagePortion(), this.m_ImagePanel.getPreferredSize(), this) : image;
        this.m_ImagePanel.setImage(this.m_Image);
        this.m_ImageHandler.setImage(this.m_Image);
    }

    void m_CanceljButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
        System.gc();
    }

    void m_OkButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.m_Imager.executeProcessImageThread(this.m_BCFilter);
    }

    public static int getVersion() {
        return ColorStatusPanel.getVersion();
    }

    public void showDialog() {
        if (this.m_Image == null) {
            this.setImage(this.m_Imager.getSelectedImagePortion());
            this.getRootPane().setDefaultButton(this.m_OkButton);
            this.m_BrightnessSlider.setValue(0);
            this.m_ContrastSlider.setValue(0);
        }
        this.show();
    }
}

