/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;

public class ExifReader
implements MetadataReader {
    private final byte[] UUU__data;
    private boolean VVv__isMotorollaByteOrder;
    private Metadata VUu__metadata;
    static final int[] BYTES_PER_FORMAT;
    private static final int UvV_MAX_FORMAT_CODE = 12;
    private static final int UuU_FMT_BYTE = 1;
    private static final int UUv_FMT_STRING = 2;
    private static final int Vuu_FMT_USHORT = 3;
    private static final int VVV_FMT_ULONG = 4;
    private static final int VUU_FMT_URATIONAL = 5;
    private static final int Uuv_FMT_SBYTE = 6;
    private static final int UVu_FMT_UNDEFINED = 7;
    private static final int UUV_FMT_SSHORT = 8;
    private static final int VuU_FMT_SLONG = 9;
    private static final int VUv_FMT_SRATIONAL = 10;
    private static final int Uvu_FMT_SINGLE = 11;
    private static final int UuV_FMT_DOUBLE = 12;
    public static final int TAG_EXIF_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE = 37500;
    public static int TIFF_HEADER_START_OFFSET;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        BYTES_PER_FORMAT = nArray;
        TIFF_HEADER_START_OFFSET = 6;
    }

    public ExifReader(File file) throws JpegProcessingException {
        this(new JpegSegmentReader(file).readSegment((byte)-31));
    }

    public ExifReader(byte[] byArray) {
        this.UUU__data = byArray;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        this.VUu__metadata = metadata;
        if (this.UUU__data == null) {
            return this.VUu__metadata;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.drew.metadata.exif.ExifDirectory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Directory directory = this.VUu__metadata.getDirectory(clazz);
        if (this.UUU__data.length <= 14) {
            directory.addError("Exif data segment must contain at least 14 bytes");
            return this.VUu__metadata;
        }
        if (!"Exif\u0000\u0000".equals(new String(this.UUU__data, 0, 6))) {
            directory.addError("Exif data segment doesn't begin with 'Exif'");
            return this.VUu__metadata;
        }
        String string = new String(this.UUU__data, 6, 2);
        if (!this.UVU_setByteOrder(string)) {
            directory.addError("Unclear distinction between Motorola/Intel byte ordering");
            return this.VUu__metadata;
        }
        if (this.Vuv_get16Bits(8) != 42) {
            directory.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return this.VUu__metadata;
        }
        int n = this.VVu_get32Bits(10) + TIFF_HEADER_START_OFFSET;
        if (n >= this.UUU__data.length - 1) {
            directory.addError("First exif directory offset is beyond end of Exif data segment");
            n = 14;
        }
        this.VUV_processDirectory(directory, n);
        this.UvU_extractThumbnail(directory);
        return this.VUu__metadata;
    }

    private void UvU_extractThumbnail(Directory directory) {
        if (!(directory instanceof ExifDirectory)) {
            return;
        }
        if (!directory.containsTag(514) || !directory.containsTag(513)) {
            return;
        }
        try {
            int n = directory.getInt(513);
            int n2 = directory.getInt(514);
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = this.UUU__data[TIFF_HEADER_START_OFFSET + n + n3];
                ++n3;
            }
            directory.setByteArray(61441, byArray);
        }
        catch (Throwable throwable) {
            directory.addError("Unable to extract thumbnail: " + throwable.getMessage());
        }
    }

    private boolean UVU_setByteOrder(String string) {
        if ("MM".equals(string)) {
            this.VVv__isMotorollaByteOrder = true;
        } else if ("II".equals(string)) {
            this.VVv__isMotorollaByteOrder = false;
        } else {
            return false;
        }
        return true;
    }

    private void VUV_processDirectory(Directory directory, int n) {
        if (n >= this.UUU__data.length || n < 0) {
            directory.addError("Ignored directory marked to start outside data segement");
            return;
        }
        int n2 = this.Vuv_get16Bits(n);
        if (!this.UVv_isDirectoryLengthValid(n)) {
            directory.addError("Illegally sized directory");
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.UUu_calculateDirectoryEntryOffset(n, n3);
            int n5 = this.Vuv_get16Bits(n4);
            int n6 = this.Vuv_get16Bits(n4 + 2);
            if (n6 < 0 || n6 > 12) {
                directory.addError("Invalid format code: " + n6);
            } else {
                int n7 = this.VVu_get32Bits(n4 + 4);
                int n8 = n7 * BYTES_PER_FORMAT[n6];
                int n9 = this.VuV_calculateTagValueOffset(n8, n4);
                if (n9 < 0) {
                    directory.addError("Illegal pointer offset value in EXIF");
                } else {
                    int n10 = TIFF_HEADER_START_OFFSET + this.VVu_get32Bits(n9);
                    switch (n5) {
                        case 34665: {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("com.drew.metadata.exif.ExifDirectory");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz), n10);
                            break;
                        }
                        case 40965: {
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("com.drew.metadata.exif.ExifInteropDirectory");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz), n10);
                            break;
                        }
                        case 34853: {
                            Class<?> clazz = class$2;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("com.drew.metadata.exif.GpsDirectory");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz), n10);
                            break;
                        }
                        case 37500: {
                            this.VVU_processMakerNote(n9);
                            break;
                        }
                        default: {
                            this.Uvv_processTag(directory, n5, n9, n7, n6);
                        }
                    }
                }
            }
            ++n3;
        }
        n3 = this.VVu_get32Bits(n + 2 + 12 * n2);
        if (n3 != 0) {
            if ((n3 += TIFF_HEADER_START_OFFSET) >= this.UUU__data.length) {
                return;
            }
            this.VUV_processDirectory(directory, n3);
        }
    }

    private void VVU_processMakerNote(int n) {
        Directory directory;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.drew.metadata.exif.ExifDirectory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((directory = this.VUu__metadata.getDirectory(clazz)) == null) {
            return;
        }
        String string = directory.getString(271);
        if ("OLYMP".equals(new String(this.UUU__data, n, 5))) {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("com.drew.metadata.exif.OlympusMakernoteDirectory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz2), n + 8);
        } else if (string != null && string.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(new String(this.UUU__data, n, 5))) {
                if (this.UUU__data[n + 6] == 1) {
                    Class<?> clazz3 = class$4;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$4 = Class.forName("com.drew.metadata.exif.NikonType1MakernoteDirectory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz3), n + 8);
                } else if (this.UUU__data[n + 6] == 2) {
                    int n2 = TIFF_HEADER_START_OFFSET;
                    TIFF_HEADER_START_OFFSET = n + 10;
                    Class<?> clazz4 = class$5;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$5 = Class.forName("com.drew.metadata.exif.NikonType3MakernoteDirectory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz4), n + 18);
                    TIFF_HEADER_START_OFFSET = n2;
                } else {
                    directory.addError("Unsupported makernote data ignored.");
                }
            } else {
                Class<?> clazz5 = class$6;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$6 = Class.forName("com.drew.metadata.exif.NikonType2MakernoteDirectory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz5), n);
            }
        } else if ("Canon".equalsIgnoreCase(string)) {
            Class<?> clazz6 = class$7;
            if (clazz6 == null) {
                try {
                    clazz6 = class$7 = Class.forName("com.drew.metadata.exif.CanonMakernoteDirectory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz6), n);
        } else if ("Casio".equalsIgnoreCase(string)) {
            Class<?> clazz7 = class$8;
            if (clazz7 == null) {
                try {
                    clazz7 = class$8 = Class.forName("com.drew.metadata.exif.CasioMakernoteDirectory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz7), n);
        } else if ("FUJIFILM".equals(new String(this.UUU__data, n, 8)) || "Fujifilm".equalsIgnoreCase(string)) {
            boolean bl = this.VVv__isMotorollaByteOrder;
            this.VVv__isMotorollaByteOrder = false;
            int n3 = n + this.VVu_get32Bits(n + 8);
            Class<?> clazz8 = class$9;
            if (clazz8 == null) {
                try {
                    clazz8 = class$9 = Class.forName("com.drew.metadata.exif.FujiFilmMakernoteDirectory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.VUV_processDirectory(this.VUu__metadata.getDirectory(clazz8), n3);
            this.VVv__isMotorollaByteOrder = bl;
        } else {
            directory.addError("Unsupported makernote data ignored.");
        }
    }

    private boolean UVv_isDirectoryLengthValid(int n) {
        int n2 = this.Vuv_get16Bits(n);
        int n3 = 2 + 12 * n2 + 4;
        return n3 + n + TIFF_HEADER_START_OFFSET < this.UUU__data.length;
    }

    private void Uvv_processTag(Directory directory, int n, int n2, int n3, int n4) {
        switch (n4) {
            case 2: 
            case 7: {
                String string = n == 37510 ? this.Uuu_readCommentString(n2, n3, n4) : this.UVV_readString(n2, n3);
                directory.setString(n, string);
                break;
            }
            case 5: 
            case 10: {
                if (n3 == 1) {
                    Rational rational = new Rational(this.VVu_get32Bits(n2), this.VVu_get32Bits(n2 + 4));
                    directory.setRational(n, rational);
                    break;
                }
                Rational[] rationalArray = new Rational[n3];
                int n5 = 0;
                while (n5 < n3) {
                    rationalArray[n5] = new Rational(this.VVu_get32Bits(n2 + 8 * n5), this.VVu_get32Bits(n2 + 4 + 8 * n5));
                    ++n5;
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 1: 
            case 6: {
                if (n3 == 1) {
                    byte by = this.UUU__data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                int n6 = 0;
                while (n6 < n3) {
                    nArray[n6] = this.UUU__data[n2 + n6];
                    ++n6;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 11: 
            case 12: {
                if (n3 == 1) {
                    byte by = this.UUU__data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n7] = this.UUU__data[n2 + n7];
                    ++n7;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 3: 
            case 8: {
                if (n3 == 1) {
                    int n8 = this.Vuv_get16Bits(n2);
                    directory.setInt(n, n8);
                    break;
                }
                int[] nArray = new int[n3];
                int n9 = 0;
                while (n9 < n3) {
                    nArray[n9] = this.Vuv_get16Bits(n2 + n9 * 2);
                    ++n9;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 4: 
            case 9: {
                if (n3 == 1) {
                    int n10 = this.VVu_get32Bits(n2);
                    directory.setInt(n, n10);
                    break;
                }
                int[] nArray = new int[n3];
                int n11 = 0;
                while (n11 < n3) {
                    nArray[n11] = this.VVu_get32Bits(n2 + n11 * 4);
                    ++n11;
                }
                directory.setIntArray(n, nArray);
                break;
            }
            default: {
                directory.addError("unknown format code " + n4);
            }
        }
    }

    private int VuV_calculateTagValueOffset(int n, int n2) {
        if (n > 4) {
            int n3 = this.VVu_get32Bits(n2 + 8);
            if (n3 + n > this.UUU__data.length) {
                return -1;
            }
            return TIFF_HEADER_START_OFFSET + n3;
        }
        return n2 + 8;
    }

    private String UVV_readString(int n, int n2) {
        int n3 = 0;
        while (n + n3 < this.UUU__data.length && this.UUU__data[n + n3] != 0 && n3 < n2) {
            ++n3;
        }
        return new String(this.UUU__data, n, n3);
    }

    private String Uuu_readCommentString(int n, int n2, int n3) {
        int n4 = n2 * BYTES_PER_FORMAT[n3];
        int n5 = n4 - 1;
        while (n5 >= 0) {
            if (this.UUU__data[n + n5] != 32) break;
            this.UUU__data[n + n5] = 0;
            --n5;
        }
        if ("ASCII".equals(new String(this.UUU__data, n, 5))) {
            n5 = 5;
            while (n5 < 10) {
                byte by = this.UUU__data[n + n5];
                if (by != 0 && by != 32) {
                    return this.UVV_readString(n + n5, 1999);
                }
                ++n5;
            }
        }
        return this.UVV_readString(n, 1999);
    }

    private int UUu_calculateDirectoryEntryOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }

    private int Vuv_get16Bits(int n) {
        if (n < 0 || n >= this.UUU__data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this.UUU__data.length - 1) + ")");
        }
        if (this.VVv__isMotorollaByteOrder) {
            return this.UUU__data[n] << 8 & 0xFF00 | this.UUU__data[n + 1] & 0xFF;
        }
        return this.UUU__data[n + 1] << 8 & 0xFF00 | this.UUU__data[n] & 0xFF;
    }

    private int VVu_get32Bits(int n) {
        if (n < 0 || n >= this.UUU__data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this.UUU__data.length - 1) + ")");
        }
        if (this.VVv__isMotorollaByteOrder) {
            return this.UUU__data[n] << 24 & 0xFF000000 | this.UUU__data[n + 1] << 16 & 0xFF0000 | this.UUU__data[n + 2] << 8 & 0xFF00 | this.UUU__data[n + 3] & 0xFF;
        }
        return this.UUU__data[n + 3] << 24 & 0xFF000000 | this.UUU__data[n + 2] << 16 & 0xFF0000 | this.UUU__data[n + 1] << 8 & 0xFF00 | this.UUU__data[n] & 0xFF;
    }
}

