/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class CanonMakernoteDescriptor
extends TagDescriptor {
    public CanonMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 49409: {
                return this.UUU_getMacroModeDescription();
            }
            case 49410: {
                return this.VUv_getSelfTimerDelayDescription();
            }
            case 49412: {
                return this.VUU_getFlashModeDescription();
            }
            case 49413: {
                return this.UvV_getContinuousDriveModeDescription();
            }
            case 49415: {
                return this.Uuu_getFocusMode1Description();
            }
            case 49418: {
                return this.UVv_getImageSizeDescription();
            }
            case 49419: {
                return this.UVU_getEasyShootingModeDescription();
            }
            case 49421: {
                return this.UUV_getContrastDescription();
            }
            case 49422: {
                return this.VVU_getSaturationDescription();
            }
            case 49423: {
                return this.VUV_getSharpnessDescription();
            }
            case 49424: {
                return this.Uvu_getIsoDescription();
            }
            case 49425: {
                return this.Uuv_getMeteringModeDescription();
            }
            case 49427: {
                return this.UuU_getAfPointSelectedDescription();
            }
            case 49428: {
                return this.UVV_getExposureModeDescription();
            }
            case 49431: {
                return this.UUu_getLongFocalLengthDescription();
            }
            case 49432: {
                return this.VVV_getShortFocalLengthDescription();
            }
            case 49433: {
                return this.VUu_getFocalUnitsPerMillimetreDescription();
            }
            case 49437: {
                return this.Uvv_getFlashDetailsDescription();
            }
            case 49440: {
                return this.UvU_getFocusMode2Description();
            }
            case 49671: {
                return this.UuV_getWhiteBalanceDescription();
            }
            case 49678: {
                return this.UVu_getAfPointUsedDescription();
            }
            case 49679: {
                return this.UUv_getFlashBiasDescription();
            }
        }
        return this._directory.getString(n);
    }

    private String UUv_getFlashBiasDescription() throws MetadataException {
        if (!this._directory.containsTag(49679)) {
            return null;
        }
        int n = this._directory.getInt(49679);
        switch (n) {
            case 65472: {
                return "-2 EV";
            }
            case 65484: {
                return "-1.67 EV";
            }
            case 65488: {
                return "-1.50 EV";
            }
            case 65492: {
                return "-1.33 EV";
            }
            case 65504: {
                return "-1 EV";
            }
            case 65516: {
                return "-0.67 EV";
            }
            case 65520: {
                return "-0.50 EV";
            }
            case 65524: {
                return "-0.33 EV";
            }
            case 0: {
                return "0 EV";
            }
            case 12: {
                return "0.33 EV";
            }
            case 16: {
                return "0.50 EV";
            }
            case 20: {
                return "0.67 EV";
            }
            case 32: {
                return "1 EV";
            }
            case 44: {
                return "1.33 EV";
            }
            case 48: {
                return "1.50 EV";
            }
            case 52: {
                return "1.67 EV";
            }
            case 64: {
                return "2 EV";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UVu_getAfPointUsedDescription() throws MetadataException {
        if (!this._directory.containsTag(49678)) {
            return null;
        }
        int n = this._directory.getInt(49678);
        if ((n & 7) == 0) {
            return "Right";
        }
        if ((n & 7) == 1) {
            return "Centre";
        }
        if ((n & 7) == 2) {
            return "Left";
        }
        return "Unknown (" + n + ")";
    }

    private String UuV_getWhiteBalanceDescription() throws MetadataException {
        if (!this._directory.containsTag(49671)) {
            return null;
        }
        int n = this._directory.getInt(49671);
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Sunny";
            }
            case 2: {
                return "Cloudy";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Flourescent";
            }
            case 5: {
                return "Flash";
            }
            case 6: {
                return "Custom";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UvU_getFocusMode2Description() throws MetadataException {
        if (!this._directory.containsTag(49440)) {
            return null;
        }
        int n = this._directory.getInt(49440);
        switch (n) {
            case 0: {
                return "Single";
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Uvv_getFlashDetailsDescription() throws MetadataException {
        if (!this._directory.containsTag(49437)) {
            return null;
        }
        int n = this._directory.getInt(49437);
        if ((n << 14 & 1) > 0) {
            return "External E-TTL";
        }
        if ((n << 13 & 1) > 0) {
            return "Internal flash";
        }
        if ((n << 11 & 1) > 0) {
            return "FP sync used";
        }
        if ((n << 4 & 1) > 0) {
            return "FP sync enabled";
        }
        return "Unknown (" + n + ")";
    }

    private String VUu_getFocalUnitsPerMillimetreDescription() throws MetadataException {
        if (!this._directory.containsTag(49433)) {
            return "";
        }
        int n = this._directory.getInt(49433);
        if (n != 0) {
            return Integer.toString(n);
        }
        return "";
    }

    private String VVV_getShortFocalLengthDescription() throws MetadataException {
        if (!this._directory.containsTag(49432)) {
            return null;
        }
        int n = this._directory.getInt(49432);
        String string = this.VUu_getFocalUnitsPerMillimetreDescription();
        return String.valueOf(Integer.toString(n)) + " " + string;
    }

    private String UUu_getLongFocalLengthDescription() throws MetadataException {
        if (!this._directory.containsTag(49431)) {
            return null;
        }
        int n = this._directory.getInt(49431);
        String string = this.VUu_getFocalUnitsPerMillimetreDescription();
        return String.valueOf(Integer.toString(n)) + " " + string;
    }

    private String UVV_getExposureModeDescription() throws MetadataException {
        if (!this._directory.containsTag(49428)) {
            return null;
        }
        int n = this._directory.getInt(49428);
        switch (n) {
            case 0: {
                return "Easy shooting";
            }
            case 1: {
                return "Program";
            }
            case 2: {
                return "Tv-priority";
            }
            case 3: {
                return "Av-priority";
            }
            case 4: {
                return "Manual";
            }
            case 5: {
                return "A-DEP";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UuU_getAfPointSelectedDescription() throws MetadataException {
        if (!this._directory.containsTag(49427)) {
            return null;
        }
        int n = this._directory.getInt(49427);
        switch (n) {
            case 12288: {
                return "None (MF)";
            }
            case 12289: {
                return "Auto selected";
            }
            case 12290: {
                return "Right";
            }
            case 12291: {
                return "Centre";
            }
            case 12292: {
                return "Left";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Uuv_getMeteringModeDescription() throws MetadataException {
        if (!this._directory.containsTag(49425)) {
            return null;
        }
        int n = this._directory.getInt(49425);
        switch (n) {
            case 3: {
                return "Evaluative";
            }
            case 4: {
                return "Partial";
            }
            case 5: {
                return "Centre weighted";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Uvu_getIsoDescription() throws MetadataException {
        if (!this._directory.containsTag(49424)) {
            return null;
        }
        int n = this._directory.getInt(49424);
        switch (n) {
            case 0: {
                return "Not specified (see ISOSpeedRatings tag)";
            }
            case 15: {
                return "Auto";
            }
            case 16: {
                return "50";
            }
            case 17: {
                return "100";
            }
            case 18: {
                return "200";
            }
            case 19: {
                return "400";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String VUV_getSharpnessDescription() throws MetadataException {
        if (!this._directory.containsTag(49423)) {
            return null;
        }
        int n = this._directory.getInt(49423);
        switch (n) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String VVU_getSaturationDescription() throws MetadataException {
        if (!this._directory.containsTag(49422)) {
            return null;
        }
        int n = this._directory.getInt(49422);
        switch (n) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UUV_getContrastDescription() throws MetadataException {
        if (!this._directory.containsTag(49421)) {
            return null;
        }
        int n = this._directory.getInt(49421);
        switch (n) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UVU_getEasyShootingModeDescription() throws MetadataException {
        if (!this._directory.containsTag(49419)) {
            return null;
        }
        int n = this._directory.getInt(49419);
        switch (n) {
            case 0: {
                return "Full auto";
            }
            case 1: {
                return "Manual";
            }
            case 2: {
                return "Landscape";
            }
            case 3: {
                return "Fast shutter";
            }
            case 4: {
                return "Slow shutter";
            }
            case 5: {
                return "Night";
            }
            case 6: {
                return "B&W";
            }
            case 7: {
                return "Sepia";
            }
            case 8: {
                return "Portrait";
            }
            case 9: {
                return "Sports";
            }
            case 10: {
                return "Macro / Closeup";
            }
            case 11: {
                return "Pan focus";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UVv_getImageSizeDescription() throws MetadataException {
        if (!this._directory.containsTag(49418)) {
            return null;
        }
        int n = this._directory.getInt(49418);
        switch (n) {
            case 0: {
                return "Large";
            }
            case 1: {
                return "Medium";
            }
            case 2: {
                return "Small";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String Uuu_getFocusMode1Description() throws MetadataException {
        if (!this._directory.containsTag(49415)) {
            return null;
        }
        int n = this._directory.getInt(49415);
        switch (n) {
            case 0: {
                return "One-shot";
            }
            case 1: {
                return "AI Servo";
            }
            case 2: {
                return "AI Focus";
            }
            case 3: {
                return "MF";
            }
            case 4: {
                return "Single";
            }
            case 5: {
                return "Continuous";
            }
            case 6: {
                return "MF";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String UvV_getContinuousDriveModeDescription() throws MetadataException {
        if (!this._directory.containsTag(49413)) {
            return null;
        }
        int n = this._directory.getInt(49413);
        switch (n) {
            case 0: {
                if (this._directory.getInt(49410) == 0) {
                    return "Single shot";
                }
                return "Single shot with self-timer";
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String VUU_getFlashModeDescription() throws MetadataException {
        if (!this._directory.containsTag(49412)) {
            return null;
        }
        int n = this._directory.getInt(49412);
        switch (n) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Auto";
            }
            case 2: {
                return "On";
            }
            case 3: {
                return "Red-eye reduction";
            }
            case 4: {
                return "Slow-synchro";
            }
            case 5: {
                return "Auto and red-eye reduction";
            }
            case 6: {
                return "On and red-eye reduction";
            }
            case 16: {
                return "Extenal flash";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String VUv_getSelfTimerDelayDescription() throws MetadataException {
        if (!this._directory.containsTag(49410)) {
            return null;
        }
        int n = this._directory.getInt(49410);
        if (n == 0) {
            return "Self timer not used";
        }
        return String.valueOf(Double.toString((double)n * 0.1)) + " sec";
    }

    private String UUU_getMacroModeDescription() throws MetadataException {
        if (!this._directory.containsTag(49409)) {
            return null;
        }
        int n = this._directory.getInt(49409);
        switch (n) {
            case 1: {
                return "Macro";
            }
            case 2: {
                return "Normal";
            }
        }
        return "Unknown (" + n + ")";
    }
}

