/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.TagDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class Directory
implements Serializable {
    protected final HashMap _tagMap = new HashMap();
    protected TagDescriptor _descriptor;
    protected final List _definedTagList = new ArrayList();
    private List U__errorList;

    public abstract String getName();

    protected abstract HashMap getTagNameMap();

    public boolean containsTag(int n) {
        return this._tagMap.containsKey(new Integer(n));
    }

    public Iterator getTagIterator() {
        return this._definedTagList.iterator();
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(TagDescriptor tagDescriptor) {
        if (tagDescriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = tagDescriptor;
    }

    public void addError(String string) {
        if (this.U__errorList == null) {
            this.U__errorList = new ArrayList();
        }
        this.U__errorList.add(string);
    }

    public boolean hasErrors() {
        return this.U__errorList != null && this.U__errorList.size() > 0;
    }

    public Iterator getErrors() {
        return this.U__errorList.iterator();
    }

    public int getErrorCount() {
        return this.U__errorList.size();
    }

    public void setInt(int n, int n2) {
        this.setObject(n, new Integer(n2));
    }

    public void setDouble(int n, double d) {
        this.setObject(n, new Double(d));
    }

    public void setFloat(int n, float f) {
        this.setObject(n, new Float(f));
    }

    public void setString(int n, String string) {
        this.setObject(n, string);
    }

    public void setBoolean(int n, boolean bl) {
        this.setObject(n, new Boolean(bl));
    }

    public void setLong(int n, long l) {
        this.setObject(n, new Long(l));
    }

    public void setDate(int n, Date date) {
        this.setObject(n, date);
    }

    public void setRational(int n, Rational rational) {
        this.setObject(n, rational);
    }

    public void setRationalArray(int n, Rational[] rationalArray) {
        this.setObjectArray(n, rationalArray);
    }

    public void setIntArray(int n, int[] nArray) {
        this.setObjectArray(n, nArray);
    }

    public void setByteArray(int n, byte[] byArray) {
        this.setObjectArray(n, byArray);
    }

    public void setStringArray(int n, String[] stringArray) {
        this.setObjectArray(n, stringArray);
    }

    public void setObject(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("cannot set a null object");
        }
        Integer n2 = new Integer(n);
        if (!this._tagMap.containsKey(n2)) {
            this._definedTagList.add(new Tag(n, this));
        }
        this._tagMap.put(n2, object);
    }

    public void setObjectArray(int n, Object object) {
        this.setObject(n, object);
    }

    /*
     * Unable to fully structure code
     */
    public int getInt(int var1_1) throws MetadataException {
        var2_2 = this.getObject(var1_1);
        if (var2_2 == null) {
            throw new MetadataException("Tag " + this.getTagName(var1_1) + " has not been set -- check using containsTag() first");
        }
        if (var2_2 instanceof String) {
            try {
                return Integer.parseInt((String)var2_2);
            }
            catch (NumberFormatException var3_3) {
                var4_4 = (String)var2_2;
                var5_5 = 0;
                var6_6 = var4_4.length() - 1;
                ** while (var6_6 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                var5_5 += var4_4.charAt(var6_6) << var6_6 * 8;
                --var6_6;
                continue;
            }
lbl15:
            // 1 sources

            return var5_5;
        }
        if (var2_2 instanceof Number) {
            return ((Number)var2_2).intValue();
        }
        throw new MetadataException("Requested tag cannot be cast to int");
    }

    public String[] getStringArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{(String)object};
            return stringArray;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            String[] stringArray = new String[nArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = Integer.toString(nArray[n2]);
                ++n2;
            }
            return stringArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            String[] stringArray = new String[byArray.length];
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray[n3] = Byte.toString(byArray[n3]);
                ++n3;
            }
            return stringArray;
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            String[] stringArray = new String[rationalArray.length];
            int n4 = 0;
            while (n4 < stringArray.length) {
                stringArray[n4] = rationalArray[n4].toSimpleString(false);
                ++n4;
            }
            return stringArray;
        }
        throw new MetadataException("Requested tag cannot be cast to String array (" + object.getClass().toString() + ")");
    }

    public int[] getIntArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            int[] nArray = new int[rationalArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = rationalArray[n2].intValue();
                ++n2;
            }
            return nArray;
        }
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int[] nArray = new int[byArray.length];
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4;
                nArray[n3] = n4 = byArray[n3];
                ++n3;
            }
            return nArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            int[] nArray = new int[string.length()];
            int n5 = 0;
            while (n5 < string.length()) {
                nArray[n5] = string.charAt(n5);
                ++n5;
            }
            return nArray;
        }
        throw new MetadataException("Requested tag cannot be cast to int array (" + object.getClass().toString() + ")");
    }

    public byte[] getByteArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            byte[] byArray = new byte[rationalArray.length];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = rationalArray[n2].byteValue();
                ++n2;
            }
            return byArray;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            byte[] byArray = new byte[nArray.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                byArray[n3] = (byte)nArray[n3];
                ++n3;
            }
            return byArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = new byte[string.length()];
            int n4 = 0;
            while (n4 < string.length()) {
                byArray[n4] = (byte)string.charAt(n4);
                ++n4;
            }
            return byArray;
        }
        throw new MetadataException("Requested tag cannot be cast to byte array (" + object.getClass().toString() + ")");
    }

    public double getDouble(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a double", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new MetadataException("Requested tag cannot be cast to double");
    }

    public float getFloat(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a float", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        throw new MetadataException("Requested tag cannot be cast to float");
    }

    public long getLong(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a long", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new MetadataException("Requested tag cannot be cast to long");
    }

    public boolean getBoolean(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            try {
                return Boolean.getBoolean((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a boolean", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        throw new MetadataException("Requested tag cannot be cast to boolean");
    }

    public Date getDate(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
            String string = (String)object;
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[n2]);
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    ++n2;
                }
            }
        }
        throw new MetadataException("Requested tag cannot be cast to java.util.Date");
    }

    public Rational getRational(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational) {
            return (Rational)object;
        }
        throw new MetadataException("Requested tag cannot be cast to Rational");
    }

    public Rational[] getRationalArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            return (Rational[])object;
        }
        throw new MetadataException("Requested tag cannot be cast to Rational array (" + object.getClass().toString() + ")");
    }

    public String getString(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Rational) {
            return ((Rational)object).toSimpleString(true);
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            boolean bl = object.getClass().toString().startsWith("class [L");
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                if (n3 != 0) {
                    stringBuffer.append(' ');
                }
                if (bl) {
                    stringBuffer.append(Array.get(object, n3).toString());
                } else {
                    stringBuffer.append(Array.getInt(object, n3));
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        return object.toString();
    }

    public Object getObject(int n) {
        return this._tagMap.get(new Integer(n));
    }

    public String getTagName(int n) {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.getTagNameMap();
        if (!hashMap.containsKey(n2)) {
            String string = Integer.toHexString(n);
            while (string.length() < 4) {
                string = "0" + string;
            }
            return "Unknown tag (0x" + string + ")";
        }
        return (String)hashMap.get(n2);
    }

    public String getDescription(int n) throws MetadataException {
        if (this._descriptor == null) {
            throw new MetadataException("a descriptor must be set using setDescriptor(...) before descriptions can be provided");
        }
        return this._descriptor.getDescription(n);
    }
}

