/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.Serializable;

public class Rational
extends Number
implements Serializable {
    private final int U_numerator;
    private final int v_denominator;
    private int u_maxSimplificationCalculations = 1000;

    public Rational(int n, int n2) {
        this.U_numerator = n;
        this.v_denominator = n2;
    }

    public double doubleValue() {
        return (double)this.U_numerator / (double)this.v_denominator;
    }

    public float floatValue() {
        return (float)this.U_numerator / (float)this.v_denominator;
    }

    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    public final int intValue() {
        return (int)this.doubleValue();
    }

    public final long longValue() {
        return (long)this.doubleValue();
    }

    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final int getDenominator() {
        return this.v_denominator;
    }

    public final int getNumerator() {
        return this.U_numerator;
    }

    public Rational getReciprocal() {
        return new Rational(this.v_denominator, this.U_numerator);
    }

    public boolean isInteger() {
        return this.v_denominator == 1 || this.v_denominator != 0 && this.U_numerator % this.v_denominator == 0 || this.v_denominator == 0 && this.U_numerator == 0;
    }

    public String toString() {
        return String.valueOf(this.U_numerator) + "/" + this.v_denominator;
    }

    public String toSimpleString(boolean bl) {
        String string;
        if (this.v_denominator == 0 && this.U_numerator != 0) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (this.U_numerator != 1 && this.v_denominator % this.U_numerator == 0) {
            int n = this.v_denominator / this.U_numerator;
            return new Rational(1, n).toSimpleString(bl);
        }
        Rational rational = this.getSimplifiedInstance();
        if (bl && (string = Double.toString(rational.doubleValue())).length() < 5) {
            return string;
        }
        return rational.toString();
    }

    private boolean V_tooComplexForSimplification() {
        double d = (double)(Math.min(this.v_denominator, this.U_numerator) - 1) / 5.0 + 2.0;
        return d > (double)this.u_maxSimplificationCalculations;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rational)) {
            return false;
        }
        Rational rational = (Rational)object;
        return this.doubleValue() == rational.doubleValue();
    }

    public Rational getSimplifiedInstance() {
        if (this.V_tooComplexForSimplification()) {
            return this;
        }
        int n = 2;
        while (n <= Math.min(this.v_denominator, this.U_numerator)) {
            if (!(n % 2 == 0 && n > 2 || n % 5 == 0 && n > 5 || this.v_denominator % n != 0 || this.U_numerator % n != 0)) {
                return new Rational(this.U_numerator / n, this.v_denominator / n);
            }
            ++n;
        }
        return this;
    }
}

