/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JpegSegmentReader {
    private final File UU__file;
    private final byte[] VV__data;
    private InputStream UV__stream;
    private HashMap Vu__segmentDataMap;
    private static final byte Uu_SEGMENT_SOS = -38;
    private static final byte Vv_MARKER_EOI = -39;
    public static final byte SEGMENT_APP0 = -32;
    public static final byte SEGMENT_APP1 = -31;
    public static final byte SEGMENT_APP2 = -30;
    public static final byte SEGMENT_APP3 = -29;
    public static final byte SEGMENT_APP4 = -28;
    public static final byte SEGMENT_APP5 = -27;
    public static final byte SEGMENT_APP6 = -26;
    public static final byte SEGMENT_APP7 = -25;
    public static final byte SEGMENT_APP8 = -24;
    public static final byte SEGMENT_APP9 = -23;
    public static final byte SEGMENT_APPA = -22;
    public static final byte SEGMENT_APPB = -21;
    public static final byte SEGMENT_APPC = -20;
    public static final byte SEGMENT_APPD = -19;
    public static final byte SEGMENT_APPE = -18;
    public static final byte SEGMENT_APPF = -17;
    public static final byte SEGMENT_SOI = -40;
    public static final byte SEGMENT_DQT = -37;
    public static final byte SEGMENT_DHT = -60;
    public static final byte SEGMENT_SOF0 = -64;
    public static final byte SEGMENT_COM = -2;

    public JpegSegmentReader(File file) throws JpegProcessingException {
        this.UU__file = file;
        this.VV__data = null;
        this.Uv_readSegments();
    }

    public JpegSegmentReader(byte[] byArray) throws JpegProcessingException {
        this.UU__file = null;
        this.VV__data = byArray;
        this.Uv_readSegments();
    }

    public JpegSegmentReader(InputStream inputStream) throws JpegProcessingException {
        this.UV__stream = inputStream;
        this.UU__file = null;
        this.VV__data = null;
        this.Uv_readSegments();
    }

    public byte[] readSegment(byte by) throws JpegProcessingException {
        return this.readSegment(by, 0);
    }

    public byte[] readSegment(byte by, int n) {
        Byte by2 = new Byte(by);
        if (this.Vu__segmentDataMap.containsKey(by2)) {
            List list = (List)this.Vu__segmentDataMap.get(by2);
            if (list.size() <= n) {
                return null;
            }
            return (byte[])list.get(n);
        }
        return null;
    }

    public final int getSegmentCount(byte by) {
        List list = (List)this.Vu__segmentDataMap.get(new Byte(by));
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void Uv_readSegments() throws JpegProcessingException {
        BufferedInputStream bufferedInputStream;
        block17: {
            this.Vu__segmentDataMap = new HashMap();
            bufferedInputStream = this.uU_getJpegInputStream();
            try {
                try {
                    int n = 0;
                    if (!this.VU_isValidJpegHeaderBytes(bufferedInputStream)) {
                        throw new JpegProcessingException("not a jpeg file");
                    }
                    n += 2;
                    while (true) {
                        List<byte[]> list;
                        byte by;
                        if (((by = (byte)(bufferedInputStream.read() & 0xFF)) & 0xFF) != 255) {
                            throw new JpegProcessingException("expected jpeg segment start identifier 0xFF at offset " + n + ", not 0x" + Integer.toHexString(by & 0xFF));
                        }
                        ++n;
                        byte by2 = (byte)(bufferedInputStream.read() & 0xFF);
                        ++n;
                        byte[] byArray = new byte[2];
                        bufferedInputStream.read(byArray, 0, 2);
                        n += 2;
                        int n2 = byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF;
                        if ((n2 -= 2) > bufferedInputStream.available()) {
                            throw new JpegProcessingException("segment size would extend beyond file stream length");
                        }
                        byte[] byArray2 = new byte[n2];
                        bufferedInputStream.read(byArray2, 0, n2);
                        n += n2;
                        if ((by2 & 0xFF) == 218) {
                            Object var10_11 = null;
                            break;
                        }
                        if ((by2 & 0xFF) == 217) {
                            break block17;
                        }
                        Byte by3 = new Byte(by2);
                        if (this.Vu__segmentDataMap.containsKey(by3)) {
                            list = (List)this.Vu__segmentDataMap.get(by3);
                        } else {
                            list = new ArrayList();
                            this.Vu__segmentDataMap.put(by3, list);
                        }
                        list.add(byArray2);
                    }
                }
                catch (IOException iOException) {
                    throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (bufferedInputStream == null) throw throwable;
                    bufferedInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
                }
            }
            try {}
            catch (IOException iOException) {
                throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
            }
            if (bufferedInputStream == null) return;
            bufferedInputStream.close();
            return;
        }
        Object var10_12 = null;
        try {}
        catch (IOException iOException) {
            throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
        }
        if (bufferedInputStream == null) return;
        bufferedInputStream.close();
    }

    private BufferedInputStream uU_getJpegInputStream() throws JpegProcessingException {
        InputStream inputStream;
        if (this.UV__stream != null) {
            if (this.UV__stream instanceof BufferedInputStream) {
                return (BufferedInputStream)this.UV__stream;
            }
            return new BufferedInputStream(this.UV__stream);
        }
        if (this.VV__data == null) {
            try {
                inputStream = new FileInputStream(this.UU__file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JpegProcessingException("Jpeg file does not exist", fileNotFoundException);
            }
        } else {
            inputStream = new ByteArrayInputStream(this.VV__data);
        }
        return new BufferedInputStream(inputStream);
    }

    private boolean VU_isValidJpegHeaderBytes(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        inputStream.read(byArray, 0, 2);
        return (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216;
    }
}

