/*
 * Decompiled with CFR 0.152.
 */
package net.dieslunae.jgraphite.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import net.dieslunae.jgraphite.gui.ToneCurveChangeListener;
import net.dieslunae.jgraphite.model.ToneCurve;
import net.dieslunae.jgraphite.util.Settings;

public class Histogram
extends JComponent
implements MouseListener,
MouseMotionListener {
    private BufferedImage image = null;
    private int[] histoData = new int[256];
    private Point[] curve = null;
    private final int BORDER = 2;
    private int mouseCurvePointIndex = -1;
    private List<ToneCurveChangeListener> curveChangeListeners = new ArrayList<ToneCurveChangeListener>();

    public Histogram() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.calcHistogram();
    }

    public void setToneCurve(ToneCurve toneCurve) {
        if (toneCurve == null) {
            this.curve = null;
            return;
        }
        this.curve = new Point[toneCurve.getPointsCount()];
        int p = 0;
        while (p < toneCurve.getPointsCount()) {
            this.curve[p] = this.toScreenPoint(toneCurve.getPoint(p));
            ++p;
        }
    }

    public void addToneCurveChangeListener(ToneCurveChangeListener l) {
        this.curveChangeListeners.add(l);
    }

    private void notifyCurveChange() {
        if (this.curveChangeListeners.size() == 0) {
            return;
        }
        Point[] newCurve = new Point[this.curve.length];
        int p = 0;
        while (p < this.curve.length) {
            newCurve[p] = this.toCurvePoint(this.curve[p]);
            ++p;
        }
        ToneCurve tc = new ToneCurve(Settings.TXT_TC_CUSTOM, newCurve);
        for (ToneCurveChangeListener l : this.curveChangeListeners) {
            l.toneCurveChanged(tc);
        }
    }

    public Point[] getPoints() {
        Point[] points = new Point[this.curve.length];
        int p = 0;
        while (p < this.curve.length) {
            points[p] = this.toCurvePoint(this.curve[p]);
            ++p;
        }
        return points;
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension dim = this.getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, dim.width - 1, dim.height - 1);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, dim.width - 1, dim.height - 1);
        if (this.image != null) {
            int max = 0;
            int[] nArray = this.histoData;
            int n = this.histoData.length;
            int n2 = 0;
            while (n2 < n) {
                int v = nArray[n2];
                if (v > max) {
                    max = v;
                }
                ++n2;
            }
            float dx = (float)(dim.width - 4) / 256.0f;
            float dy = (float)(dim.height - 4) / (float)max;
            int barWidth = (int)dx < 1 ? 1 : (int)dx;
            g.setColor(Color.GRAY);
            int i = 0;
            while (i < 256) {
                int x = (int)((float)i * dx);
                int barHeight = (int)((float)this.histoData[i] * dy);
                g.fillRect(x + 2, dim.height - barHeight - 2, barWidth, barHeight);
                ++i;
            }
        }
        if (this.curve == null) {
            return;
        }
        g.setColor(Color.BLUE);
        int p = 0;
        while (p < this.curve.length) {
            g.drawRect(this.curve[p].x - 1, this.curve[p].y - 1, 2, 2);
            ++p;
        }
        p = 0;
        while (p < this.curve.length - 1) {
            g.drawLine(this.curve[p].x, this.curve[p].y, this.curve[p + 1].x, this.curve[p + 1].y);
            ++p;
        }
    }

    private Point toScreenPoint(Point curvePoint) {
        int px = (int)((double)this.getWidth() - 4.0) * curvePoint.x / 255 + 2;
        int py = this.getHeight() - (int)(((double)this.getHeight() - 4.0) * (double)curvePoint.y / 255.0) - 2;
        return new Point(px, py);
    }

    private Point toCurvePoint(Point screenPoint) {
        int cx = (int)((double)screenPoint.x - 2.0) * 255 / (this.getWidth() - 4);
        int cy = 255 - (int)((double)screenPoint.y - 2.0) * 255 / (this.getHeight() - 4);
        if (++cx < 0) {
            cx = 0;
        }
        if (cy < 0) {
            cy = 0;
        }
        if (cx > 255) {
            cx = 255;
        }
        if (cy > 255) {
            cy = 255;
        }
        return new Point(cx, cy);
    }

    private int findPointUnderMouse(Point p) {
        if (this.curve == null) {
            return -1;
        }
        int result = -1;
        int i = 0;
        while (i < this.curve.length) {
            if (p.x - 2 <= this.curve[i].x && p.x + 2 >= this.curve[i].x && p.y - 2 <= this.curve[i].y && p.y + 2 >= this.curve[i].y) {
                return i;
            }
            ++i;
        }
        return result;
    }

    private void calcHistogram() {
        if (this.image == null) {
            return;
        }
        Arrays.fill(this.histoData, 0);
        WritableRaster imgRast = this.image.getRaster();
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int bands = imgRast.getNumBands();
        if (bands != 1 && bands != 3) {
            System.out.println("Wrong no of bands: " + bands);
            return;
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int value = 0;
                if (bands == 1) {
                    value = imgRast.getSample(x, y, 0);
                } else {
                    int r = imgRast.getSample(x, y, 0);
                    int g = imgRast.getSample(x, y, 1);
                    int b = imgRast.getSample(x, y, 2);
                    value = (r + g + b) / 3;
                }
                if (value < 0) {
                    value = 0;
                }
                if (value > 255) {
                    value = 255;
                }
                int n = value;
                this.histoData[n] = this.histoData[n] + 1;
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 2) {
            return;
        }
        if (this.curve == null || this.curve.length == 0) {
            return;
        }
        this.mouseCurvePointIndex = this.findPointUnderMouse(e.getPoint());
        if (e.getButton() == 1 && this.mouseCurvePointIndex == -1) {
            Point mp = e.getPoint();
            int p = 0;
            while (p < this.curve.length - 1) {
                if (mp.x > this.curve[p].x && mp.x < this.curve[p + 1].x) {
                    Point[] newCurve = new Point[this.curve.length + 1];
                    int i = 0;
                    while (i <= p) {
                        newCurve[i] = this.curve[i];
                        ++i;
                    }
                    newCurve[i++] = mp;
                    while (i < newCurve.length) {
                        newCurve[i] = this.curve[i - 1];
                        ++i;
                    }
                    this.curve = newCurve;
                    this.repaint();
                    this.mouseCurvePointIndex = p + 1;
                    break;
                }
                ++p;
            }
        } else if (e.getButton() == 3 && this.mouseCurvePointIndex > 0 && this.mouseCurvePointIndex < this.curve.length - 1) {
            Point[] newCurve = new Point[this.curve.length - 1];
            int i = 0;
            while (i < this.mouseCurvePointIndex) {
                newCurve[i] = this.curve[i];
                ++i;
            }
            while (i < newCurve.length) {
                newCurve[i] = this.curve[i + 1];
                ++i;
            }
            this.mouseCurvePointIndex = -1;
            this.curve = newCurve;
            this.repaint();
            this.notifyCurveChange();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseCurvePointIndex > 0 && this.mouseCurvePointIndex < this.curve.length - 1) {
            this.notifyCurveChange();
        }
        this.mouseCurvePointIndex = -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.curve != null && this.mouseCurvePointIndex > 0 && this.mouseCurvePointIndex < this.curve.length - 1) {
            Point p = e.getPoint();
            if (p.x <= this.curve[this.mouseCurvePointIndex - 1].x) {
                p.x = this.curve[this.mouseCurvePointIndex - 1].x + 1;
            }
            if (p.x >= this.curve[this.mouseCurvePointIndex + 1].x) {
                p.x = this.curve[this.mouseCurvePointIndex + 1].x - 1;
            }
            if (p.y > this.getHeight() - 2) {
                p.y = this.getHeight() - 2;
            }
            if (p.y < 2) {
                p.y = 2;
            }
            this.curve[this.mouseCurvePointIndex] = p;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

