/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

class IconEdit1Draw
extends JPanel
implements MouseListener,
MouseMotionListener {
    int gridBorder;
    int gridLeft;
    int gridTop;
    int gridSize;
    int gridStep;
    int gridTotal;
    int gridWidth;
    IconEdit1Icon iconSource;
    int mouseButton;
    boolean mouseClicks;

    public IconEdit1Draw(IconEdit1Icon iconEdit1Icon, boolean bl) {
        this.iconSource = iconEdit1Icon;
        this.mouseClicks = bl;
        if (this.mouseClicks) {
            this.mouseButton = 0;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        this.setBackground(IconEdit1.BACKGROUND);
    }

    public void doMouseEvent(MouseEvent mouseEvent) {
        int n = (mouseEvent.getX() - this.gridLeft - this.gridBorder) / this.gridStep;
        int n2 = (mouseEvent.getY() - this.gridTop - this.gridBorder) / this.gridStep;
        boolean bl = false;
        if (n >= 0 && n < this.iconSource.size && n2 >= 0 && n2 < this.iconSource.size) {
            if (mouseEvent.isControlDown() || this.mouseButton == 2 || this.mouseButton == 3) {
                if (!this.iconSource.colors[n2][n].equals(Color.BLACK) || this.iconSource.isOpaque[n2][n]) {
                    this.iconSource.colors[n2][n] = Color.BLACK;
                    this.iconSource.isOpaque[n2][n] = false;
                    bl = true;
                }
            } else if (mouseEvent.isShiftDown()) {
                Color color = this.iconSource.isOpaque[n2][n] ? this.iconSource.colors[n2][n] : this.iconSource.iconBackground;
                if (!color.equals(IconEdit1.colorChooser.getColor())) {
                    IconEdit1.colorChooser.setColor(color);
                }
            } else if (!this.iconSource.colors[n2][n].equals(IconEdit1.selectColor) || !this.iconSource.isOpaque[n2][n]) {
                this.iconSource.colors[n2][n] = IconEdit1.selectColor;
                this.iconSource.isOpaque[n2][n] = true;
                bl = true;
            }
        }
        if (bl) {
            this.iconSource.bigIcon.repaint();
            this.iconSource.smallIcon.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseButton = mouseEvent.getButton();
        this.doMouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.doMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseButton = mouseEvent.getButton();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (IconEdit1.menuGridHide.isSelected()) {
            this.gridWidth = 0;
            this.gridBorder = 0;
            this.gridStep = Math.min(this.getHeight() / this.iconSource.size, this.getWidth() / this.iconSource.size);
            this.gridSize = this.gridStep = Math.max(this.gridStep, 1);
            this.gridTotal = this.iconSource.size * this.gridStep;
            this.gridLeft = (this.getWidth() - this.gridTotal) / 2;
            this.gridTop = (this.getHeight() - this.gridTotal) / 2;
        } else {
            this.gridBorder = Math.min(this.getHeight(), this.getWidth()) > 6 * this.iconSource.size ? 2 : 1;
            this.gridWidth = 1;
            this.gridStep = Math.min((this.getHeight() + this.gridWidth - 2 * this.gridBorder) / this.iconSource.size, (this.getWidth() + this.gridWidth - 2 * this.gridBorder) / this.iconSource.size);
            this.gridStep = Math.max(this.gridStep, 1);
            this.gridSize = this.gridStep - this.gridWidth;
            if (this.gridSize < 8) {
                this.gridWidth = 0;
                this.gridStep = Math.min((this.getHeight() - 2 * this.gridBorder) / this.iconSource.size, (this.getWidth() - 2 * this.gridBorder) / this.iconSource.size);
                this.gridSize = this.gridStep = Math.max(this.gridStep, 1);
            }
            this.gridTotal = 2 * this.gridBorder + this.iconSource.size * this.gridStep - this.gridWidth;
            this.gridLeft = (this.getWidth() - this.gridTotal) / 2;
            this.gridTop = (this.getHeight() - this.gridTotal) / 2;
            if (IconEdit1.menuGridBack.isSelected()) {
                graphics.setColor(this.iconSource.iconBackground);
            } else {
                graphics.setColor(IconEdit1.GRID_COLOR);
            }
            graphics.fillRect(this.gridLeft, this.gridTop, this.gridTotal, this.gridTotal);
        }
        for (int i = 0; i < this.iconSource.size; ++i) {
            for (int j = 0; j < this.iconSource.size; ++j) {
                if (this.iconSource.isOpaque[i][j]) {
                    graphics.setColor(IconEdit1.getCloseColor(this.iconSource.colorDepth, this.iconSource.colors[i][j]));
                } else {
                    graphics.setColor(this.iconSource.iconBackground);
                }
                graphics.fillRect(this.gridLeft + this.gridBorder + this.gridStep * j, this.gridTop + this.gridBorder + this.gridStep * i, this.gridSize, this.gridSize);
            }
        }
    }
}

