/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.grelf.FileIO;
import net.grelf.Util;
import net.grelf.image.Exif;
import net.grelf.image.FITS;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image32;
import net.grelf.image.Image8;
import net.grelf.image.Image8or16Base;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Metadata;
import net.grelf.image.Timer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageLoader {
    private static final Map<String, String> formats = new HashMap<String, String>();

    public static String getFormat(String string) {
        return formats.get(FileIO.getExtension(string).toLowerCase());
    }

    public static Image load(String string) {
        File file = new File(string);
        return ImageLoader.load(file);
    }

    public static Image load(File file) {
        List<Image> list = ImageLoader.loadAll(file);
        if (null == list || 0 == list.size()) {
            return null;
        }
        return list.get(0);
    }

    public static List<Image> loadAll(String string) {
        return ImageLoader.loadAll(new File(string));
    }

    public static List<Image> loadAll(File file) {
        ArrayList<Image> arrayList;
        Timer timer;
        block15: {
            if (!file.exists()) {
                Util.warning("Error", "File " + file.getPath() + "\ndoes not exist");
                return null;
            }
            if (file.isDirectory()) {
                Util.warning("Error", file.getPath() + "\nis a directory, not an image file");
                return null;
            }
            timer = new Timer("ImageLoader.load (" + file.getName() + ")");
            arrayList = null;
            String string = file.getName().toLowerCase();
            if (string.endsWith(".accum")) {
                arrayList = new ArrayList();
                Image32 image32 = new Image32(file.getPath());
                if (null != image32) {
                    arrayList.add(image32);
                }
            } else if (string.endsWith(".fits")) {
                arrayList = new FITS().loadImage(file);
            } else {
                arrayList = new ArrayList();
                try {
                    String string2 = ImageLoader.getFormat(file.getName());
                    if (null == string2) break block15;
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string2);
                    IIOImage iIOImage = null;
                    ImageReader imageReader = null;
                    while (iterator.hasNext() && null == iIOImage) {
                        imageReader = iterator.next();
                        imageReader.setInput(new FileImageInputStream(file));
                        int n = imageReader.getNumImages(true);
                        if (n <= 0) continue;
                        iIOImage = imageReader.readAll(0, null);
                    }
                    if (null == iIOImage) {
                        String string3 = "No reader available for " + file.getName();
                        Util.warning("Error", string3);
                        break block15;
                    }
                    if (null == iIOImage.getRenderedImage()) {
                        if (null != imageReader) {
                            imageReader.dispose();
                        }
                        String string4 = "No image loaded from " + file.getName();
                        Util.warning("Error", string4);
                        break block15;
                    }
                    BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
                    String string5 = imageReader.getClass().getName();
                    Util.logInfo("Reader class: {0}", string5);
                    imageReader.dispose();
                    boolean bl = -1 != string5.indexOf("it.tidalwave");
                    Image8or16Base image8or16Base = null;
                    int n = bufferedImage.getSampleModel().getSampleSize(0);
                    try {
                        image8or16Base = 8 == n ? new Image8(bufferedImage) : new Image16(bufferedImage, bl);
                    }
                    catch (IncompatibleImageException incompatibleImageException) {
                        Util.logWarning(incompatibleImageException.toString());
                    }
                    Map<String, String> map = ImageLoader.getImageMetadataAsMap(iIOImage, file.getPath());
                    image8or16Base.setMetadata(new Metadata(map));
                    image8or16Base.setFilePath(file.getPath());
                    arrayList.add(image8or16Base);
                }
                catch (IOException iOException) {
                    Util.logWarning(iOException.toString());
                    Util.warning("Error", "Could not load image " + (null != file ? file.getPath() : ""));
                }
            }
        }
        timer.stop();
        return arrayList;
    }

    private static Map<String, String> getImageMetadataAsMap(IIOImage iIOImage, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (null != iIOImage) {
            boolean bl = false;
            try {
                XPath xPath;
                String[] stringArray;
                IIOMetadata iIOMetadata = iIOImage.getMetadata();
                if (null != iIOMetadata && null != (stringArray = iIOMetadata.getMetadataFormatNames()) && null != (xPath = XPathFactory.newInstance().newXPath())) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string2;
                        Node node;
                        int n;
                        Node node2;
                        if (null == stringArray[i] || null == (node2 = iIOMetadata.getAsTree(stringArray[i]))) continue;
                        String string3 = "//TIFFField";
                        NodeList nodeList = (NodeList)xPath.evaluate(string3, node2, XPathConstants.NODESET);
                        if (null != nodeList) {
                            for (n = 0; n < nodeList.getLength(); ++n) {
                                node = nodeList.item(n);
                                if (null == node) continue;
                                string3 = "@name";
                                string2 = xPath.evaluate(string3, node);
                                string3 = ".//@value";
                                String string4 = xPath.evaluate(string3, node);
                                if (null == string2 || null == string4) continue;
                                bl = true;
                                hashMap.put(string2, string4);
                            }
                        }
                        if (null == (nodeList = (NodeList)xPath.evaluate(string3 = "//TIFFAscii[starts-with(@value,'ImageKind=')]", node2, XPathConstants.NODESET))) continue;
                        for (n = 0; n < nodeList.getLength(); ++n) {
                            node = nodeList.item(n);
                            if (null == node || !(node instanceof Element)) continue;
                            string2 = ((Element)node).getAttribute("value");
                            hashMap.put("ImageKind", string2);
                        }
                    }
                }
                if (!bl && null != string) {
                    Exif.putMetadataInMap(string, hashMap);
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                Util.logWarning("XPath error in parsing metadata");
            }
            catch (NullPointerException nullPointerException) {
                Util.logWarning("NullPointerException in getting image metadata. ");
            }
        }
        return hashMap;
    }

    static {
        formats.put(".bmp", "bmp");
        formats.put(".cr2", "cr2");
        formats.put(".crw", "crw");
        formats.put(".dng", "dng");
        formats.put(".gif", "gif");
        formats.put(".jpeg", "jpeg");
        formats.put(".jpg", "jpeg");
        formats.put(".mrw", "mrw");
        formats.put(".nef", "nef");
        formats.put(".pef", "pef");
        formats.put(".png", "png");
        formats.put(".srf", "srf");
        formats.put(".tif", "tiff");
        formats.put(".tiff", "tiff");
    }
}

