/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import net.grelf.Util;
import net.grelf.image.Calibration;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8;
import net.grelf.image.Metadata;
import net.grelf.image.MetadataDialogue;

public abstract class ImageBase {
    private Calibration calibration = new Calibration();
    private String filePath;
    private static GraphicsConfiguration graphicsConfig = null;
    protected Metadata metadata;

    public Calibration getCalibration() {
        return this.calibration;
    }

    public void setCalibration(Calibration calibration) {
        this.calibration = new Calibration(calibration);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return graphicsConfig;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public static Image createImage(int n, int n2, int n3, int n4) {
        return ImageBase.createImage(n, n2, n3, n4, false, true);
    }

    public static Image createImage(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        switch (n4) {
            case 8: {
                return new Image8(n, n2, n3, bl, bl2);
            }
            case 16: {
                return new Image16(n, n2, n3, bl);
            }
            case 32: {
                return new Image32(n, n2, n3, bl);
            }
            case 64: {
                return new Image64(n, n2, n3, bl);
            }
        }
        return null;
    }

    public static Image recombine(Image ... imageArray) {
        int n;
        int n2;
        int n3;
        if (!ImageBase.sameSizeBitsAndBands(imageArray)) {
            Util.warning("Error", "Images are not compatible for recombining");
            return null;
        }
        int n4 = imageArray[0].getWidth();
        Image image = ImageBase.createImage(n4, n3 = imageArray[0].getHeight(), n2 = imageArray.length, n = imageArray[0].getBitsPerChannel(), false, false);
        if (null == image) {
            Util.warning("Error", "Could not create recombined image");
            return null;
        }
        if (64 == n) {
            double[] dArray = new double[n2];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        dArray[k] = imageArray[k].getPixelDouble(j, i)[0];
                    }
                    image.setPixelDouble(j, i, dArray);
                }
            }
            image.getRangeByRescanningDouble();
        } else {
            int[] nArray = new int[n2];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = imageArray[k].getPixel(j, i)[0];
                    }
                    image.setPixel(j, i, nArray);
                }
            }
            if (32 == n) {
                image.getRangeByRescanning();
            }
        }
        return image;
    }

    public static boolean sameBitsAndBands(Image ... imageArray) {
        if (2 > imageArray.length) {
            return true;
        }
        int n = imageArray[0].getBitsPerChannel();
        int n2 = imageArray[0].getNBands();
        for (int i = 1; i < imageArray.length; ++i) {
            if (n != imageArray[i].getBitsPerChannel()) {
                return false;
            }
            if (n2 == imageArray[i].getNBands()) continue;
            return false;
        }
        return true;
    }

    public static boolean sameSizeBitsAndBands(Image ... imageArray) {
        if (2 > imageArray.length) {
            return true;
        }
        int n = imageArray[0].getWidth();
        int n2 = imageArray[0].getHeight();
        int n3 = imageArray[0].getBitsPerChannel();
        int n4 = imageArray[0].getNBands();
        for (int i = 1; i < imageArray.length; ++i) {
            if (n != imageArray[i].getWidth()) {
                return false;
            }
            if (n2 != imageArray[i].getHeight()) {
                return false;
            }
            if (n3 != imageArray[i].getBitsPerChannel()) {
                return false;
            }
            if (n4 == imageArray[i].getNBands()) continue;
            return false;
        }
        return true;
    }

    protected void showInfo(Image image) {
        new MetadataDialogue(image);
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        graphicsConfig = graphicsDevice.getDefaultConfiguration();
    }
}

